/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.persistence;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.neoforge.WorldDataProviderImpl;
import net.shiroha233.roadweaver.structures.model.StructureInstance;

public abstract class WorldDataProvider {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static WorldDataProvider getInstance() {
        return WorldDataProviderImpl.getInstance();
    }

    public abstract Records.StructureLocationData getStructureLocations(ServerLevel var1);

    public abstract void setStructureLocations(ServerLevel var1, Records.StructureLocationData var2);

    public abstract List<Records.StructureConnection> getStructureConnections(ServerLevel var1);

    public abstract void setStructureConnections(ServerLevel var1, List<Records.StructureConnection> var2);

    public abstract Set<Long> getPlannedTileKeys(ServerLevel var1);

    public abstract void setPlannedTileKeys(ServerLevel var1, Set<Long> var2);

    public abstract Map<Long, Long> getPlannedTileCenters(ServerLevel var1);

    public abstract void setPlannedTileCenters(ServerLevel var1, Map<Long, Long> var2);

    public abstract List<StructureInstance> getStructureInstances(ServerLevel var1);

    public abstract void setStructureInstances(ServerLevel var1, List<StructureInstance> var2);

    public void addStructureLocation(ServerLevel level, BlockPos pos) {
        Records.StructureLocationData data = this.getStructureLocations(level);
        ArrayList<BlockPos> locations = new ArrayList<BlockPos>(data.structureLocations());
        if (!locations.contains(pos)) {
            locations.add(pos);
            this.setStructureLocations(level, new Records.StructureLocationData(locations));
        }
    }

    public void addStructureInstance(ServerLevel level, StructureInstance inst) {
        if (inst == null) {
            return;
        }
        ArrayList origin = this.getStructureInstances(level);
        ArrayList<StructureInstance> copy = new ArrayList<StructureInstance>(origin != null ? origin : new ArrayList());
        boolean exists = false;
        for (StructureInstance s : copy) {
            if (s == null || !s.anchorPos().equals((Object)inst.anchorPos()) || !s.blueprintId().equals((Object)inst.blueprintId())) continue;
            exists = true;
            break;
        }
        if (!exists) {
            copy.add(inst);
            this.setStructureInstances(level, copy);
        }
    }
}

