/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.persistence.neoforge;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;

public final class WorldDataHelper {
    private WorldDataHelper() {
    }

    public static Records.StructureLocationData getStructureLocations(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            return WorldDataProvider.getInstance().getStructureLocations(server);
        }
        return new Records.StructureLocationData(new ArrayList<BlockPos>());
    }

    public static List<Records.StructureConnection> getConnectedStructures(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            return WorldDataProvider.getInstance().getStructureConnections(server);
        }
        return new ArrayList<Records.StructureConnection>();
    }

    public static void setStructureLocations(Level level, Records.StructureLocationData data) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            WorldDataProvider.getInstance().setStructureLocations(server, data);
        }
    }

    public static void setStructureConnections(Level level, List<Records.StructureConnection> connections) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            WorldDataProvider.getInstance().setStructureConnections(server, connections);
        }
    }
}

