/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.planning.neoforge;

import java.util.List;
import java.util.Objects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.shiroha233.roadweaver.generation.InitialGenManager;
import net.shiroha233.roadweaver.generation.RoadGenerationService;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;
import net.shiroha233.roadweaver.persistence.sharded.RoadShardStorage;
import net.shiroha233.roadweaver.planning.RoadPlanningService;
import net.shiroha233.roadweaver.runtime.ThreadPoolManager;
import net.shiroha233.roadweaver.structures.StructureSystem;
import net.shiroha233.roadweaver.structures.index.StructureIndexRestorer;
import net.shiroha233.roadweaver.util.ComputeService;

public final class ServerPlanningHooks {
    private static int tick;

    private ServerPlanningHooks() {
    }

    public static void register(IEventBus modBus) {
        NeoForge.EVENT_BUS.addListener(ServerPlanningHooks::onServerStarted);
        NeoForge.EVENT_BUS.addListener(ServerPlanningHooks::onServerTick);
        NeoForge.EVENT_BUS.addListener(ServerPlanningHooks::onServerStopping);
    }

    private static void onServerStarted(ServerStartedEvent event) {
        StructureSystem.clearAll();
        ThreadPoolManager.onServerStarted(event.getServer());
        ServerLevel level = event.getServer().getLevel(Objects.requireNonNull(Level.OVERWORLD));
        if (level == null) {
            return;
        }
        StructureIndexRestorer.restore(level);
        boolean dedicated = event.getServer().isDedicatedServer();
        if (dedicated) {
            RoadGenerationService.onServerStarted();
            RoadPlanningService.initialPlanAsync(level);
            return;
        }
        List<Records.StructureConnection> conns = WorldDataProvider.getInstance().getStructureConnections(level);
        if (conns == null || conns.isEmpty()) {
            InitialGenManager.begin(level);
            InitialGenManager.blockUntilDone(level);
        } else {
            RoadGenerationService.onServerStarted();
        }
    }

    private static void onServerTick(ServerTickEvent.Post event) {
        ServerLevel level;
        MinecraftServer server = event.getServer();
        if (server == null) {
            return;
        }
        if (tick++ % 20 == 0) {
            for (ServerPlayer p : server.getPlayerList().getPlayers()) {
                RoadPlanningService.planAroundPlayer(p);
            }
        }
        if ((level = server.getLevel(Objects.requireNonNull(Level.OVERWORLD))) != null) {
            RoadGenerationService.tick(level);
        }
    }

    private static void onServerStopping(ServerStoppingEvent event) {
        MinecraftServer server = event.getServer();
        for (ServerLevel lvl : server.getAllLevels()) {
            RoadShardStorage.flushAll(lvl);
            RoadShardStorage.clearAll(lvl);
        }
        RoadGenerationService.onServerStopping();
        StructureSystem.clearAll();
        ComputeService.shutdownNow();
    }
}

