/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.search;

import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.search.StructurePredictor;
import net.shiroha233.roadweaver.search.StructureVerificationService;

public final class StructureIndexService {
    private StructureIndexService() {
    }

    public static List<Records.StructureInfo> predictAndVerifyAroundSpawn(ServerLevel level) {
        if (level == null) {
            return List.of();
        }
        ModConfig cfg = ConfigService.get();
        if (!cfg.villagePredictionEnabled()) {
            return List.of();
        }
        List<Records.StructureInfo> predicted = StructurePredictor.predictOverworldStructuresAroundSpawn(level, cfg.predictRadiusChunks(), cfg.biomePrefilter(), cfg.structureWhitelist(), cfg.structureBlacklist());
        return StructureVerificationService.verifyPredictedStructures(level, predicted);
    }

    public static List<Records.StructureInfo> predictAndVerifyInRect(ServerLevel level, int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        if (level == null) {
            return List.of();
        }
        ModConfig cfg = ConfigService.get();
        if (!cfg.villagePredictionEnabled()) {
            return List.of();
        }
        int cminx = Math.floorDiv(minBlockX, 16);
        int cminz = Math.floorDiv(minBlockZ, 16);
        int cmaxx = Math.floorDiv(maxBlockX, 16);
        int cmaxz = Math.floorDiv(maxBlockZ, 16);
        List<Records.StructureInfo> predicted = StructurePredictor.predictOverworldStructuresInRect(level, cminx, cminz, cmaxx, cmaxz, cfg.biomePrefilter(), cfg.structureWhitelist(), cfg.structureBlacklist());
        return StructureVerificationService.verifyPredictedStructures(level, predicted);
    }
}

