/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.shiroha233.roadweaver.helpers.Records;

public final class StructurePredictor {
    private StructurePredictor() {
    }

    public static List<Records.StructureInfo> predictOverworldVillagesAroundSpawn(ServerLevel level, int radiusChunks, boolean biomePrefilter) {
        RegistryAccess registryAccess = level.registryAccess();
        Registry setRegistry = registryAccess.registryOrThrow(Registries.STRUCTURE_SET);
        Optional optVillages = setRegistry.getHolder(BuiltinStructureSets.VILLAGES);
        if (optVillages.isEmpty()) {
            return List.of();
        }
        StructureSet set = (StructureSet)((Holder.Reference)optVillages.get()).value();
        StructurePlacement placement = set.placement();
        if (!(placement instanceof RandomSpreadStructurePlacement)) {
            return List.of();
        }
        RandomSpreadStructurePlacement rssp = (RandomSpreadStructurePlacement)placement;
        BlockPos spawn = level.getSharedSpawnPos();
        int cx = spawn.getX() >> 4;
        int cz = spawn.getZ() >> 4;
        int minX = cx - radiusChunks;
        int maxX = cx + radiusChunks;
        int minZ = cz - radiusChunks;
        int maxZ = cz + radiusChunks;
        ChunkGeneratorStructureState state = level.getChunkSource().getGeneratorState();
        RandomState randomState = state.randomState();
        BiomeSource biomeSource = level.getChunkSource().getGenerator().getBiomeSource();
        HashSet<Holder> allowedBiomes = null;
        if (biomePrefilter) {
            allowedBiomes = new HashSet<Holder>();
            for (StructureSet.StructureSelectionEntry entry : set.structures()) {
                Structure structure = (Structure)entry.structure().value();
                for (Holder b : structure.biomes()) {
                    allowedBiomes.add(b);
                }
            }
        }
        int spacing = rssp.spacing();
        int startI = Math.floorDiv(minX, spacing);
        int endI = Math.floorDiv(maxX, spacing);
        int startJ = Math.floorDiv(minZ, spacing);
        int endJ = Math.floorDiv(maxZ, spacing);
        long seed = level.getSeed();
        ArrayList<Records.StructureInfo> result = new ArrayList<Records.StructureInfo>();
        for (int i = startI; i <= endI; ++i) {
            for (int j = startJ; j <= endJ; ++j) {
                int qz;
                int qy;
                int qx;
                Holder sample;
                int baseX = i * spacing;
                int baseZ = j * spacing;
                ChunkPos candidate = rssp.getPotentialStructureChunk(seed, baseX, baseZ);
                int x = candidate.x;
                int z = candidate.z;
                if (x < minX || x > maxX || z < minZ || z > maxZ || !placement.isStructureChunk(state, x, z)) continue;
                BlockPos locatePos = placement.getLocatePos(candidate);
                if (biomePrefilter && allowedBiomes != null && !allowedBiomes.contains(sample = biomeSource.getNoiseBiome(qx = QuartPos.fromBlock((int)locatePos.getX()), qy = QuartPos.fromBlock((int)64), qz = QuartPos.fromBlock((int)locatePos.getZ()), randomState.sampler()))) continue;
                result.add(new Records.StructureInfo(locatePos, "village"));
            }
        }
        return result;
    }

    public static List<Records.StructureInfo> predictOverworldStructuresInRect(ServerLevel level, int minChunkX, int minChunkZ, int maxChunkX, int maxChunkZ, boolean biomePrefilter, List<String> whitelist, List<String> blacklist) {
        RegistryAccess access = level.registryAccess();
        Registry setRegistry = access.registryOrThrow(Registries.STRUCTURE_SET);
        ChunkGeneratorStructureState state = level.getChunkSource().getGeneratorState();
        RandomState randomState = state.randomState();
        BiomeSource biomeSource = level.getChunkSource().getGenerator().getBiomeSource();
        Filters filters = Filters.of(whitelist, blacklist);
        ArrayList<Records.StructureInfo> result = new ArrayList<Records.StructureInfo>();
        for (Holder.Reference holder : setRegistry.holders().toList()) {
            ResourceLocation id;
            Object key;
            Holder structureHolder;
            StructureSet set = (StructureSet)holder.value();
            StructurePlacement placement = set.placement();
            if (!(placement instanceof RandomSpreadStructurePlacement)) continue;
            RandomSpreadStructurePlacement rssp = (RandomSpreadStructurePlacement)placement;
            ArrayList<Holder> matchedStructures = new ArrayList<Holder>();
            for (Object entry : set.structures()) {
                structureHolder = entry.structure();
                key = structureHolder.unwrapKey();
                if (((Optional)key).isEmpty() || !filters.matches((Holder<Structure>)structureHolder, id = ((ResourceKey)((Optional)key).get()).location())) continue;
                matchedStructures.add(structureHolder);
            }
            if (matchedStructures.isEmpty()) {
                if (filters.hasWhitelist()) continue;
                for (Object entry : set.structures()) {
                    structureHolder = entry.structure();
                    key = structureHolder.unwrapKey();
                    if (((Optional)key).isEmpty() || filters.isBlacklisted((Holder<Structure>)structureHolder, id = ((ResourceKey)((Optional)key).get()).location())) continue;
                    matchedStructures.add(structureHolder);
                }
                if (matchedStructures.isEmpty()) continue;
            }
            HashSet<Holder> allowedBiomes = null;
            if (biomePrefilter) {
                Object entry;
                allowedBiomes = new HashSet<Holder>();
                entry = matchedStructures.iterator();
                while (entry.hasNext()) {
                    Holder h2 = (Holder)entry.next();
                    for (Holder b : ((Structure)h2.value()).biomes()) {
                        allowedBiomes.add(b);
                    }
                }
            }
            int spacing = rssp.spacing();
            int startI = Math.floorDiv(minChunkX, spacing);
            int endI = Math.floorDiv(maxChunkX, spacing);
            int startJ = Math.floorDiv(minChunkZ, spacing);
            int endJ = Math.floorDiv(maxChunkZ, spacing);
            String labelId = matchedStructures.stream().map(h -> h.unwrapKey().map(ResourceKey::location).map(ResourceLocation::toString).orElse("structure")).findFirst().orElse("structure");
            for (int i = startI; i <= endI; ++i) {
                for (int j = startJ; j <= endJ; ++j) {
                    int baseX = i * spacing;
                    int baseZ = j * spacing;
                    ChunkPos candidate = rssp.getPotentialStructureChunk(level.getSeed(), baseX, baseZ);
                    int x = candidate.x;
                    int z = candidate.z;
                    if (x < minChunkX || x > maxChunkX || z < minChunkZ || z > maxChunkZ || !placement.isStructureChunk(state, x, z)) continue;
                    BlockPos locatePos = placement.getLocatePos(candidate);
                    int qx = QuartPos.fromBlock((int)locatePos.getX());
                    int qy = QuartPos.fromBlock((int)64);
                    int qz = QuartPos.fromBlock((int)locatePos.getZ());
                    Holder sample = biomeSource.getNoiseBiome(qx, qy, qz, randomState.sampler());
                    if (biomePrefilter && allowedBiomes != null && !allowedBiomes.contains(sample)) continue;
                    String chosenId = labelId;
                    for (Holder h3 : matchedStructures) {
                        if (!((Structure)h3.value()).biomes().contains(sample)) continue;
                        chosenId = h3.unwrapKey().map(ResourceKey::location).map(ResourceLocation::toString).orElse(labelId);
                        break;
                    }
                    result.add(new Records.StructureInfo(locatePos, chosenId));
                }
            }
        }
        return result;
    }

    public static List<Records.StructureInfo> predictOverworldStructuresAroundSpawn(ServerLevel level, int radiusChunks, boolean biomePrefilter, List<String> whitelist, List<String> blacklist) {
        RegistryAccess access = level.registryAccess();
        Registry setRegistry = access.registryOrThrow(Registries.STRUCTURE_SET);
        BlockPos spawn = level.getSharedSpawnPos();
        int cx = spawn.getX() >> 4;
        int cz = spawn.getZ() >> 4;
        int minX = cx - radiusChunks;
        int maxX = cx + radiusChunks;
        int minZ = cz - radiusChunks;
        int maxZ = cz + radiusChunks;
        ChunkGeneratorStructureState state = level.getChunkSource().getGeneratorState();
        RandomState randomState = state.randomState();
        BiomeSource biomeSource = level.getChunkSource().getGenerator().getBiomeSource();
        Filters filters = Filters.of(whitelist, blacklist);
        ArrayList<Records.StructureInfo> result = new ArrayList<Records.StructureInfo>();
        for (Holder.Reference holder : setRegistry.holders().toList()) {
            ResourceLocation id;
            Object key;
            Holder structureHolder;
            StructureSet set = (StructureSet)holder.value();
            StructurePlacement placement = set.placement();
            if (!(placement instanceof RandomSpreadStructurePlacement)) continue;
            RandomSpreadStructurePlacement rssp = (RandomSpreadStructurePlacement)placement;
            ArrayList<Holder> matchedStructures = new ArrayList<Holder>();
            for (Object entry : set.structures()) {
                structureHolder = entry.structure();
                key = structureHolder.unwrapKey();
                if (((Optional)key).isEmpty() || !filters.matches((Holder<Structure>)structureHolder, id = ((ResourceKey)((Optional)key).get()).location())) continue;
                matchedStructures.add(structureHolder);
            }
            if (matchedStructures.isEmpty()) {
                if (filters.hasWhitelist()) continue;
                for (Object entry : set.structures()) {
                    structureHolder = entry.structure();
                    key = structureHolder.unwrapKey();
                    if (((Optional)key).isEmpty() || filters.isBlacklisted((Holder<Structure>)structureHolder, id = ((ResourceKey)((Optional)key).get()).location())) continue;
                    matchedStructures.add(structureHolder);
                }
                if (matchedStructures.isEmpty()) continue;
            }
            HashSet<Holder> allowedBiomes = null;
            if (biomePrefilter) {
                Object entry;
                allowedBiomes = new HashSet<Holder>();
                entry = matchedStructures.iterator();
                while (entry.hasNext()) {
                    Holder h2 = (Holder)entry.next();
                    for (Holder b : ((Structure)h2.value()).biomes()) {
                        allowedBiomes.add(b);
                    }
                }
            }
            int spacing = rssp.spacing();
            int startI = Math.floorDiv(minX, spacing);
            int endI = Math.floorDiv(maxX, spacing);
            int startJ = Math.floorDiv(minZ, spacing);
            int endJ = Math.floorDiv(maxZ, spacing);
            String labelId = matchedStructures.stream().map(h -> h.unwrapKey().map(ResourceKey::location).map(ResourceLocation::toString).orElse("structure")).findFirst().orElse("structure");
            for (int i = startI; i <= endI; ++i) {
                for (int j = startJ; j <= endJ; ++j) {
                    int baseX = i * spacing;
                    int baseZ = j * spacing;
                    ChunkPos candidate = rssp.getPotentialStructureChunk(level.getSeed(), baseX, baseZ);
                    int x = candidate.x;
                    int z = candidate.z;
                    if (x < minX || x > maxX || z < minZ || z > maxZ || !placement.isStructureChunk(state, x, z)) continue;
                    BlockPos locatePos = placement.getLocatePos(candidate);
                    int qx = QuartPos.fromBlock((int)locatePos.getX());
                    int qy = QuartPos.fromBlock((int)64);
                    int qz = QuartPos.fromBlock((int)locatePos.getZ());
                    Holder sample = biomeSource.getNoiseBiome(qx, qy, qz, randomState.sampler());
                    if (biomePrefilter && allowedBiomes != null && !allowedBiomes.contains(sample)) continue;
                    String chosenId = labelId;
                    for (Holder h3 : matchedStructures) {
                        if (!((Structure)h3.value()).biomes().contains(sample)) continue;
                        chosenId = h3.unwrapKey().map(ResourceKey::location).map(ResourceLocation::toString).orElse(labelId);
                        break;
                    }
                    result.add(new Records.StructureInfo(locatePos, chosenId));
                }
            }
        }
        return result;
    }

    private static final class Filters {
        private final List<String> whitelist;
        private final List<String> blacklist;

        private Filters(List<String> whitelist, List<String> blacklist) {
            this.whitelist = Filters.normalize(whitelist);
            this.blacklist = Filters.normalize(blacklist);
        }

        static Filters of(List<String> whitelist, List<String> blacklist) {
            return new Filters(whitelist, blacklist);
        }

        boolean hasWhitelist() {
            return !this.whitelist.isEmpty();
        }

        boolean matches(Holder<Structure> holder, ResourceLocation id) {
            boolean whiteOk = this.whitelist.isEmpty() || this.whitelist.stream().anyMatch(p -> this.matchesPattern(holder, id, (String)p));
            boolean blackHit = this.blacklist.stream().anyMatch(p -> this.matchesPattern(holder, id, (String)p));
            return whiteOk && !blackHit;
        }

        boolean isBlacklisted(Holder<Structure> holder, ResourceLocation id) {
            return this.blacklist.stream().anyMatch(p -> this.matchesPattern(holder, id, (String)p));
        }

        private boolean matchesPattern(Holder<Structure> holder, ResourceLocation id, String pattern) {
            if (pattern == null || pattern.isEmpty()) {
                return false;
            }
            String p = pattern.trim().toLowerCase(Locale.ROOT);
            String idStr = id.toString().toLowerCase(Locale.ROOT);
            if (p.startsWith("#")) {
                String raw = p.substring(1);
                ResourceLocation tagId = ResourceLocation.tryParse((String)raw);
                if (tagId == null) {
                    return false;
                }
                TagKey tag = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)tagId);
                return holder.is(tag);
            }
            if (p.endsWith("/*")) {
                String base = p.substring(0, p.length() - 2);
                if (idStr.startsWith(base + "/")) {
                    return true;
                }
                if (idStr.startsWith(base + "_")) {
                    return true;
                }
                if (idStr.startsWith(base + "-")) {
                    return true;
                }
                return idStr.startsWith(base + ".");
            }
            if (p.endsWith(":*")) {
                String ns = p.substring(0, p.length() - 2);
                int idx = ns.indexOf(58);
                if (idx > 0) {
                    ns = ns.substring(0, idx);
                }
                return id.getNamespace().equalsIgnoreCase(ns);
            }
            return idStr.equals(p);
        }

        private static List<String> normalize(List<String> src) {
            ArrayList<String> out = new ArrayList<String>();
            if (src == null) {
                return out;
            }
            for (String s : src) {
                String v;
                if (s == null || (v = s.trim().toLowerCase(Locale.ROOT)).isEmpty()) continue;
                out.add(v);
            }
            return out;
        }
    }
}

