/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.shiroha233.roadweaver.helpers.Records;

public final class StructureVerificationService {
    private StructureVerificationService() {
    }

    public static List<Records.StructureInfo> verifyPredictedStructures(ServerLevel level, List<Records.StructureInfo> predicted) {
        ChunkScanAccess scanAccess;
        if (predicted == null || predicted.isEmpty()) {
            return List.of();
        }
        ServerChunkCache source = level.getChunkSource();
        if (!(source instanceof ServerChunkCache)) {
            return new ArrayList<Records.StructureInfo>(predicted);
        }
        ServerChunkCache chunkCache = source;
        MinecraftServer server = level.getServer();
        if (server == null) {
            return new ArrayList<Records.StructureInfo>(predicted);
        }
        try {
            scanAccess = chunkCache.chunkScanner();
        }
        catch (Throwable t) {
            return new ArrayList<Records.StructureInfo>(predicted);
        }
        RegistryAccess registryAccess = level.registryAccess();
        ChunkGenerator generator = chunkCache.getGenerator();
        RandomState randomState = chunkCache.randomState();
        BiomeSource biomeSource = generator.getBiomeSource();
        long seed = level.getSeed();
        StructureCheck checker = new StructureCheck(scanAccess, registryAccess, server.getStructureManager(), level.dimension(), generator, randomState, (LevelHeightAccessor)level, biomeSource, seed, server.getFixerUpper());
        Registry structureRegistry = registryAccess.registryOrThrow(Registries.STRUCTURE);
        Registry structureSetRegistry = registryAccess.registryOrThrow(Registries.STRUCTURE_SET);
        HashMap<Structure, StructurePlacement> placementCache = new HashMap<Structure, StructurePlacement>();
        for (Holder.Reference setHolder : structureSetRegistry.holders().toList()) {
            StructureSet set = (StructureSet)setHolder.value();
            StructurePlacement placement = set.placement();
            for (StructureSet.StructureSelectionEntry entry : set.structures()) {
                Structure structure = (Structure)entry.structure().value();
                placementCache.putIfAbsent(structure, placement);
            }
        }
        ArrayList<Records.StructureInfo> result = new ArrayList<Records.StructureInfo>();
        for (Records.StructureInfo info : predicted) {
            StructureCheckResult checkResult;
            String idStr = info.structureId();
            if (idStr == null || idStr.isEmpty()) {
                result.add(info);
                continue;
            }
            ResourceLocation rl = ResourceLocation.tryParse((String)idStr);
            if (rl == null) {
                result.add(info);
                continue;
            }
            Structure structure = (Structure)structureRegistry.get(rl);
            if (structure == null) {
                result.add(info);
                continue;
            }
            StructurePlacement placement = (StructurePlacement)placementCache.get(structure);
            if (placement == null) {
                result.add(info);
                continue;
            }
            ChunkPos chunkPos = new ChunkPos(info.pos().getX() >> 4, info.pos().getZ() >> 4);
            try {
                checkResult = checker.checkStart(chunkPos, structure, placement, false);
            }
            catch (Throwable t) {
                result.add(info);
                continue;
            }
            if (checkResult == StructureCheckResult.START_PRESENT) {
                result.add(info);
                continue;
            }
            if (checkResult != StructureCheckResult.CHUNK_LOAD_NEEDED) continue;
            result.add(info);
        }
        return result;
    }
}

