/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.index;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.AABB;
import net.shiroha233.roadweaver.structures.index.StructureIndex;
import net.shiroha233.roadweaver.structures.model.StructureInstance;

public final class ChunkStructureIndex
implements StructureIndex {
    private final Map<Long, Set<StructureInstance>> byChunk = new ConcurrentHashMap<Long, Set<StructureInstance>>();

    private static long key(ChunkPos cp) {
        return (long)cp.x << 32 ^ (long)cp.z & 0xFFFFFFFFL;
    }

    @Override
    public void add(StructureInstance inst) {
        AABB b = inst.bounds();
        if (b == null) {
            return;
        }
        int minCX = (int)Math.floor(b.minX / 16.0);
        int maxCX = (int)Math.floor(b.maxX / 16.0);
        int minCZ = (int)Math.floor(b.minZ / 16.0);
        int maxCZ = (int)Math.floor(b.maxZ / 16.0);
        for (int cx = minCX; cx <= maxCX; ++cx) {
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                this.byChunk.computeIfAbsent(ChunkStructureIndex.key(new ChunkPos(cx, cz)), k -> ConcurrentHashMap.newKeySet()).add(inst);
            }
        }
    }

    @Override
    public void remove(StructureInstance inst) {
        for (Set<StructureInstance> set : this.byChunk.values()) {
            set.remove(inst);
        }
    }

    @Override
    public Collection<StructureInstance> query(AABB box) {
        if (box == null) {
            return Collections.emptyList();
        }
        int minCX = (int)Math.floor(box.minX / 16.0);
        int maxCX = (int)Math.floor(box.maxX / 16.0);
        int minCZ = (int)Math.floor(box.minZ / 16.0);
        int maxCZ = (int)Math.floor(box.maxZ / 16.0);
        HashSet<StructureInstance> result = new HashSet<StructureInstance>();
        for (int cx = minCX; cx <= maxCX; ++cx) {
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                Set<StructureInstance> set = this.byChunk.get(ChunkStructureIndex.key(new ChunkPos(cx, cz)));
                if (set == null) continue;
                for (StructureInstance s : set) {
                    if (s.bounds() == null || !s.bounds().intersects(box)) continue;
                    result.add(s);
                }
            }
        }
        return result;
    }

    @Override
    public boolean existsNear(BlockPos pos, int radius) {
        AABB box = new AABB((double)(pos.getX() - radius), (double)(pos.getY() - radius), (double)(pos.getZ() - radius), (double)(pos.getX() + radius), (double)(pos.getY() + radius), (double)(pos.getZ() + radius));
        return !this.query(box).isEmpty();
    }

    @Override
    public void clear() {
        this.byChunk.clear();
    }
}

