/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.model;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;

public final class StructureInstance {
    public static final Codec<AABB> AABB_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("min_x").forGetter(box -> box.minX), (App)Codec.DOUBLE.fieldOf("min_y").forGetter(box -> box.minY), (App)Codec.DOUBLE.fieldOf("min_z").forGetter(box -> box.minZ), (App)Codec.DOUBLE.fieldOf("max_x").forGetter(box -> box.maxX), (App)Codec.DOUBLE.fieldOf("max_y").forGetter(box -> box.maxY), (App)Codec.DOUBLE.fieldOf("max_z").forGetter(box -> box.maxZ)).apply((Applicative)instance, (minX, minY, minZ, maxX, maxY, maxZ) -> new AABB(minX.doubleValue(), minY.doubleValue(), minZ.doubleValue(), maxX.doubleValue(), maxY.doubleValue(), maxZ.doubleValue())));
    private static final Codec<UUID> UUID_CODEC = Codec.STRING.xmap(UUID::fromString, UUID::toString);
    public static final Codec<StructureInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUID_CODEC.fieldOf("id").forGetter(StructureInstance::instanceId), (App)ResourceLocation.CODEC.fieldOf("blueprint_id").forGetter(StructureInstance::blueprintId), (App)ResourceLocation.CODEC.fieldOf("template_id").forGetter(StructureInstance::variantTemplateId), (App)ResourceLocation.CODEC.fieldOf("dimension_id").forGetter(StructureInstance::dimensionId), (App)BlockPos.CODEC.fieldOf("anchor").forGetter(StructureInstance::anchorPos), (App)AABB_CODEC.fieldOf("bounds").forGetter(StructureInstance::bounds), (App)Codec.LONG.fieldOf("placed_at").forGetter(StructureInstance::placedAt)).apply((Applicative)instance, StructureInstance::new));
    private final UUID instanceId;
    private final ResourceLocation blueprintId;
    private final ResourceLocation variantTemplateId;
    private final ResourceLocation dimensionId;
    private final BlockPos anchorPos;
    private final AABB bounds;
    private final long placedAt;

    public StructureInstance(UUID instanceId, ResourceLocation blueprintId, ResourceLocation variantTemplateId, ResourceLocation dimensionId, BlockPos anchorPos, AABB bounds, long placedAt) {
        this.instanceId = instanceId;
        this.blueprintId = blueprintId;
        this.variantTemplateId = variantTemplateId;
        this.dimensionId = dimensionId;
        this.anchorPos = anchorPos;
        this.bounds = bounds;
        this.placedAt = placedAt;
    }

    public UUID instanceId() {
        return this.instanceId;
    }

    public ResourceLocation blueprintId() {
        return this.blueprintId;
    }

    public ResourceLocation variantTemplateId() {
        return this.variantTemplateId;
    }

    public ResourceLocation dimensionId() {
        return this.dimensionId;
    }

    public BlockPos anchorPos() {
        return this.anchorPos;
    }

    public AABB bounds() {
        return this.bounds;
    }

    public long placedAt() {
        return this.placedAt;
    }
}

