/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.pipeline;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.shiroha233.roadweaver.structures.api.BlendProfile;
import net.shiroha233.roadweaver.structures.api.StructureBlueprint;
import net.shiroha233.roadweaver.structures.model.StructureInstance;
import net.shiroha233.roadweaver.structures.roadside.BeardedTerracePlacer;

public final class StructurePlacer {
    private static final int DEFAULT_TERRACE_BUFFER = 2;
    private static final int DEFAULT_TERRACE_TRANSITION = 4;

    private StructurePlacer() {
    }

    public static StructureInstance place(ServerLevel level, StructureBlueprint bp, ResourceLocation variantTemplateId, BlockPos anchor, Rotation rotation, Mirror mirror, AABB preBounds, BlendProfile blend) {
        ResourceLocation id = StructurePlacer.normalizeTemplateId(variantTemplateId);
        StructureTemplateManager mgr = level.getServer().getStructureManager();
        Optional opt = mgr.get(id);
        if (opt.isEmpty()) {
            opt = mgr.get(variantTemplateId);
        }
        if (opt.isEmpty()) {
            AABB b = preBounds != null ? preBounds : new AABB((double)anchor.getX(), (double)anchor.getY(), (double)anchor.getZ(), (double)anchor.getX() + 1.0, (double)anchor.getY() + 1.0, (double)anchor.getZ() + 1.0).inflate(8.0, 5.0, 8.0);
            return new StructureInstance(UUID.randomUUID(), bp.id(), id, level.dimension().location(), anchor, b, level.getGameTime());
        }
        StructureTemplate tpl = (StructureTemplate)opt.get();
        Vec3i raw = tpl.getSize();
        Vec3i size = StructurePlacer.rotatedSize(raw, rotation);
        BlockPos min = anchor;
        BlockPos max = anchor.offset(size.getX() - 1, size.getY() - 1, size.getZ() - 1);
        AABB bounds = new AABB((double)min.getX(), (double)min.getY(), (double)min.getZ(), (double)max.getX() + 1.0, (double)max.getY() + 1.0, (double)max.getZ() + 1.0);
        if (blend != null) {
            int centerX = (min.getX() + max.getX()) / 2;
            int centerZ = (min.getZ() + max.getZ()) / 2;
            int targetY = min.getY();
            int structureRadius = Math.max(size.getX(), size.getZ()) / 2;
            int innerRadius = structureRadius + 2;
            int outerRadius = innerRadius + Math.max(8, blend.ringOuter() - blend.ringInner());
            BeardedTerracePlacer.buildTerraceForLargeStructure((LevelAccessor)level, centerX, centerZ, targetY, innerRadius, outerRadius, level.getRandom());
        }
        StructurePlaceSettings settings = new StructurePlaceSettings().setRotation(rotation).setMirror(mirror);
        tpl.placeInWorld((ServerLevelAccessor)level, anchor, anchor, settings, level.getRandom(), 2);
        return new StructureInstance(UUID.randomUUID(), bp.id(), id, level.dimension().location(), anchor, bounds, level.getGameTime());
    }

    private static ResourceLocation normalizeTemplateId(ResourceLocation in) {
        String path = in.getPath();
        if (path.startsWith("structures/")) {
            return ResourceLocation.fromNamespaceAndPath((String)in.getNamespace(), (String)path.substring("structures/".length()));
        }
        return in;
    }

    private static Vec3i rotatedSize(Vec3i s, Rotation r) {
        return switch (r) {
            default -> throw new MatchException(null, null);
            case Rotation.NONE, Rotation.CLOCKWISE_180 -> s;
            case Rotation.CLOCKWISE_90, Rotation.COUNTERCLOCKWISE_90 -> new Vec3i(s.getZ(), s.getY(), s.getX());
        };
    }

    public static boolean placeSimple(WorldGenLevel world, ServerLevel server, ResourceLocation templateId, BlockPos position, Rotation rotation, boolean withTerrace, boolean noBasement, boolean centerMode, RandomSource random) {
        BlockPos anchor;
        StructureTemplateManager mgr = server.getStructureManager();
        Optional<StructureTemplate> opt = StructurePlacer.loadTemplate(mgr, templateId);
        if (opt.isEmpty()) {
            return false;
        }
        StructureTemplate tpl = opt.get();
        Vec3i size = tpl.getSize(rotation);
        if (centerMode) {
            int offsetX = size.getX() / 2;
            int offsetZ = size.getZ() / 2;
            anchor = new BlockPos(position.getX() - offsetX, position.getY(), position.getZ() - offsetZ);
        } else {
            anchor = position;
        }
        if (withTerrace) {
            int targetY = noBasement ? anchor.getY() - 1 : anchor.getY();
            int centerX = anchor.getX() + size.getX() / 2;
            int centerZ = anchor.getZ() + size.getZ() / 2;
            StructurePlacer.buildTerraceAtCenter(world, centerX, centerZ, size, targetY, random);
        }
        StructurePlaceSettings settings = new StructurePlaceSettings().setRotation(rotation).setMirror(Mirror.NONE).setIgnoreEntities(false);
        tpl.placeInWorld((ServerLevelAccessor)world, anchor, anchor, settings, random, 2);
        return true;
    }

    public static boolean placeSimple(WorldGenLevel world, ServerLevel server, ResourceLocation templateId, BlockPos anchor, Rotation rotation, boolean withTerrace, boolean noBasement, RandomSource random) {
        return StructurePlacer.placeSimple(world, server, templateId, anchor, rotation, withTerrace, noBasement, false, random);
    }

    public static boolean placeSimple(ServerLevel level, ResourceLocation templateId, BlockPos anchor, Rotation rotation, boolean withTerrace, boolean noBasement) {
        StructureTemplateManager mgr = level.getStructureManager();
        Optional<StructureTemplate> opt = StructurePlacer.loadTemplate(mgr, templateId);
        if (opt.isEmpty()) {
            return false;
        }
        StructureTemplate tpl = opt.get();
        Vec3i size = tpl.getSize(rotation);
        if (withTerrace) {
            int targetY = noBasement ? anchor.getY() - 1 : anchor.getY();
            int centerX = anchor.getX() + size.getX() / 2;
            int centerZ = anchor.getZ() + size.getZ() / 2;
            int structureRadius = Math.max(size.getX(), size.getZ()) / 2;
            int innerRadius = structureRadius + 2;
            int outerRadius = innerRadius + 4;
            BeardedTerracePlacer.buildTerraceForLargeStructure((LevelAccessor)level, centerX, centerZ, targetY, innerRadius, outerRadius, level.getRandom());
        }
        StructurePlaceSettings settings = new StructurePlaceSettings().setRotation(rotation).setMirror(Mirror.NONE).setIgnoreEntities(false);
        tpl.placeInWorld((ServerLevelAccessor)level, anchor, anchor, settings, level.getRandom(), 2);
        return true;
    }

    private static Optional<StructureTemplate> loadTemplate(StructureTemplateManager mgr, ResourceLocation templateId) {
        Optional opt = mgr.get(templateId);
        if (opt.isPresent()) {
            return opt;
        }
        ResourceLocation altId = ResourceLocation.fromNamespaceAndPath((String)templateId.getNamespace(), (String)("structures/" + templateId.getPath()));
        opt = mgr.get(altId);
        if (opt.isPresent()) {
            return opt;
        }
        String path = templateId.getPath();
        if (path.startsWith("structures/")) {
            ResourceLocation cleanId = ResourceLocation.fromNamespaceAndPath((String)templateId.getNamespace(), (String)path.substring("structures/".length()));
            return mgr.get(cleanId);
        }
        return Optional.empty();
    }

    private static void buildTerraceAtCenter(WorldGenLevel world, int centerX, int centerZ, Vec3i size, int targetY, RandomSource random) {
        double innerRadius = (double)Math.max(size.getX(), size.getZ()) / 2.0 + 2.0;
        double outerRadius = innerRadius + 4.0;
        BeardedTerracePlacer.buildTerraceByCenter(world, centerX, centerZ, targetY, (int)innerRadius, (int)outerRadius, random);
    }
}

