/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.roadside;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public final class BeardedTerracePlacer {
    private static final int TRANSITION_RADIUS = 4;
    private static final double MIN_CONTRIBUTION = 0.05;
    private static final int PIT_FILL_DEPTH = 3;
    private static final int MAX_CUT_DEPTH = 6;

    private BeardedTerracePlacer() {
    }

    public static void buildTerrace(WorldGenLevel world, BlockPos anchor, Vec3i size, RandomSource random) {
        int centerX = anchor.getX() + size.getX() / 2;
        int centerZ = anchor.getZ() + size.getZ() / 2;
        int targetY = anchor.getY() - 1;
        double innerRadius = (double)Math.max(size.getX(), size.getZ()) / 2.0 + 0.5;
        double outerRadius = innerRadius + 4.0;
        int searchRadius = (int)Math.ceil(outerRadius) + 1;
        for (int x = centerX - searchRadius; x <= centerX + searchRadius; ++x) {
            for (int z = centerZ - searchRadius; z <= centerZ + searchRadius; ++z) {
                int cutDepth;
                double dx = x - centerX;
                double dz = z - centerZ;
                double dist = Math.sqrt(dx * dx + dz * dz);
                if (dist > outerRadius) continue;
                int groundY = world.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z) - 1;
                if (dist <= innerRadius) {
                    int cutDepth2;
                    if (groundY < targetY) {
                        BeardedTerracePlacer.fillColumnUp(world, x, z, groundY, targetY, random);
                    } else if (groundY > targetY && (cutDepth2 = groundY - targetY) <= 6) {
                        BeardedTerracePlacer.clearColumnDown(world, x, z, targetY + 1, groundY);
                    }
                    BeardedTerracePlacer.fillPitBelow(world, x, z, targetY, random);
                    continue;
                }
                double t = (dist - innerRadius) / (outerRadius - innerRadius);
                double smooth = BeardedTerracePlacer.smoothstep(t);
                double contribution = 1.0 - smooth;
                if (contribution < 0.05) continue;
                int finalY = (int)Math.round((double)targetY * contribution + (double)groundY * (1.0 - contribution));
                if (finalY > groundY) {
                    BeardedTerracePlacer.fillColumnUp(world, x, z, groundY, finalY, random);
                    continue;
                }
                if (finalY >= groundY || (cutDepth = groundY - finalY) > 6) continue;
                BeardedTerracePlacer.clearColumnDown(world, x, z, finalY + 1, groundY);
            }
        }
        BeardedTerracePlacer.fixExposedDirt(world, centerX, centerZ, searchRadius, targetY);
    }

    public static void buildTerraceByCenter(WorldGenLevel world, int centerX, int centerZ, int targetY, int innerRadius, int outerRadius, RandomSource random) {
        int searchRadius = outerRadius + 2;
        for (int x = centerX - searchRadius; x <= centerX + searchRadius; ++x) {
            for (int z = centerZ - searchRadius; z <= centerZ + searchRadius; ++z) {
                int cutDepth;
                double dx = x - centerX;
                double dz = z - centerZ;
                double dist = Math.sqrt(dx * dx + dz * dz);
                if (dist > (double)outerRadius) continue;
                int groundY = world.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z) - 1;
                if (dist <= (double)innerRadius) {
                    int cutDepth2;
                    if (groundY < targetY) {
                        BeardedTerracePlacer.fillColumnUp(world, x, z, groundY, targetY, random);
                    } else if (groundY > targetY && (cutDepth2 = groundY - targetY) <= 6) {
                        BeardedTerracePlacer.clearColumnDown(world, x, z, targetY + 1, groundY);
                    }
                    BeardedTerracePlacer.fillPitBelow(world, x, z, targetY, random);
                    continue;
                }
                double t = (dist - (double)innerRadius) / (double)(outerRadius - innerRadius);
                double smooth = BeardedTerracePlacer.smoothstep(t);
                double contribution = 1.0 - smooth;
                if (contribution < 0.05) continue;
                int finalY = (int)Math.round((double)targetY * contribution + (double)groundY * (1.0 - contribution));
                if (finalY > groundY) {
                    BeardedTerracePlacer.fillColumnUp(world, x, z, groundY, finalY, random);
                    continue;
                }
                if (finalY >= groundY || (cutDepth = groundY - finalY) > 6) continue;
                BeardedTerracePlacer.clearColumnDown(world, x, z, finalY + 1, groundY);
            }
        }
        BeardedTerracePlacer.fixExposedDirt(world, centerX, centerZ, searchRadius, targetY);
    }

    public static void buildTerraceForLargeStructure(LevelAccessor level, int centerX, int centerZ, int targetY, int innerRadius, int outerRadius, RandomSource random) {
        int searchRadius = outerRadius + 2;
        for (int x = centerX - searchRadius; x <= centerX + searchRadius; ++x) {
            for (int z = centerZ - searchRadius; z <= centerZ + searchRadius; ++z) {
                int cutDepth;
                double dx = x - centerX;
                double dz = z - centerZ;
                double dist = Math.sqrt(dx * dx + dz * dz);
                if (dist > (double)outerRadius) continue;
                int groundY = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z) - 1;
                if (dist <= (double)innerRadius) {
                    int cutDepth2;
                    if (groundY < targetY) {
                        BeardedTerracePlacer.fillColumnUpGeneric(level, x, z, groundY, targetY, random);
                    } else if (groundY > targetY && (cutDepth2 = groundY - targetY) <= 6) {
                        BeardedTerracePlacer.clearColumnDownGeneric(level, x, z, targetY + 1, groundY);
                    }
                    BeardedTerracePlacer.fillPitBelowGeneric(level, x, z, targetY, random);
                    continue;
                }
                double t = (dist - (double)innerRadius) / (double)(outerRadius - innerRadius);
                double smooth = BeardedTerracePlacer.smoothstep(t);
                double contribution = 1.0 - smooth;
                if (contribution < 0.05) continue;
                int finalY = (int)Math.round((double)targetY * contribution + (double)groundY * (1.0 - contribution));
                if (finalY > groundY) {
                    BeardedTerracePlacer.fillColumnUpGeneric(level, x, z, groundY, finalY, random);
                    continue;
                }
                if (finalY >= groundY || (cutDepth = groundY - finalY) > 6) continue;
                BeardedTerracePlacer.clearColumnDownGeneric(level, x, z, finalY + 1, groundY);
            }
        }
        BeardedTerracePlacer.fixExposedDirtGeneric(level, centerX, centerZ, searchRadius, targetY);
    }

    private static void fillColumnUpGeneric(LevelAccessor level, int x, int z, int groundY, int targetY, RandomSource random) {
        BlockState surfaceState = level.getBlockState(new BlockPos(x, groundY, z));
        BlockState fillState = BeardedTerracePlacer.getSuitableFillState(surfaceState);
        BlockState topState = BeardedTerracePlacer.getSuitableTopState(surfaceState);
        for (int y = groundY + 1; y <= targetY; ++y) {
            BlockState state = y == targetY ? topState : fillState;
            level.setBlock(new BlockPos(x, y, z), state, 3);
        }
    }

    private static void fixExposedDirtGeneric(LevelAccessor level, int centerX, int centerZ, int radius, int baseY) {
        for (int x = centerX - radius; x <= centerX + radius; ++x) {
            for (int z = centerZ - radius; z <= centerZ + radius; ++z) {
                for (int y = baseY; y >= baseY - 5; --y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = level.getBlockState(pos);
                    if ((state.is(Blocks.DIRT) || state.is(Blocks.COARSE_DIRT)) && BeardedTerracePlacer.isExposedToAirGeneric(level, pos)) {
                        level.setBlock(pos, Blocks.GRASS_BLOCK.defaultBlockState(), 3);
                    }
                    if (!state.is(Blocks.SNOW_BLOCK) || !BeardedTerracePlacer.isExposedToAirGeneric(level, pos)) continue;
                    level.setBlock(pos, Blocks.SNOW_BLOCK.defaultBlockState(), 3);
                }
            }
        }
    }

    private static boolean isExposedToAirGeneric(LevelAccessor level, BlockPos pos) {
        if (level.getBlockState(pos.above()).isAir()) {
            return true;
        }
        return level.getBlockState(pos.north()).isAir() || level.getBlockState(pos.south()).isAir() || level.getBlockState(pos.east()).isAir() || level.getBlockState(pos.west()).isAir();
    }

    private static void fixExposedDirt(WorldGenLevel world, int centerX, int centerZ, int radius, int baseY) {
        for (int x = centerX - radius; x <= centerX + radius; ++x) {
            for (int z = centerZ - radius; z <= centerZ + radius; ++z) {
                for (int y = baseY; y >= baseY - 5; --y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = world.getBlockState(pos);
                    if ((state.is(Blocks.DIRT) || state.is(Blocks.COARSE_DIRT)) && BeardedTerracePlacer.isExposedToAir(world, pos)) {
                        world.setBlock(pos, Blocks.GRASS_BLOCK.defaultBlockState(), 2);
                    }
                    if (!state.is(Blocks.SNOW_BLOCK) || !BeardedTerracePlacer.isExposedToAir(world, pos)) continue;
                    world.setBlock(pos, Blocks.SNOW_BLOCK.defaultBlockState(), 2);
                }
            }
        }
    }

    private static boolean isExposedToAir(WorldGenLevel world, BlockPos pos) {
        if (world.getBlockState(pos.above()).isAir()) {
            return true;
        }
        return world.getBlockState(pos.north()).isAir() || world.getBlockState(pos.south()).isAir() || world.getBlockState(pos.east()).isAir() || world.getBlockState(pos.west()).isAir();
    }

    private static double smoothstep(double t) {
        t = Mth.clamp((double)t, (double)0.0, (double)1.0);
        return t * t * (3.0 - 2.0 * t);
    }

    private static void clearColumnDown(WorldGenLevel world, int x, int z, int fromY, int toY) {
        for (int y = fromY; y <= toY; ++y) {
            BlockPos pos = new BlockPos(x, y, z);
            BlockState state = world.getBlockState(pos);
            if (!BeardedTerracePlacer.isNaturalBlock(state)) continue;
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
        }
    }

    private static void clearColumnDownGeneric(LevelAccessor level, int x, int z, int fromY, int toY) {
        for (int y = fromY; y <= toY; ++y) {
            BlockPos pos = new BlockPos(x, y, z);
            BlockState state = level.getBlockState(pos);
            if (!BeardedTerracePlacer.isNaturalBlock(state)) continue;
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        }
    }

    private static void fillPitBelow(WorldGenLevel world, int x, int z, int targetY, RandomSource random) {
        BlockPos pos;
        BlockState state;
        BlockState surfaceState = world.getBlockState(new BlockPos(x, targetY, z));
        BlockState fillState = BeardedTerracePlacer.getSuitableFillState(surfaceState);
        for (int y = targetY; y > targetY - 3 && ((state = world.getBlockState(pos = new BlockPos(x, y, z))).isAir() || state.canBeReplaced()); --y) {
            world.setBlock(pos, fillState, 2);
        }
    }

    private static void fillPitBelowGeneric(LevelAccessor level, int x, int z, int targetY, RandomSource random) {
        BlockPos pos;
        BlockState state;
        BlockState surfaceState = level.getBlockState(new BlockPos(x, targetY, z));
        BlockState fillState = BeardedTerracePlacer.getSuitableFillState(surfaceState);
        for (int y = targetY; y > targetY - 3 && ((state = level.getBlockState(pos = new BlockPos(x, y, z))).isAir() || state.canBeReplaced()); --y) {
            level.setBlock(pos, fillState, 3);
        }
    }

    private static boolean isNaturalBlock(BlockState state) {
        return state.is(Blocks.DIRT) || state.is(Blocks.GRASS_BLOCK) || state.is(Blocks.STONE) || state.is(Blocks.SAND) || state.is(Blocks.RED_SAND) || state.is(Blocks.GRAVEL) || state.is(Blocks.PODZOL) || state.is(Blocks.MYCELIUM) || state.is(Blocks.COARSE_DIRT) || state.is(Blocks.ROOTED_DIRT) || state.is(Blocks.ANDESITE) || state.is(Blocks.DIORITE) || state.is(Blocks.GRANITE) || state.is(Blocks.DEEPSLATE) || state.is(Blocks.TUFF) || state.is(Blocks.CALCITE) || state.is(Blocks.SNOW_BLOCK) || state.is(Blocks.SNOW) || state.is(Blocks.CLAY) || state.is(Blocks.MUD) || state.is(Blocks.PACKED_MUD) || state.is(Blocks.MUDDY_MANGROVE_ROOTS);
    }

    private static void fillColumnUp(WorldGenLevel world, int x, int z, int groundY, int targetY, RandomSource random) {
        BlockState surfaceState = world.getBlockState(new BlockPos(x, groundY, z));
        BlockState fillState = BeardedTerracePlacer.getSuitableFillState(surfaceState);
        BlockState topState = BeardedTerracePlacer.getSuitableTopState(surfaceState);
        for (int y = groundY + 1; y <= targetY; ++y) {
            BlockState state = y == targetY ? topState : fillState;
            world.setBlock(new BlockPos(x, y, z), state, 2);
        }
    }

    private static BlockState getSuitableFillState(BlockState surface) {
        if (surface.is(Blocks.GRASS_BLOCK) || surface.is(Blocks.DIRT) || surface.is(Blocks.PODZOL) || surface.is(Blocks.MYCELIUM)) {
            return Blocks.DIRT.defaultBlockState();
        }
        if (surface.is(Blocks.SAND)) {
            return Blocks.SAND.defaultBlockState();
        }
        if (surface.is(Blocks.RED_SAND)) {
            return Blocks.RED_SAND.defaultBlockState();
        }
        if (surface.is(Blocks.GRAVEL)) {
            return Blocks.GRAVEL.defaultBlockState();
        }
        if (surface.is(Blocks.STONE) || surface.is(Blocks.ANDESITE) || surface.is(Blocks.DIORITE) || surface.is(Blocks.GRANITE)) {
            return Blocks.STONE.defaultBlockState();
        }
        return Blocks.DIRT.defaultBlockState();
    }

    private static BlockState getSuitableTopState(BlockState surface) {
        if (surface.is(Blocks.GRASS_BLOCK)) {
            return Blocks.GRASS_BLOCK.defaultBlockState();
        }
        if (surface.is(Blocks.PODZOL)) {
            return Blocks.PODZOL.defaultBlockState();
        }
        if (surface.is(Blocks.MYCELIUM)) {
            return Blocks.MYCELIUM.defaultBlockState();
        }
        if (surface.is(Blocks.SAND)) {
            return Blocks.SAND.defaultBlockState();
        }
        if (surface.is(Blocks.RED_SAND)) {
            return Blocks.RED_SAND.defaultBlockState();
        }
        if (surface.is(Blocks.GRAVEL)) {
            return Blocks.GRAVEL.defaultBlockState();
        }
        return Blocks.GRASS_BLOCK.defaultBlockState();
    }
}

