/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.roadside;

import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;

public enum BiomeCategory {
    PLAINS,
    FOREST,
    TAIGA,
    JUNGLE,
    DESERT,
    SAVANNA,
    BADLANDS,
    SNOWY,
    SWAMP,
    CHERRY_GROVE,
    MUSHROOM,
    MOUNTAIN,
    BEACH,
    OTHER;

    private static final ResourceLocation PLAINS_ID;
    private static final ResourceLocation SUNFLOWER_PLAINS_ID;
    private static final ResourceLocation MEADOW_ID;
    private static final ResourceLocation FOREST_ID;
    private static final ResourceLocation FLOWER_FOREST_ID;
    private static final ResourceLocation BIRCH_FOREST_ID;
    private static final ResourceLocation OLD_GROWTH_BIRCH_FOREST_ID;
    private static final ResourceLocation DARK_FOREST_ID;
    private static final ResourceLocation TAIGA_ID;
    private static final ResourceLocation OLD_GROWTH_PINE_TAIGA_ID;
    private static final ResourceLocation OLD_GROWTH_SPRUCE_TAIGA_ID;
    private static final ResourceLocation SNOWY_TAIGA_ID;
    private static final ResourceLocation JUNGLE_ID;
    private static final ResourceLocation SPARSE_JUNGLE_ID;
    private static final ResourceLocation BAMBOO_JUNGLE_ID;
    private static final ResourceLocation DESERT_ID;
    private static final ResourceLocation SAVANNA_ID;
    private static final ResourceLocation SAVANNA_PLATEAU_ID;
    private static final ResourceLocation WINDSWEPT_SAVANNA_ID;
    private static final ResourceLocation BADLANDS_ID;
    private static final ResourceLocation WOODED_BADLANDS_ID;
    private static final ResourceLocation ERODED_BADLANDS_ID;
    private static final ResourceLocation SNOWY_PLAINS_ID;
    private static final ResourceLocation ICE_SPIKES_ID;
    private static final ResourceLocation SNOWY_SLOPES_ID;
    private static final ResourceLocation FROZEN_PEAKS_ID;
    private static final ResourceLocation SWAMP_ID;
    private static final ResourceLocation MANGROVE_SWAMP_ID;
    private static final ResourceLocation CHERRY_GROVE_ID;
    private static final ResourceLocation MUSHROOM_FIELDS_ID;
    private static final ResourceLocation WINDSWEPT_HILLS_ID;
    private static final ResourceLocation WINDSWEPT_GRAVELLY_HILLS_ID;
    private static final ResourceLocation WINDSWEPT_FOREST_ID;
    private static final ResourceLocation STONY_PEAKS_ID;
    private static final ResourceLocation JAGGED_PEAKS_ID;
    private static final ResourceLocation BEACH_ID;
    private static final ResourceLocation SNOWY_BEACH_ID;
    private static final ResourceLocation STONY_SHORE_ID;

    public static BiomeCategory fromBiome(Holder<Biome> biome) {
        if (biome == null) {
            return OTHER;
        }
        ResourceLocation biomeId = biome.unwrapKey().map(key -> key.location()).orElse(null);
        if (biomeId == null) {
            return OTHER;
        }
        return BiomeCategory.fromBiomeId(biomeId, biome);
    }

    private static BiomeCategory fromBiomeId(ResourceLocation id, Holder<Biome> biome) {
        if (id.equals((Object)PLAINS_ID) || id.equals((Object)SUNFLOWER_PLAINS_ID) || id.equals((Object)MEADOW_ID)) {
            return PLAINS;
        }
        if (id.equals((Object)FOREST_ID) || id.equals((Object)FLOWER_FOREST_ID) || id.equals((Object)BIRCH_FOREST_ID) || id.equals((Object)OLD_GROWTH_BIRCH_FOREST_ID) || id.equals((Object)DARK_FOREST_ID)) {
            return FOREST;
        }
        if (id.equals((Object)TAIGA_ID) || id.equals((Object)OLD_GROWTH_PINE_TAIGA_ID) || id.equals((Object)OLD_GROWTH_SPRUCE_TAIGA_ID) || id.equals((Object)SNOWY_TAIGA_ID)) {
            return TAIGA;
        }
        if (id.equals((Object)JUNGLE_ID) || id.equals((Object)SPARSE_JUNGLE_ID) || id.equals((Object)BAMBOO_JUNGLE_ID)) {
            return JUNGLE;
        }
        if (id.equals((Object)DESERT_ID)) {
            return DESERT;
        }
        if (id.equals((Object)SAVANNA_ID) || id.equals((Object)SAVANNA_PLATEAU_ID) || id.equals((Object)WINDSWEPT_SAVANNA_ID)) {
            return SAVANNA;
        }
        if (id.equals((Object)BADLANDS_ID) || id.equals((Object)WOODED_BADLANDS_ID) || id.equals((Object)ERODED_BADLANDS_ID)) {
            return BADLANDS;
        }
        if (id.equals((Object)SNOWY_PLAINS_ID) || id.equals((Object)ICE_SPIKES_ID) || id.equals((Object)SNOWY_SLOPES_ID) || id.equals((Object)FROZEN_PEAKS_ID)) {
            return SNOWY;
        }
        if (id.equals((Object)SWAMP_ID) || id.equals((Object)MANGROVE_SWAMP_ID)) {
            return SWAMP;
        }
        if (id.equals((Object)CHERRY_GROVE_ID)) {
            return CHERRY_GROVE;
        }
        if (id.equals((Object)MUSHROOM_FIELDS_ID)) {
            return MUSHROOM;
        }
        if (id.equals((Object)WINDSWEPT_HILLS_ID) || id.equals((Object)WINDSWEPT_GRAVELLY_HILLS_ID) || id.equals((Object)WINDSWEPT_FOREST_ID) || id.equals((Object)STONY_PEAKS_ID) || id.equals((Object)JAGGED_PEAKS_ID)) {
            return MOUNTAIN;
        }
        if (id.equals((Object)BEACH_ID) || id.equals((Object)SNOWY_BEACH_ID) || id.equals((Object)STONY_SHORE_ID)) {
            return BEACH;
        }
        if (biome.is(BiomeTags.IS_FOREST)) {
            return FOREST;
        }
        if (biome.is(BiomeTags.IS_TAIGA)) {
            return TAIGA;
        }
        if (biome.is(BiomeTags.IS_JUNGLE)) {
            return JUNGLE;
        }
        if (biome.is(BiomeTags.IS_BADLANDS)) {
            return BADLANDS;
        }
        if (biome.is(BiomeTags.IS_MOUNTAIN)) {
            return MOUNTAIN;
        }
        if (biome.is(BiomeTags.IS_BEACH)) {
            return BEACH;
        }
        if (biome.is(BiomeTags.IS_SAVANNA)) {
            return SAVANNA;
        }
        return OTHER;
    }

    static {
        PLAINS_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"plains");
        SUNFLOWER_PLAINS_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"sunflower_plains");
        MEADOW_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"meadow");
        FOREST_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"forest");
        FLOWER_FOREST_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"flower_forest");
        BIRCH_FOREST_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"birch_forest");
        OLD_GROWTH_BIRCH_FOREST_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"old_growth_birch_forest");
        DARK_FOREST_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"dark_forest");
        TAIGA_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"taiga");
        OLD_GROWTH_PINE_TAIGA_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"old_growth_pine_taiga");
        OLD_GROWTH_SPRUCE_TAIGA_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"old_growth_spruce_taiga");
        SNOWY_TAIGA_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"snowy_taiga");
        JUNGLE_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"jungle");
        SPARSE_JUNGLE_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"sparse_jungle");
        BAMBOO_JUNGLE_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"bamboo_jungle");
        DESERT_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"desert");
        SAVANNA_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"savanna");
        SAVANNA_PLATEAU_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"savanna_plateau");
        WINDSWEPT_SAVANNA_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"windswept_savanna");
        BADLANDS_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"badlands");
        WOODED_BADLANDS_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"wooded_badlands");
        ERODED_BADLANDS_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"eroded_badlands");
        SNOWY_PLAINS_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"snowy_plains");
        ICE_SPIKES_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"ice_spikes");
        SNOWY_SLOPES_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"snowy_slopes");
        FROZEN_PEAKS_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"frozen_peaks");
        SWAMP_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"swamp");
        MANGROVE_SWAMP_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"mangrove_swamp");
        CHERRY_GROVE_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"cherry_grove");
        MUSHROOM_FIELDS_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"mushroom_fields");
        WINDSWEPT_HILLS_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"windswept_hills");
        WINDSWEPT_GRAVELLY_HILLS_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"windswept_gravelly_hills");
        WINDSWEPT_FOREST_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"windswept_forest");
        STONY_PEAKS_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"stony_peaks");
        JAGGED_PEAKS_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"jagged_peaks");
        BEACH_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"beach");
        SNOWY_BEACH_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"snowy_beach");
        STONY_SHORE_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"stony_shore");
    }
}

