/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.roadside;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;

public final class RoadPlacementContext {
    private final List<BlockPos> placedPositions = new ArrayList<BlockPos>();
    private final int roadLength;

    public RoadPlacementContext(int roadLength) {
        this.roadLength = Math.max(0, roadLength);
    }

    public int roadLength() {
        return this.roadLength;
    }

    public int placedCount() {
        return this.placedPositions.size();
    }

    public boolean isMaxReached(int maxStructures) {
        return this.placedPositions.size() >= maxStructures;
    }

    public boolean checkSpacing(BlockPos pos, int minSpacing) {
        if (minSpacing <= 0) {
            return true;
        }
        double minSpacingSq = (double)minSpacing * (double)minSpacing;
        for (BlockPos placed : this.placedPositions) {
            double dz;
            double dx = pos.getX() - placed.getX();
            double distSq = dx * dx + (dz = (double)(pos.getZ() - placed.getZ())) * dz;
            if (!(distSq < minSpacingSq)) continue;
            return false;
        }
        return true;
    }

    public void recordPlacement(BlockPos pos) {
        this.placedPositions.add(pos.immutable());
    }

    public List<BlockPos> getPlacedPositions() {
        return List.copyOf(this.placedPositions);
    }

    public void reset() {
        this.placedPositions.clear();
    }
}

