/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.roadside;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.structures.StructureSystem;
import net.shiroha233.roadweaver.structures.pipeline.StructurePlacer;
import net.shiroha233.roadweaver.structures.roadside.BiomeCategory;
import net.shiroha233.roadweaver.structures.roadside.RoadPlacementContext;
import net.shiroha233.roadweaver.structures.roadside.RoadsideType;
import net.shiroha233.roadweaver.structures.roadside.StructureScale;

public final class RoadsideStructureService {
    private static final int RANDOM_OFFSET_RANGE = 3;

    private RoadsideStructureService() {
    }

    public static boolean tryPlace(WorldGenLevel world, ServerLevel server, BlockPos middlePos, BlockPos prevPos, BlockPos nextPos, int roadWidth, int roadLength, RoadPlacementContext ctx, RandomSource random, ModConfig cfg) {
        int dz;
        if (!cfg.roadsideStructuresEnabled()) {
            return false;
        }
        if (ctx.isMaxReached(cfg.maxStructuresPerRoad())) {
            return false;
        }
        Holder biome = world.getBiome(middlePos);
        BiomeCategory biomeCategory = BiomeCategory.fromBiome((Holder<Biome>)biome);
        RoadsideType type = RoadsideType.chooseWeightedFiltered(random, biomeCategory, roadLength);
        if (type == null) {
            return false;
        }
        int dx = nextPos.getX() - prevPos.getX();
        double len = Math.sqrt((double)dx * (double)dx + (double)(dz = nextPos.getZ() - prevPos.getZ()) * (double)dz);
        if (len < 0.001) {
            return false;
        }
        double dirX = (double)dx / len;
        double dirZ = (double)dz / len;
        double orthoX = -dirZ;
        double orthoZ = dirX;
        boolean leftSide = random.nextBoolean();
        double sideMultiplier = leftSide ? 1.0 : -1.0;
        int halfWidth = Math.max(1, roadWidth / 2);
        int sideOffset = halfWidth + RoadsideStructureService.getOffsetForScale(type.scale(), cfg) + random.nextInt(4);
        int placeX = middlePos.getX() + (int)Math.round(orthoX * (double)sideOffset * sideMultiplier);
        int placeZ = middlePos.getZ() + (int)Math.round(orthoZ * (double)sideOffset * sideMultiplier);
        Vec3i sizeHint = type.sizeHint();
        int halfSizeX = sizeHint.getX() / 2;
        int halfSizeZ = sizeHint.getZ() / 2;
        int[] sampleHeights = RoadsideStructureService.sampleGroundHeights(world, placeX, placeZ, halfSizeX, halfSizeZ);
        int placeY = sampleHeights[0];
        int slopeHeight = sampleHeights[0] - sampleHeights[1];
        StructureScale scale = type.scale();
        if (slopeHeight > scale.maxSlope()) {
            return false;
        }
        BlockPos placePos = new BlockPos(placeX, placeY, placeZ);
        if (RoadsideStructureService.isOnWater(world, placeX, placeY, placeZ, halfSizeX, halfSizeZ)) {
            return false;
        }
        int heightDiff = Math.abs(placeY - middlePos.getY());
        if (heightDiff > scale.maxHeightDiff()) {
            return false;
        }
        if (!ctx.checkSpacing(placePos, cfg.minStructureSpacing())) {
            return false;
        }
        if (StructureSystem.index(server).existsNear(placePos, cfg.minStructureSpacing())) {
            return false;
        }
        Rotation rotation = RoadsideStructureService.calculateRotation(dirX, dirZ, leftSide, type.faceRoad());
        ResourceLocation templateId = type.templateId();
        boolean placed = StructurePlacer.placeSimple(world, server, templateId, placePos, rotation, true, true, true, random);
        if (placed) {
            ctx.recordPlacement(placePos);
        }
        return placed;
    }

    private static int getOffsetForScale(StructureScale scale, ModConfig cfg) {
        return switch (scale) {
            default -> throw new MatchException(null, null);
            case StructureScale.SMALL -> cfg.smallStructureOffset();
            case StructureScale.MEDIUM -> cfg.mediumStructureOffset();
            case StructureScale.LARGE -> cfg.largeStructureOffset();
        };
    }

    public static void processSegments(WorldGenLevel world, ServerLevel server, List<BlockPos> middlePositions, int roadWidth, RandomSource random, ModConfig cfg, int startIndex, int endIndex) {
        if (middlePositions == null || middlePositions.size() < 5) {
            return;
        }
        int roadLength = middlePositions.size();
        RoadPlacementContext ctx = new RoadPlacementContext(roadLength);
        int safeStart = Math.max(2, startIndex);
        int safeEnd = Math.min(middlePositions.size() - 3, endIndex);
        int checkInterval = RoadsideStructureService.calculateCheckInterval(safeEnd - safeStart, cfg.maxStructuresPerRoad());
        for (int i = safeStart; i < safeEnd; ++i) {
            if ((i - safeStart) % checkInterval != 0) continue;
            if (ctx.isMaxReached(cfg.maxStructuresPerRoad())) break;
            BlockPos middle = middlePositions.get(i);
            BlockPos prev = middlePositions.get(i - 2);
            BlockPos next = middlePositions.get(i + 2);
            RoadsideStructureService.tryPlace(world, server, middle, prev, next, roadWidth, roadLength, ctx, random, cfg);
        }
    }

    private static int calculateCheckInterval(int totalSegments, int maxStructures) {
        if (maxStructures <= 0 || totalSegments <= 0) {
            return Integer.MAX_VALUE;
        }
        return Math.max(1, totalSegments / (maxStructures + 1));
    }

    private static Rotation calculateRotation(double dirX, double dirZ, boolean leftSide, boolean faceRoad) {
        double absZ;
        if (!faceRoad) {
            return Rotation.NONE;
        }
        double absX = Math.abs(dirX);
        if (absX > (absZ = Math.abs(dirZ))) {
            if (leftSide) {
                return dirX > 0.0 ? Rotation.CLOCKWISE_180 : Rotation.NONE;
            }
            return dirX > 0.0 ? Rotation.NONE : Rotation.CLOCKWISE_180;
        }
        if (leftSide) {
            return dirZ > 0.0 ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90;
        }
        return dirZ > 0.0 ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
    }

    private static int[][] getSampleOffsets(int halfX, int halfZ) {
        return new int[][]{{0, 0}, {-halfX, -halfZ}, {halfX, -halfZ}, {-halfX, halfZ}, {halfX, halfZ}};
    }

    private static int[] sampleGroundHeights(WorldGenLevel world, int centerX, int centerZ, int halfX, int halfZ) {
        int maxY = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        for (int[] offset : RoadsideStructureService.getSampleOffsets(halfX, halfZ)) {
            int x = centerX + offset[0];
            int z = centerZ + offset[1];
            int y = world.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
            maxY = Math.max(maxY, y);
            minY = Math.min(minY, y);
        }
        return new int[]{maxY, minY};
    }

    private static boolean isOnWater(WorldGenLevel world, int centerX, int centerY, int centerZ, int halfX, int halfZ) {
        for (int[] offset : RoadsideStructureService.getSampleOffsets(halfX, halfZ)) {
            int x = centerX + offset[0];
            int z = centerZ + offset[1];
            for (int dy = 0; dy >= -2; --dy) {
                BlockState state = world.getBlockState(new BlockPos(x, centerY + dy, z));
                if (!state.is(Blocks.WATER) && !state.getFluidState().isSource()) continue;
                return true;
            }
        }
        return false;
    }
}

