/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.roadside;

import java.util.ArrayList;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.shiroha233.roadweaver.structures.roadside.BiomeCategory;
import net.shiroha233.roadweaver.structures.roadside.RoadsidePlacementRule;
import net.shiroha233.roadweaver.structures.roadside.StructureScale;

public enum RoadsideType {
    BENCH("roadside/roadside_bench", 3, 2, 2, 10, true, StructureScale.SMALL, RoadsidePlacementRule.TEMPERATE),
    CAMPFIRE("roadside/small_campfire", 3, 3, 3, 8, false, StructureScale.SMALL, RoadsidePlacementRule.UNIVERSAL),
    SAKURA_COFFEE_HOUSE("roadside/sakura_coffee_house", 12, 10, 12, 5, true, StructureScale.MEDIUM, RoadsidePlacementRule.builder().allow(BiomeCategory.CHERRY_GROVE).minRoadLength(50).build());

    private final ResourceLocation templateId;
    private final Vec3i sizeHint;
    private final int weight;
    private final boolean faceRoad;
    private final StructureScale scale;
    private final RoadsidePlacementRule placementRule;

    private RoadsideType(String path, int sizeX, int sizeY, int sizeZ, int weight, boolean faceRoad, StructureScale scale, RoadsidePlacementRule placementRule) {
        this.templateId = ResourceLocation.fromNamespaceAndPath((String)"roadweaver", (String)path);
        this.sizeHint = new Vec3i(sizeX, sizeY, sizeZ);
        this.weight = weight;
        this.faceRoad = faceRoad;
        this.scale = scale;
        this.placementRule = placementRule;
    }

    public ResourceLocation templateId() {
        return this.templateId;
    }

    public Vec3i sizeHint() {
        return this.sizeHint;
    }

    public int weight() {
        return this.weight;
    }

    public boolean faceRoad() {
        return this.faceRoad;
    }

    public StructureScale scale() {
        return this.scale;
    }

    public RoadsidePlacementRule placementRule() {
        return this.placementRule;
    }

    @Deprecated
    public static RoadsideType chooseWeighted(RandomSource random) {
        int total = 0;
        for (RoadsideType t : RoadsideType.values()) {
            total += t.weight;
        }
        int roll = random.nextInt(total);
        int sum = 0;
        for (RoadsideType t : RoadsideType.values()) {
            if (roll >= (sum += t.weight)) continue;
            return t;
        }
        return RoadsideType.values()[0];
    }

    public static RoadsideType chooseWeightedFiltered(RandomSource random, BiomeCategory biome, int roadLength) {
        ArrayList<RoadsideType> candidates = new ArrayList<RoadsideType>();
        int totalWeight = 0;
        for (RoadsideType type : RoadsideType.values()) {
            RoadsidePlacementRule rule = type.placementRule;
            if (!rule.isBiomeAllowed(biome) || !rule.isRoadLongEnough(roadLength)) continue;
            candidates.add(type);
            totalWeight += type.weight;
        }
        if (candidates.isEmpty() || totalWeight <= 0) {
            return null;
        }
        int roll = random.nextInt(totalWeight);
        int sum = 0;
        for (RoadsideType type : candidates) {
            if (roll >= (sum += type.weight)) continue;
            return type;
        }
        return (RoadsideType)((Object)candidates.get(0));
    }
}

