/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.spawn;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;
import net.shiroha233.roadweaver.structures.StructureSystem;
import net.shiroha233.roadweaver.structures.api.BlendProfile;
import net.shiroha233.roadweaver.structures.api.SpawnRule;
import net.shiroha233.roadweaver.structures.api.StructureBlueprint;
import net.shiroha233.roadweaver.structures.api.StructureConnector;
import net.shiroha233.roadweaver.structures.api.StructureVariant;
import net.shiroha233.roadweaver.structures.model.StructureInstance;
import net.shiroha233.roadweaver.structures.pipeline.StructurePlacer;

public final class SpawnCabinService {
    private static final ResourceLocation BLUEPRINT_ID = ResourceLocation.fromNamespaceAndPath((String)"roadweaver", (String)"spawn_cabin");
    private static final ResourceLocation TEMPLATE_ID = ResourceLocation.fromNamespaceAndPath((String)"roadweaver", (String)"structures/starting_cabin");

    private SpawnCabinService() {
    }

    public static boolean ensurePlaced(ServerLevel level) {
        if (level == null) {
            return false;
        }
        BlockPos spawn = level.getSharedSpawnPos();
        if (StructureSystem.index(level).existsNear(spawn, 64)) {
            return false;
        }
        WorldDataProvider provider = WorldDataProvider.getInstance();
        Records.StructureLocationData locs = provider.getStructureLocations(level);
        if (locs != null && locs.structureLocations() != null && !locs.structureLocations().isEmpty()) {
            return false;
        }
        StructureBlueprint bp = StructureBlueprints.spawnCabin(BLUEPRINT_ID, TEMPLATE_ID);
        StructureSystem.registerBlueprint(bp);
        int y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, spawn.getX(), spawn.getZ());
        BlockPos anchor = new BlockPos(spawn.getX(), y, spawn.getZ());
        AABB bounds = new AABB(anchor).inflate(8.0, 5.0, 8.0);
        BlendProfile blend = BlendProfile.platformDefault();
        StructureInstance inst = StructurePlacer.place(level, bp, TEMPLATE_ID, anchor, Rotation.NONE, Mirror.NONE, bounds, blend);
        StructureSystem.index(level).add(inst);
        provider.addStructureLocation(level, anchor);
        provider.addStructureInstance(level, inst);
        return true;
    }

    static final class StructureBlueprints {
        StructureBlueprints() {
        }

        static StructureBlueprint spawnCabin(ResourceLocation id, ResourceLocation templateId) {
            List<StructureVariant> variants = Collections.singletonList(new StructureVariant(templateId, 1, true));
            List<StructureConnector> connectors = Collections.emptyList();
            Vec3i sizeHint = new Vec3i(16, 10, 16);
            SpawnRule rule = new SpawnRule(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), 32, 8, 0, 255, 20, 32);
            return new StructureBlueprint(id, variants, connectors, sizeHint, BlendProfile.platformDefault(), rule);
        }
    }
}

