/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.config;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.shiroha233.roadweaver.config.PresetService;

public class MaterialPresetEditorScreen
extends Screen {
    private static final int MAX_MATERIALS = 16;
    private static final int LEFT_COLS = 4;
    private static final int LEFT_ROWS = 4;
    private static final int RIGHT_COLS = 25;
    private static final int RIGHT_ROWS = 20;
    private static final int SLOT_SIZE = 18;
    private final Screen parent;
    private EditBox searchBox;
    private EditBox presetNameBox;
    private final List<String> materialIds = new ArrayList<String>();
    private final List<String> slabMaterialIds = new ArrayList<String>();
    private final List<Block> allBlocks = new ArrayList<Block>();
    private final List<Block> filteredBlocks = new ArrayList<Block>();
    private int blockScrollOffset = 0;
    private int visibleRightRows = 20;
    private int visibleRightCols = 25;
    private final List<UiPreset> presets = new ArrayList<UiPreset>();
    private final List<String> originalPresetIds = new ArrayList<String>();
    private int activePresetIndex = 0;
    private final List<Button> presetButtons = new ArrayList<Button>();
    private boolean loadedFromConfig = false;
    private TargetList activeList = TargetList.BASE;

    public MaterialPresetEditorScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"gui.roadweaver.preset_editor.title"));
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        if (!this.loadedFromConfig) {
            this.loadPresetsFromJson();
            this.loadedFromConfig = true;
        }
        if (this.allBlocks.isEmpty()) {
            this.buildCandidateBlocksFromCreativeTabs();
        }
        int centerX = this.f_96543_ / 2;
        int top = 40;
        int gridTop = 70;
        int actionY = this.f_96544_ - 60;
        int availableHeight = Math.max(0, actionY - gridTop);
        this.visibleRightRows = Math.max(3, Math.min(20, availableHeight / 18));
        if (this.visibleRightRows <= 0) {
            this.visibleRightRows = 1;
        }
        int rightAreaX = centerX - 10;
        int marginRight = 20;
        int availableWidth = Math.max(1, this.f_96543_ - marginRight - rightAreaX);
        int colsByWidth = Math.max(1, availableWidth / 18);
        this.visibleRightCols = Math.min(25, colsByWidth);
        this.searchBox = new EditBox(this.f_96547_, centerX - 80, top, 160, 20, (Component)Component.m_237115_((String)"gui.roadweaver.preset_editor.search"));
        this.searchBox.m_94199_(64);
        this.searchBox.m_94151_(this::onSearchChanged);
        this.m_142416_((GuiEventListener)this.searchBox);
        int presetWidth = 120;
        int presetsLeftX = centerX - 260;
        this.presetNameBox = new EditBox(this.f_96547_, presetsLeftX, top, presetWidth, 20, (Component)Component.m_237115_((String)"gui.roadweaver.preset_editor.name"));
        this.presetNameBox.m_94199_(32);
        this.presetNameBox.m_94144_(this.getActivePresetName());
        this.m_142416_((GuiEventListener)this.presetNameBox);
        this.presetButtons.clear();
        for (int i = 0; i < this.presets.size(); ++i) {
            int idx = i;
            UiPreset p = this.presets.get(i);
            Button btn2 = Button.m_253074_((Component)Component.m_237113_((String)p.name), b -> this.selectPreset(idx)).m_252987_(presetsLeftX, gridTop + i * 22, presetWidth, 20).m_253136_();
            this.presetButtons.add(btn2);
            this.m_142416_((GuiEventListener)btn2);
        }
        this.updatePresetButtonStates();
        int smallWidth = 50;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.roadweaver.preset_editor.new"), b -> this.onNewPreset()).m_252987_(presetsLeftX, actionY, smallWidth, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.roadweaver.preset_editor.rename"), b -> this.onRenamePreset()).m_252987_(presetsLeftX + smallWidth + 4, actionY, smallWidth + 10, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.roadweaver.preset_editor.delete"), b -> this.onDeletePreset()).m_252987_(presetsLeftX + smallWidth * 2 + 8 + 10, actionY, smallWidth + 10, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.roadweaver.common.save"), btn -> this.onSave()).m_252987_(centerX - 80, this.f_96544_ - 30, 70, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.roadweaver.common.cancel"), btn -> this.onCancel()).m_252987_(centerX + 10, this.f_96544_ - 30, 70, 20).m_253136_());
        this.rebuildFilteredList();
    }

    private void onSearchChanged(String text) {
        this.blockScrollOffset = 0;
        this.rebuildFilteredList();
    }

    private void rebuildFilteredList() {
        this.filteredBlocks.clear();
        String q = this.searchBox == null ? "" : this.searchBox.m_94155_().trim().toLowerCase();
        for (Block b : this.allBlocks) {
            ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)b);
            if (id == null || !q.isEmpty() && !id.toString().toLowerCase().contains(q)) continue;
            this.filteredBlocks.add(b);
        }
    }

    private void renderSlabGrid(GuiGraphics g, int startX, int startY, int mouseX, int mouseY) {
        int index = 0;
        int bgColor = this.activeList == TargetList.SLAB ? -1073741824 : Integer.MIN_VALUE;
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 4; ++col) {
                Block b;
                int x = startX + col * 18;
                int y = startY + row * 18;
                g.m_280509_(x, y, x + 18, y + 18, bgColor);
                if (index < this.slabMaterialIds.size() && (b = this.blockFromId(this.slabMaterialIds.get(index))) != null && b != Blocks.f_50016_) {
                    ItemStack stack = new ItemStack((ItemLike)b);
                    g.m_280203_(stack, x + 1, y + 1);
                }
                ++index;
            }
        }
    }

    private void loadPresetsFromJson() {
        this.presets.clear();
        this.originalPresetIds.clear();
        PresetService.reload();
        List<PresetService.PresetDef> defs = PresetService.getAllPresets();
        for (PresetService.PresetDef def : defs) {
            UiPreset p = new UiPreset();
            p.id = def.id();
            p.name = def.name();
            p.materials = new ArrayList<String>(def.materials());
            p.slabMaterials = new ArrayList<String>(def.slabMaterials());
            this.presets.add(p);
            this.originalPresetIds.add(p.id);
        }
        if (this.presets.isEmpty()) {
            UiPreset p = new UiPreset();
            p.id = "custom_1";
            p.name = "Custom 1";
            p.materials = new ArrayList<String>();
            p.slabMaterials = new ArrayList<String>();
            this.presets.add(p);
        }
        if (this.activePresetIndex < 0 || this.activePresetIndex >= this.presets.size()) {
            this.activePresetIndex = 0;
        }
        this.materialIds.clear();
        this.materialIds.addAll(this.presets.get((int)this.activePresetIndex).materials);
        if (this.materialIds.size() > 16) {
            this.materialIds.subList(16, this.materialIds.size()).clear();
        }
        this.slabMaterialIds.clear();
        this.slabMaterialIds.addAll(this.presets.get((int)this.activePresetIndex).slabMaterials);
        if (this.slabMaterialIds.size() > 16) {
            this.slabMaterialIds.subList(16, this.slabMaterialIds.size()).clear();
        }
    }

    private String getActivePresetName() {
        if (this.presets.isEmpty()) {
            return "";
        }
        int idx = Math.max(0, Math.min(this.activePresetIndex, this.presets.size() - 1));
        return this.presets.get((int)idx).name;
    }

    private void syncActivePresetFromUi() {
        String nameFromBox;
        if (this.presets.isEmpty()) {
            return;
        }
        int idx = Math.max(0, Math.min(this.activePresetIndex, this.presets.size() - 1));
        UiPreset active = this.presets.get(idx);
        String string = nameFromBox = this.presetNameBox != null ? this.presetNameBox.m_94155_().trim() : active.name;
        if (nameFromBox == null || nameFromBox.isBlank()) {
            nameFromBox = active.name;
        }
        active.name = nameFromBox;
        ArrayList<String> copy = new ArrayList<String>(this.materialIds);
        if (copy.size() > 16) {
            copy = new ArrayList(copy.subList(0, 16));
        }
        active.materials = copy;
        ArrayList<String> slabCopy = new ArrayList<String>(this.slabMaterialIds);
        if (slabCopy.size() > 16) {
            slabCopy = new ArrayList(slabCopy.subList(0, 16));
        }
        active.slabMaterials = slabCopy;
    }

    private String generateNewPresetId() {
        int idx = 1;
        while (true) {
            String candidate = "custom_" + idx;
            boolean exists = false;
            for (UiPreset p : this.presets) {
                if (!candidate.equals(p.id)) continue;
                exists = true;
                break;
            }
            if (!exists) {
                return candidate;
            }
            ++idx;
        }
    }

    private void selectPreset(int index) {
        if (index < 0 || index >= this.presets.size()) {
            return;
        }
        this.syncActivePresetFromUi();
        this.activePresetIndex = index;
        this.materialIds.clear();
        this.materialIds.addAll(this.presets.get((int)this.activePresetIndex).materials);
        if (this.materialIds.size() > 16) {
            this.materialIds.subList(16, this.materialIds.size()).clear();
        }
        this.slabMaterialIds.clear();
        this.slabMaterialIds.addAll(this.presets.get((int)this.activePresetIndex).slabMaterials);
        if (this.slabMaterialIds.size() > 16) {
            this.slabMaterialIds.subList(16, this.slabMaterialIds.size()).clear();
        }
        if (this.presetNameBox != null) {
            this.presetNameBox.m_94144_(this.getActivePresetName());
        }
        this.updatePresetButtonStates();
    }

    private void updatePresetButtonStates() {
        for (int i = 0; i < this.presetButtons.size(); ++i) {
            Button btn = this.presetButtons.get(i);
            if (btn == null) continue;
            boolean isActive = i == this.activePresetIndex;
            boolean bl = btn.f_93623_ = !isActive;
            if (i >= this.presets.size()) continue;
            btn.m_93666_((Component)Component.m_237113_((String)this.presets.get((int)i).name));
        }
    }

    private void onNewPreset() {
        this.syncActivePresetFromUi();
        String baseName = Component.m_237115_((String)"gui.roadweaver.preset_editor.default_name").getString();
        if (baseName == null || baseName.isBlank()) {
            baseName = "Preset";
        }
        String name = baseName + " " + (this.presets.size() + 1);
        String id = this.generateNewPresetId();
        UiPreset p = new UiPreset();
        p.id = id;
        p.name = name;
        p.materials = new ArrayList<String>();
        this.presets.add(p);
        this.activePresetIndex = this.presets.size() - 1;
        this.materialIds.clear();
        this.slabMaterialIds.clear();
        if (this.presetNameBox != null) {
            this.presetNameBox.m_94144_(name);
        }
        this.m_7856_();
    }

    private void onRenamePreset() {
        if (this.presets.isEmpty()) {
            return;
        }
        if (this.presetNameBox == null) {
            return;
        }
        String name = this.presetNameBox.m_94155_().trim();
        if (name.isEmpty()) {
            return;
        }
        this.presets.get((int)this.activePresetIndex).name = name;
        this.updatePresetButtonStates();
    }

    private void onDeletePreset() {
        if (this.presets.isEmpty()) {
            return;
        }
        this.presets.remove(this.activePresetIndex);
        if (this.presets.isEmpty()) {
            UiPreset p = new UiPreset();
            p.id = "custom_1";
            p.name = "Custom 1";
            p.materials = new ArrayList<String>();
            p.slabMaterials = new ArrayList<String>();
            this.presets.add(p);
            this.activePresetIndex = 0;
            this.materialIds.clear();
            this.slabMaterialIds.clear();
        } else {
            if (this.activePresetIndex >= this.presets.size()) {
                this.activePresetIndex = this.presets.size() - 1;
            }
            this.materialIds.clear();
            this.materialIds.addAll(this.presets.get((int)this.activePresetIndex).materials);
            if (this.materialIds.size() > 16) {
                this.materialIds.subList(16, this.materialIds.size()).clear();
            }
            this.slabMaterialIds.clear();
            this.slabMaterialIds.addAll(this.presets.get((int)this.activePresetIndex).slabMaterials);
            if (this.slabMaterialIds.size() > 16) {
                this.slabMaterialIds.subList(16, this.slabMaterialIds.size()).clear();
            }
        }
        if (this.presetNameBox != null) {
            this.presetNameBox.m_94144_(this.getActivePresetName());
        }
        this.m_7856_();
    }

    private void buildCandidateBlocksFromCreativeTabs() {
        this.allBlocks.clear();
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91074_ == null || mc.f_91074_.m_9236_() == null) {
            for (Block b : BuiltInRegistries.f_256975_) {
                if (b == Blocks.f_50016_) continue;
                this.allBlocks.add(b);
            }
            return;
        }
        FeatureFlagSet features = mc.f_91074_.f_108617_.m_247016_();
        boolean hasPermissions = mc.f_91074_.m_36337_();
        RegistryAccess registries = mc.f_91074_.m_9236_().m_9598_();
        CreativeModeTabs.m_269226_((FeatureFlagSet)features, (boolean)hasPermissions, (HolderLookup.Provider)registries);
        LinkedHashSet<Block> unique = new LinkedHashSet<Block>();
        this.addBlocksFromTab(unique, "building_blocks");
        this.addBlocksFromTab(unique, "natural_blocks");
        if (unique.isEmpty()) {
            for (Block b : BuiltInRegistries.f_256975_) {
                if (b == Blocks.f_50016_) continue;
                unique.add(b);
            }
        }
        this.allBlocks.addAll(unique);
    }

    private void addBlocksFromTab(Set<Block> out, String tabId) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation(tabId));
        CreativeModeTab tab = (CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(key);
        if (tab == null) {
            return;
        }
        for (ItemStack stack : tab.m_260957_()) {
            BlockItem blockItem;
            Block block;
            Item item = stack.m_41720_();
            if (!(item instanceof BlockItem) || (block = (blockItem = (BlockItem)item).m_40614_()) == Blocks.f_50016_) continue;
            out.add(block);
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        g.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        super.m_88315_(g, mouseX, mouseY, partialTick);
        int centerX = this.f_96543_ / 2;
        int leftAreaX = centerX - 140;
        int rightAreaX = centerX - 10;
        int gridTop = 70;
        int slabGridTop = gridTop + 72 + 8;
        this.renderMaterialsGrid(g, leftAreaX, gridTop, mouseX, mouseY);
        this.renderSlabGrid(g, leftAreaX, slabGridTop, mouseX, mouseY);
        this.renderBlocksGrid(g, rightAreaX, gridTop, mouseX, mouseY);
    }

    private void renderMaterialsGrid(GuiGraphics g, int startX, int startY, int mouseX, int mouseY) {
        int index = 0;
        int bgColor = this.activeList == TargetList.BASE ? -1073741824 : Integer.MIN_VALUE;
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 4; ++col) {
                Block b;
                int x = startX + col * 18;
                int y = startY + row * 18;
                g.m_280509_(x, y, x + 18, y + 18, bgColor);
                if (index < this.materialIds.size() && (b = this.blockFromId(this.materialIds.get(index))) != null && b != Blocks.f_50016_) {
                    ItemStack stack = new ItemStack((ItemLike)b);
                    g.m_280203_(stack, x + 1, y + 1);
                }
                ++index;
            }
        }
    }

    private void renderBlocksGrid(GuiGraphics g, int startX, int startY, int mouseX, int mouseY) {
        int indexBase;
        int rows = this.visibleRightRows;
        int cols = this.visibleRightCols;
        int maxOffset = Math.max(0, (this.filteredBlocks.size() + cols - 1) / cols - rows);
        if (this.blockScrollOffset > maxOffset) {
            this.blockScrollOffset = maxOffset;
        }
        if (this.blockScrollOffset < 0) {
            this.blockScrollOffset = 0;
        }
        int rowOffset = this.blockScrollOffset;
        int index = indexBase = rowOffset * cols;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                int x = startX + col * 18;
                int y = startY + row * 18;
                g.m_280509_(x, y, x + 18, y + 18, Integer.MIN_VALUE);
                if (index < this.filteredBlocks.size()) {
                    Block b = this.filteredBlocks.get(index);
                    ItemStack stack = new ItemStack((ItemLike)b);
                    g.m_280203_(stack, x + 1, y + 1);
                }
                ++index;
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        int centerX = this.f_96543_ / 2;
        int leftAreaX = centerX - 140;
        int rightAreaX = centerX - 10;
        int gridTop = 70;
        int slabGridTop = gridTop + 72 + 8;
        if (this.handleClickMaterials(mouseX, mouseY, leftAreaX, gridTop, button)) {
            return true;
        }
        if (this.handleClickSlabs(mouseX, mouseY, leftAreaX, slabGridTop, button)) {
            return true;
        }
        return this.handleClickBlocks(mouseX, mouseY, rightAreaX, gridTop, button);
    }

    private boolean handleClickMaterials(double mouseX, double mouseY, int startX, int startY, int button) {
        int index = 0;
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 4; ++col) {
                int x = startX + col * 18;
                int y = startY + row * 18;
                if (mouseX >= (double)x && mouseX < (double)(x + 18) && mouseY >= (double)y && mouseY < (double)(y + 18)) {
                    this.activeList = TargetList.BASE;
                    if (button == 0 && index < this.materialIds.size()) {
                        this.materialIds.remove(index);
                        return true;
                    }
                    return true;
                }
                ++index;
            }
        }
        return false;
    }

    private boolean handleClickSlabs(double mouseX, double mouseY, int startX, int startY, int button) {
        int index = 0;
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 4; ++col) {
                int x = startX + col * 18;
                int y = startY + row * 18;
                if (mouseX >= (double)x && mouseX < (double)(x + 18) && mouseY >= (double)y && mouseY < (double)(y + 18)) {
                    this.activeList = TargetList.SLAB;
                    if (button == 0 && index < this.slabMaterialIds.size()) {
                        this.slabMaterialIds.remove(index);
                        return true;
                    }
                    return true;
                }
                ++index;
            }
        }
        return false;
    }

    private boolean handleClickBlocks(double mouseX, double mouseY, int startX, int startY, int button) {
        int indexBase;
        int rowOffset = this.blockScrollOffset;
        int cols = this.visibleRightCols;
        int index = indexBase = rowOffset * cols;
        for (int row = 0; row < this.visibleRightRows; ++row) {
            for (int col = 0; col < cols; ++col) {
                int x = startX + col * 18;
                int y = startY + row * 18;
                if (mouseX >= (double)x && mouseX < (double)(x + 18) && mouseY >= (double)y && mouseY < (double)(y + 18)) {
                    if (button == 0 && index < this.filteredBlocks.size()) {
                        Block b = this.filteredBlocks.get(index);
                        ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)b);
                        if (id != null) {
                            if (this.activeList == TargetList.BASE) {
                                if (this.materialIds.size() < 16) {
                                    this.materialIds.add(id.toString());
                                }
                            } else if (this.slabMaterialIds.size() < 16) {
                                this.slabMaterialIds.add(id.toString());
                            }
                        }
                        return true;
                    }
                    return true;
                }
                ++index;
            }
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int centerX = this.f_96543_ / 2;
        int rightAreaX = centerX - 10;
        int gridTop = 70;
        int widthPx = this.visibleRightCols * 18;
        int heightPx = this.visibleRightRows * 18;
        int x0 = rightAreaX;
        int y0 = gridTop;
        if (mouseX >= (double)x0 && mouseX < (double)(x0 + widthPx) && mouseY >= (double)y0 && mouseY < (double)(y0 + heightPx)) {
            if (delta > 0.0) {
                --this.blockScrollOffset;
            }
            if (delta < 0.0) {
                ++this.blockScrollOffset;
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private Block blockFromId(String id) {
        try {
            ResourceLocation rl = new ResourceLocation(id);
            return (Block)BuiltInRegistries.f_256975_.m_7745_(rl);
        }
        catch (Exception e) {
            return Blocks.f_50016_;
        }
    }

    private void onSave() {
        if (!this.presets.isEmpty()) {
            String name;
            int idx = Math.max(0, Math.min(this.activePresetIndex, this.presets.size() - 1));
            UiPreset active = this.presets.get(idx);
            String string = name = this.presetNameBox != null ? this.presetNameBox.m_94155_().trim() : active.name;
            if (name == null || name.isBlank()) {
                name = active.name;
            }
            active.name = name;
            active.materials = new ArrayList<String>(this.materialIds);
            active.slabMaterials = new ArrayList<String>(this.slabMaterialIds);
        }
        LinkedHashSet<String> currentIds = new LinkedHashSet<String>();
        for (UiPreset p : this.presets) {
            if (p.id == null || p.id.isBlank()) continue;
            currentIds.add(p.id);
        }
        for (String id : this.originalPresetIds) {
            if (currentIds.contains(id)) continue;
            PresetService.deletePresetFile(id);
        }
        for (UiPreset p : this.presets) {
            if (p.id == null || p.id.isBlank()) continue;
            PresetService.saveOrUpdatePresetFile(p.id, p.name, p.materials, p.slabMaterials);
        }
        PresetService.reload();
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    private void onCancel() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private static enum TargetList {
        BASE,
        SLAB;

    }

    private static class UiPreset {
        String id;
        String name;
        List<String> materials = new ArrayList<String>();
        List<String> slabMaterials = new ArrayList<String>();

        private UiPreset() {
        }
    }
}

