/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.tips;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public final class LoadingTipsRenderer {
    private static final long INTERVAL_MILLIS = 3000L;
    private static final List<Component> TIPS = List.of(Component.m_237115_((String)"tip.roadweaver.loading.1"), Component.m_237115_((String)"tip.roadweaver.loading.2"), Component.m_237115_((String)"tip.roadweaver.loading.3"), Component.m_237115_((String)"tip.roadweaver.loading.4"), Component.m_237115_((String)"tip.roadweaver.loading.5"));
    private static int currentIndex = 0;
    private static long lastSwitchTimeMillis = 0L;

    private LoadingTipsRenderer() {
    }

    public static void render(GuiGraphics graphics) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            return;
        }
        if (TIPS.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (lastSwitchTimeMillis == 0L) {
            lastSwitchTimeMillis = now;
        }
        if (now - lastSwitchTimeMillis >= 3000L) {
            lastSwitchTimeMillis = now;
            currentIndex = (currentIndex + 1) % TIPS.size();
        }
        Component tip = TIPS.get(currentIndex);
        Font font = mc.f_91062_;
        int sw = mc.m_91268_().m_85445_();
        int sh = mc.m_91268_().m_85446_();
        int marginX = 6;
        int marginY = 6;
        int x = sw - font.m_92852_((FormattedText)tip) - marginX;
        Objects.requireNonNull(font);
        int y = sh - 9 - marginY;
        graphics.m_280614_(font, tip, x, y, 0xFFFFFF, false);
    }

    public static void reset() {
        currentIndex = 0;
        lastSwitchTimeMillis = 0L;
    }
}

