/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.decoration.system;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.shiroha233.roadweaver.config.ModConfig;

public final class TreeRemovalUtil {
    private TreeRemovalUtil() {
    }

    public static boolean fellTreeAt(WorldGenLevel world, BlockPos logStart, ModConfig cfg) {
        BlockPos down;
        BlockState downSt;
        boolean startIsTreeCore;
        if (cfg == null) {
            return false;
        }
        int radius = Math.max(2, Math.min(12, cfg.treeRemovalMaxRadius()));
        int maxH = Math.max(8, Math.min(64, cfg.treeRemovalMaxHeight()));
        int maxBlocks = Math.max(64, Math.min(8192, cfg.treeRemovalMaxBlocks()));
        int leavesConfirm = Math.max(0, Math.min(128, cfg.treeLeavesConfirm()));
        BlockState startState = world.m_8055_(logStart);
        boolean bl = startIsTreeCore = startState.m_204336_(BlockTags.f_13106_) || startState.m_60713_(Blocks.f_50571_) || TreeRemovalUtil.isVineLike(startState) || startState.m_60713_(Blocks.f_50262_) || startState.m_60713_(Blocks.f_152548_) || TreeRemovalUtil.isMushroomLike(startState);
        if (!startIsTreeCore) {
            return false;
        }
        BlockPos base = logStart;
        for (int steps = 0; steps < maxH && ((downSt = world.m_8055_(down = base.m_7495_())).m_204336_(BlockTags.f_13106_) || downSt.m_60713_(Blocks.f_50571_) || TreeRemovalUtil.isMushroomLike(downSt)); ++steps) {
            base = down;
        }
        int minX = base.m_123341_() - radius;
        int maxX = base.m_123341_() + radius;
        int minZ = base.m_123343_() - radius;
        int maxZ = base.m_123343_() + radius;
        int minY = Math.max(world.m_141937_(), base.m_123342_() - 1);
        int maxY = Math.min(world.m_151558_() - 1, base.m_123342_() + maxH);
        ArrayDeque<BlockPos> q = new ArrayDeque<BlockPos>();
        HashSet<Long> seen = new HashSet<Long>();
        ArrayList<BlockPos> toRemove = new ArrayList<BlockPos>();
        int leavesCount = 0;
        boolean hasBamboo = false;
        boolean hasVineLike = false;
        boolean hasCocoa = false;
        boolean hasMushroom = false;
        q.add(base);
        seen.add(base.m_121878_());
        while (!q.isEmpty() && toRemove.size() < maxBlocks) {
            BlockPos[] neigh;
            boolean coreTreeBlock;
            BlockPos p = (BlockPos)q.pollFirst();
            if (p.m_123341_() < minX || p.m_123341_() > maxX || p.m_123343_() < minZ || p.m_123343_() > maxZ || p.m_123342_() < minY || p.m_123342_() > maxY) continue;
            BlockState st = world.m_8055_(p);
            boolean isLog = st.m_204336_(BlockTags.f_13106_);
            boolean isLeaves = st.m_204336_(BlockTags.f_13035_);
            boolean isBamboo = st.m_60713_(Blocks.f_50571_);
            boolean isVine = TreeRemovalUtil.isVineLike(st);
            boolean isCocoa = st.m_60713_(Blocks.f_50262_);
            boolean isHangingRoots = st.m_60713_(Blocks.f_152548_);
            boolean isSnowLayer = st.m_60713_(Blocks.f_50125_);
            boolean isMushroomStem = st.m_60713_(Blocks.f_50182_);
            boolean isMushroomCap = st.m_60713_(Blocks.f_50181_) || st.m_60713_(Blocks.f_50180_);
            boolean isMushroom = isMushroomStem || isMushroomCap;
            boolean bl2 = coreTreeBlock = isLog || isLeaves || isBamboo || isVine || isCocoa || isHangingRoots || isMushroom;
            if (!coreTreeBlock) {
                if (!isSnowLayer) continue;
                toRemove.add(p);
                continue;
            }
            toRemove.add(p);
            if (isLeaves) {
                ++leavesCount;
            }
            if (isBamboo) {
                hasBamboo = true;
            }
            if (isVine) {
                hasVineLike = true;
            }
            if (isCocoa) {
                hasCocoa = true;
            }
            if (isMushroom) {
                hasMushroom = true;
            }
            for (BlockPos n : neigh = new BlockPos[]{p.m_7494_(), p.m_7495_(), p.m_122012_(), p.m_122019_(), p.m_122029_(), p.m_122024_()}) {
                long key = n.m_121878_();
                if (!seen.add(key)) continue;
                q.addLast(n);
            }
        }
        if (toRemove.isEmpty()) {
            return false;
        }
        if (!(hasBamboo || hasVineLike || hasCocoa || hasMushroom || leavesCount >= leavesConfirm)) {
            return false;
        }
        for (BlockPos p : toRemove) {
            world.m_7731_(p, Blocks.f_50016_.m_49966_(), 3);
        }
        return true;
    }

    public static boolean isVineLike(BlockState st) {
        return st.m_60713_(Blocks.f_50191_) || st.m_60713_(Blocks.f_152538_) || st.m_60713_(Blocks.f_152539_) || st.m_60713_(Blocks.f_50702_) || st.m_60713_(Blocks.f_50703_) || st.m_60713_(Blocks.f_50704_) || st.m_60713_(Blocks.f_50653_);
    }

    public static boolean isMushroomLike(BlockState st) {
        return st.m_60713_(Blocks.f_50182_) || st.m_60713_(Blocks.f_50181_) || st.m_60713_(Blocks.f_50180_);
    }
}

