/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.decoration.types;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.shiroha233.roadweaver.features.decoration.base.OrientedDecoration;
import net.shiroha233.roadweaver.features.decoration.material.wood.BiomeWoodAware;
import net.shiroha233.roadweaver.features.decoration.text.SignTextService;
import net.shiroha233.roadweaver.helpers.Records;

public class DistanceSignDecoration
extends OrientedDecoration
implements BiomeWoodAware {
    private final boolean isStart;
    private final String signText;
    private Records.WoodAssets wood;

    public DistanceSignDecoration(BlockPos pos, Vec3i direction, WorldGenLevel world, boolean isStart, String distanceText) {
        super(pos, direction, world);
        this.isStart = isStart;
        this.signText = distanceText;
    }

    @Override
    public void place() {
        if (!this.placeAllowed()) {
            return;
        }
        int rotation = this.getCardinalRotationFromVector(this.getOrthogonalVector(), this.isStart);
        OrientedDecoration.DirectionProperties props = this.getDirectionProperties(rotation);
        BlockPos basePos = this.getPos();
        WorldGenLevel world = this.getWorld();
        BlockPos signPos = basePos.m_6630_(2).m_121945_(props.offsetDirection.m_122424_());
        world.m_7731_(signPos, (BlockState)((BlockState)this.wood.hangingSign().m_49966_().m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(rotation))).m_61124_((Property)BlockStateProperties.f_61386_, (Comparable)Boolean.valueOf(true)), 3);
        this.updateSigns(world, signPos, this.signText);
        this.placeFenceStructure(basePos, props);
    }

    private void placeFenceStructure(BlockPos pos, OrientedDecoration.DirectionProperties props) {
        WorldGenLevel world = this.getWorld();
        world.m_7731_(pos.m_6630_(3).m_121945_(props.offsetDirection.m_122424_()), (BlockState)this.wood.fence().m_49966_().m_61124_((Property)props.directionProperty, (Comparable)Boolean.valueOf(true)), 3);
        world.m_7731_(pos.m_6630_(0), this.wood.fence().m_49966_(), 3);
        world.m_7731_(pos.m_6630_(1), this.wood.fence().m_49966_(), 3);
        world.m_7731_(pos.m_6630_(2), this.wood.fence().m_49966_(), 3);
        world.m_7731_(pos.m_6630_(3), (BlockState)this.wood.fence().m_49966_().m_61124_((Property)props.reverseDirectionProperty, (Comparable)Boolean.valueOf(true)), 3);
    }

    private void updateSigns(WorldGenLevel level, BlockPos pos, String text) {
        SignTextService.writeDistanceSign(level, pos, text);
    }

    @Override
    public void setWoodType(Records.WoodAssets assets) {
        this.wood = assets;
    }
}

