/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.core;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.decoration.material.surface.BiomeRoadMaterialSelector;
import net.shiroha233.roadweaver.features.decoration.system.SurfacePlacementUtil;
import net.shiroha233.roadweaver.helpers.Records;

public final class SegmentPaver {
    private SegmentPaver() {
    }

    public static void paveSegment(WorldGenLevel world, Records.RoadSegmentPlacement seg, int averageY, int roadType, List<BlockState> materials, List<BlockState> slabMaterials, boolean useSlab, RandomSource random, ModConfig cfg) {
        for (BlockPos widthBlock : seg.positions()) {
            BlockPos pos = new BlockPos(widthBlock.m_123341_(), averageY, widthBlock.m_123343_());
            List<BlockState> baseMats = roadType == 1 ? BiomeRoadMaterialSelector.forBiome(world, pos) : materials;
            SurfacePlacementUtil.placeOnSurface(world, pos, baseMats, 0, random, cfg);
            if (roadType != 0 || !useSlab || slabMaterials == null || slabMaterials.isEmpty()) continue;
            BlockState slabState = slabMaterials.get(random.m_188503_(slabMaterials.size()));
            if (slabState.m_60734_() instanceof SlabBlock) {
                slabState = (BlockState)slabState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM);
            }
            world.m_7731_(pos, slabState, 3);
        }
    }
}

