/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.pathfinding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.PathPostProcessor;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.RoadPathCalculator;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.TerrainSamplingCache;
import net.shiroha233.roadweaver.helpers.Records;

final class GradientDescentPathfinder {
    private static final int BIOME_BASE_COST = 12;
    private static final int SEARCH_BUFFER = 64;

    private GradientDescentPathfinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Records.RoadSegmentPlacement> calculatePath(BlockPos startGround, BlockPos endGround, int width, ServerLevel level, int maxSteps, TerrainSamplingCache cache) {
        ModConfig cfg = ConfigService.get();
        int minX = Math.min(startGround.m_123341_(), endGround.m_123341_()) - 64;
        int maxX = Math.max(startGround.m_123341_(), endGround.m_123341_()) + 64;
        int minZ = Math.min(startGround.m_123343_(), endGround.m_123343_()) - 64;
        int maxZ = Math.max(startGround.m_123343_(), endGround.m_123343_()) + 64;
        PriorityQueue<Node> openSet = new PriorityQueue<Node>(Comparator.comparingDouble(n -> n.fCost));
        HashMap<BlockPos, Node> allNodes = new HashMap<BlockPos, Node>();
        HashSet<BlockPos> closed = new HashSet<BlockPos>();
        Node startNode = new Node(startGround, null, 0.0, GradientDescentPathfinder.heuristic(startGround, endGround) * cfg.heuristicWeight());
        openSet.add(startNode);
        allNodes.put(startGround, startNode);
        int d = RoadPathCalculator.getNeighborDistance();
        int[][] neighborOffsets = new int[][]{{d, 0}, {-d, 0}, {0, d}, {0, -d}, {d, d}, {d, -d}, {-d, d}, {-d, -d}};
        int stepsBudget = Math.max(5000, maxSteps * 3);
        try {
            while (!openSet.isEmpty() && stepsBudget-- > 0) {
                if (Thread.currentThread().isInterrupted()) {
                    List<Records.RoadSegmentPlacement> list = null;
                    return list;
                }
                Node current = openSet.poll();
                if (current == null) {
                    break;
                }
                if ((double)GradientDescentPathfinder.manhattan2d(current.pos, endGround) < (double)d * 1.5) {
                    List<Records.RoadSegmentPlacement> list = GradientDescentPathfinder.reconstructPath(current, width, level, cache);
                    return list;
                }
                closed.add(current.pos);
                for (Object object : (List<Records.RoadSegmentPlacement>)neighborOffsets) {
                    int offsetSum;
                    BlockPos nxz = current.pos.m_7918_((int)object[0], 0, (int)object[1]);
                    if (nxz.m_123341_() < minX || nxz.m_123341_() > maxX || nxz.m_123343_() < minZ || nxz.m_123343_() > maxZ) continue;
                    int y = RoadPathCalculator.heightSampler(cache, nxz.m_123341_(), nxz.m_123343_(), level);
                    BlockPos np = new BlockPos(nxz.m_123341_(), y, nxz.m_123343_());
                    if (closed.contains(np)) continue;
                    Holder<Biome> biome = cache.getBiome(level, np.m_123341_(), np.m_123343_());
                    int biomeCost = biome.m_203656_(BiomeTags.f_207605_) || biome.m_203656_(BiomeTags.f_207603_) || biome.m_203656_(BiomeTags.f_207602_) ? 12 : 0;
                    int elevation = Math.abs(y - current.pos.m_123342_());
                    int midX = (current.pos.m_123341_() + np.m_123341_()) / 2;
                    int midZ = (current.pos.m_123343_() + np.m_123343_()) / 2;
                    int midY = RoadPathCalculator.heightSampler(cache, midX, midZ, level);
                    int midDiff = Math.max(Math.abs(midY - current.pos.m_123342_()), Math.abs(midY - y));
                    double midTerrainPenalty = 0.0;
                    if (midDiff > 4) {
                        midTerrainPenalty = (double)(midDiff * midDiff * cfg.elevationWeight()) * 0.8;
                    }
                    double stepCost = (offsetSum = Math.abs(Math.abs((int)object[0])) + Math.abs((int)object[1])) == 2 * d ? cfg.diagStepCost() : cfg.orthoStepCost();
                    int stabilityCost = RoadPathCalculator.calculateTerrainStability(cache, np, y, level);
                    int sea = level.m_5736_();
                    boolean waterColumn = RoadPathCalculator.isColumnWater(cache, nxz.m_123341_(), nxz.m_123343_(), level);
                    boolean nearWater = RoadPathCalculator.isNearWaterLike(cache, nxz.m_123341_(), nxz.m_123343_(), level);
                    int oceanFloor = RoadPathCalculator.oceanFloorSampler(cache, nxz.m_123341_(), nxz.m_123343_(), level);
                    int waterDepth = Math.max(0, sea - oceanFloor);
                    int waterDepthCost = waterColumn ? waterDepth * cfg.waterDepthWeight() : 0;
                    int nearWaterCost = nearWater ? cfg.nearWaterCost() : 0;
                    double elevationCost = elevation * elevation * cfg.elevationWeight();
                    double slope = (double)elevation / (double)Math.max(1, d);
                    if (slope > 0.5) {
                        elevationCost += 800.0 * slope;
                    }
                    if (slope > 0.8) {
                        elevationCost += 8000.0;
                    }
                    double gCost = current.gCost + stepCost + elevationCost + midTerrainPenalty + (double)(biomeCost * cfg.biomeWeight()) + (double)(stabilityCost * cfg.stabilityWeight()) + (double)waterDepthCost + (double)nearWaterCost;
                    double hCost = GradientDescentPathfinder.heuristic(np, endGround) * cfg.heuristicWeight();
                    double fCost = gCost + hCost;
                    Node n2 = (Node)allNodes.get(np);
                    if (n2 != null && !(gCost < n2.gCost)) continue;
                    n2 = new Node(np, current, gCost, fCost);
                    allNodes.put(np, n2);
                    openSet.add(n2);
                }
            }
        }
        finally {
            openSet.clear();
            allNodes.clear();
            closed.clear();
        }
        return null;
    }

    private static List<Records.RoadSegmentPlacement> reconstructPath(Node endNode, int width, ServerLevel level, TerrainSamplingCache cache) {
        ArrayList<BlockPos> rawPath = new ArrayList<BlockPos>();
        Node c = endNode;
        while (c != null) {
            rawPath.add(c.pos);
            c = c.parent;
        }
        Collections.reverse(rawPath);
        return PathPostProcessor.process(rawPath, width, level, cache);
    }

    private static int manhattan2d(BlockPos a, BlockPos b) {
        return Math.abs(a.m_123341_() - b.m_123341_()) + Math.abs(a.m_123343_() - b.m_123343_());
    }

    private static double heuristic(BlockPos a, BlockPos b) {
        double dx = a.m_123341_() - b.m_123341_();
        double dz = a.m_123343_() - b.m_123343_();
        return Math.sqrt(dx * dx + dz * dz);
    }

    private static final class Node {
        final BlockPos pos;
        final Node parent;
        final double gCost;
        final double fCost;

        Node(BlockPos pos, Node parent, double gCost, double fCost) {
            this.pos = pos;
            this.parent = parent;
            this.gCost = gCost;
            this.fCost = fCost;
        }
    }
}

