/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.pathfinding;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;

public final class TerrainSamplingCache {
    private final Map<Long, Boolean> waterCache = new HashMap<Long, Boolean>();
    private final Map<Long, Boolean> nearWaterCache = new HashMap<Long, Boolean>();
    private final Map<Long, Boolean> columnWaterCache = new HashMap<Long, Boolean>();
    private final Map<Long, Integer> heightCache = new HashMap<Long, Integer>();
    private final Map<Long, Integer> oceanFloorCache = new HashMap<Long, Integer>();

    private static long hashXZ(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    public int height(ServerLevel level, int x, int z) {
        long key = TerrainSamplingCache.hashXZ(x, z);
        Integer cached = this.heightCache.get(key);
        if (cached != null) {
            return cached;
        }
        ChunkGenerator generator = level.m_7726_().m_8481_();
        RandomState rs = level.m_7726_().m_255415_().m_255046_();
        int h = generator.m_214096_(x, z, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (LevelHeightAccessor)level, rs);
        this.heightCache.put(key, h);
        return h;
    }

    boolean isWaterLike(ServerLevel level, int x, int z) {
        long key = TerrainSamplingCache.hashXZ(x, z);
        Boolean cached = this.waterCache.get(key);
        if (cached != null) {
            return cached;
        }
        ServerChunkCache chunkSource = level.m_7726_();
        RandomState randomState = chunkSource.m_255415_().m_255046_();
        BiomeSource biomeSource = chunkSource.m_8481_().m_62218_();
        Holder biome = biomeSource.m_203407_(x >> 2, 16, z >> 2, randomState.m_224579_());
        boolean res = biome.m_203656_(BiomeTags.f_207605_) || biome.m_203656_(BiomeTags.f_207603_) || biome.m_203656_(BiomeTags.f_207602_);
        this.waterCache.put(key, res);
        return res;
    }

    int oceanFloor(ServerLevel level, int x, int z) {
        long key = TerrainSamplingCache.hashXZ(x, z);
        Integer cached = this.oceanFloorCache.get(key);
        if (cached != null) {
            return cached;
        }
        ChunkGenerator generator = level.m_7726_().m_8481_();
        RandomState rs = level.m_7726_().m_255415_().m_255046_();
        int h = generator.m_214096_(x, z, Heightmap.Types.OCEAN_FLOOR_WG, (LevelHeightAccessor)level, rs);
        this.oceanFloorCache.put(key, h);
        return h;
    }

    boolean isNearWaterLike(ServerLevel level, int x, int z, int neighborDistance) {
        int[][] neighborOffsets;
        long key = TerrainSamplingCache.hashXZ(x, z);
        Boolean cached = this.nearWaterCache.get(key);
        if (cached != null) {
            return cached;
        }
        int d = neighborDistance;
        for (int[] off : neighborOffsets = new int[][]{{d, 0}, {-d, 0}, {0, d}, {0, -d}, {d, d}, {d, -d}, {-d, d}, {-d, -d}}) {
            int nx = x + off[0];
            int nz = z + off[1];
            if (!this.isWaterLike(level, nx, nz)) continue;
            this.nearWaterCache.put(key, true);
            return true;
        }
        this.nearWaterCache.put(key, false);
        return false;
    }

    boolean isColumnWater(ServerLevel level, int x, int z) {
        long key = TerrainSamplingCache.hashXZ(x, z);
        Boolean cached = this.columnWaterCache.get(key);
        if (cached != null) {
            return cached;
        }
        int of = this.oceanFloor(level, x, z);
        int sea = level.m_5736_();
        boolean isWaterBiome = this.isWaterLike(level, x, z);
        boolean isBelowSea = of < sea;
        boolean res = isWaterBiome && isBelowSea;
        this.columnWaterCache.put(key, res);
        return res;
    }

    Holder<Biome> getBiome(ServerLevel level, int x, int z) {
        ServerChunkCache chunkSource = level.m_7726_();
        RandomState randomState = chunkSource.m_255415_().m_255046_();
        BiomeSource biomeSource = chunkSource.m_8481_().m_62218_();
        return biomeSource.m_203407_(x >> 2, 16, z >> 2, randomState.m_224579_());
    }
}

