/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.helpers;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;

public final class StructureConnector {
    private static final Queue<Records.StructureConnection> CACHED = new ArrayDeque<Records.StructureConnection>();

    private StructureConnector() {
    }

    public static Queue<Records.StructureConnection> cachedStructureConnections() {
        return CACHED;
    }

    public static void cacheNewConnection(ServerLevel level, boolean locateAtPlayerIgnored) {
        WorldDataProvider provider = WorldDataProvider.getInstance();
        Records.StructureLocationData data = provider.getStructureLocations(level);
        List<BlockPos> list = data.structureLocations();
        if (list == null || list.size() < 2) {
            return;
        }
        StructureConnector.createNewStructureConnection(level);
    }

    private static void createNewStructureConnection(ServerLevel level) {
        WorldDataProvider provider = WorldDataProvider.getInstance();
        Records.StructureLocationData data = provider.getStructureLocations(level);
        List<BlockPos> all = data.structureLocations();
        if (all == null || all.size() < 2) {
            return;
        }
        BlockPos latest = all.get(all.size() - 1);
        BlockPos closest = StructureConnector.findClosest(latest, all);
        if (closest == null) {
            return;
        }
        ArrayList<Records.StructureConnection> connections = new ArrayList<Records.StructureConnection>(provider.getStructureConnections(level));
        if (!StructureConnector.exists(connections, latest, closest)) {
            Records.StructureConnection c = new Records.StructureConnection(latest, closest, Records.ConnectionStatus.PLANNED);
            connections.add(c);
            provider.setStructureConnections(level, connections);
            CACHED.add(c);
        }
    }

    private static boolean exists(List<Records.StructureConnection> existing, BlockPos a, BlockPos b) {
        for (Records.StructureConnection c : existing) {
            if ((!c.from().equals((Object)a) || !c.to().equals((Object)b)) && (!c.from().equals((Object)b) || !c.to().equals((Object)a))) continue;
            return true;
        }
        return false;
    }

    private static BlockPos findClosest(BlockPos cur, List<BlockPos> all) {
        BlockPos best = null;
        double min = Double.MAX_VALUE;
        for (BlockPos p : all) {
            double d;
            if (p.equals((Object)cur) || !((d = cur.m_123331_((Vec3i)p)) < min)) continue;
            min = d;
            best = p;
        }
        return best;
    }
}

