/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.mixin.forge;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.shiroha233.roadweaver.client.tips.LoadingTipsRenderer;
import net.shiroha233.roadweaver.generation.InitialGenManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelLoadingScreen.class})
public abstract class LevelLoadingScreenMixin {
    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void roadweaver$renderProgress(GuiGraphics graphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        LoadingTipsRenderer.render(graphics);
        if (!InitialGenManager.isActive()) {
            return;
        }
        int total = InitialGenManager.getTotal();
        int done = InitialGenManager.getDone();
        int generating = InitialGenManager.getGenerating();
        int failed = InitialGenManager.getFailed();
        int percent = total <= 0 ? 0 : (int)Math.round(100.0 * (double)done / (double)Math.max(1, total));
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        int sw = mc.m_91268_().m_85445_();
        int sh = mc.m_91268_().m_85446_();
        MutableComponent title = Component.m_237115_((String)"gui.roadweaver.initgen.title");
        MutableComponent summary = Component.m_237110_((String)"gui.roadweaver.initgen.summary", (Object[])new Object[]{total, generating, done, failed});
        MutableComponent progress = Component.m_237110_((String)"gui.roadweaver.initgen.progress", (Object[])new Object[]{done, total, percent});
        int y = sh - 60;
        int x = (sw - font.m_92852_((FormattedText)title)) / 2;
        graphics.m_280614_(font, (Component)title, x, y, 0xFFFFFF, false);
        x = (sw - font.m_92852_((FormattedText)summary)) / 2;
        graphics.m_280614_(font, (Component)summary, x, y += 12, 0xA0A0A0, false);
        x = (sw - font.m_92852_((FormattedText)progress)) / 2;
        graphics.m_280614_(font, (Component)progress, x, y += 12, 0xA0FFA0, false);
    }
}

