/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.network.forge;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.shiroha233.roadweaver.client.map.MapDataCollector;
import net.shiroha233.roadweaver.client.map.MapSnapshot;
import net.shiroha233.roadweaver.client.map.RoadMapScreen;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.network.MapSnapshotCodec;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;
import net.shiroha233.roadweaver.util.ComputeService;

public class MapNetworkForge {
    private static final String VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("roadweaver", "map"), () -> "1", "1"::equals, "1"::equals);
    private static int id = 0;

    public static void register() {
        CHANNEL.registerMessage(id++, RequestMapSnapshotC2S.class, RequestMapSnapshotC2S::encode, RequestMapSnapshotC2S::decode, RequestMapSnapshotC2S::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(id++, MapSnapshotS2C.class, MapSnapshotS2C::encode, MapSnapshotS2C::decode, MapSnapshotS2C::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(id++, TeleportC2S.class, TeleportC2S::encode, TeleportC2S::decode, TeleportC2S::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(id++, TeleportAckS2C.class, TeleportAckS2C::encode, TeleportAckS2C::decode, TeleportAckS2C::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(id++, ManualConnectC2S.class, ManualConnectC2S::encode, ManualConnectC2S::decode, ManualConnectC2S::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    public static void requestSnapshot(int minX, int minZ, int maxX, int maxZ) {
        CHANNEL.sendToServer((Object)new RequestMapSnapshotC2S(minX, minZ, maxX, maxZ));
    }

    public static void requestTeleport(int x, int y, int z) {
        CHANNEL.sendToServer((Object)new TeleportC2S(x, y, z));
    }

    public static void requestManualConnect(int ax, int az, int bx, int bz) {
        CHANNEL.sendToServer((Object)new ManualConnectC2S(ax, az, bx, bz));
    }

    public static class RequestMapSnapshotC2S {
        public final int minX;
        public final int minZ;
        public final int maxX;
        public final int maxZ;

        public RequestMapSnapshotC2S(int minX, int minZ, int maxX, int maxZ) {
            this.minX = minX;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxZ = maxZ;
        }

        public static void encode(RequestMapSnapshotC2S msg, FriendlyByteBuf buf) {
            buf.m_130130_(msg.minX);
            buf.m_130130_(msg.minZ);
            buf.m_130130_(msg.maxX);
            buf.m_130130_(msg.maxZ);
        }

        public static RequestMapSnapshotC2S decode(FriendlyByteBuf buf) {
            int minX = buf.m_130242_();
            int minZ = buf.m_130242_();
            int maxX = buf.m_130242_();
            int maxZ = buf.m_130242_();
            return new RequestMapSnapshotC2S(minX, minZ, maxX, maxZ);
        }

        public static void handle(RequestMapSnapshotC2S msg, Supplier<NetworkEvent.Context> ctx) {
            NetworkEvent.Context c = ctx.get();
            ServerPlayer player = c.getSender();
            if (player != null) {
                int radiusChunks;
                int cx = (int)Math.round(player.m_20185_());
                int cz = (int)Math.round(player.m_20189_());
                try {
                    ModConfig cfg = ConfigService.get();
                    radiusChunks = cfg.dynamicPlanEnabled() ? cfg.dynamicPlanRadiusChunks() : cfg.initialPlanRadiusChunks();
                }
                catch (Throwable t) {
                    radiusChunks = 256;
                }
                int radiusBlocks = Math.max(1, radiusChunks) * 16;
                CompletableFuture.supplyAsync(() -> MapDataCollector.build(player.m_284548_(), msg.minX, msg.minZ, msg.maxX, msg.maxZ, cx, cz, radiusBlocks), ComputeService.executor()).thenAccept(snap -> c.enqueueWork(() -> CHANNEL.sendTo((Object)new MapSnapshotS2C((MapSnapshot)snap), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT)));
            }
            c.setPacketHandled(true);
        }
    }

    public static class MapSnapshotS2C {
        public final MapSnapshot snapshot;

        public MapSnapshotS2C(MapSnapshot s) {
            this.snapshot = s;
        }

        public static void encode(MapSnapshotS2C msg, FriendlyByteBuf buf) {
            MapSnapshotCodec.write(buf, msg.snapshot);
        }

        public static MapSnapshotS2C decode(FriendlyByteBuf buf) {
            return new MapSnapshotS2C(MapSnapshotCodec.read(buf));
        }

        public static void handle(MapSnapshotS2C msg, Supplier<NetworkEvent.Context> ctx) {
            NetworkEvent.Context c = ctx.get();
            c.enqueueWork(() -> {
                Minecraft mc = Minecraft.m_91087_();
                Screen patt5272$temp = mc.f_91080_;
                if (patt5272$temp instanceof RoadMapScreen) {
                    RoadMapScreen screen = (RoadMapScreen)patt5272$temp;
                    screen.setSnapshot(msg.snapshot);
                }
            });
            c.setPacketHandled(true);
        }
    }

    public static class TeleportC2S {
        public final int x;
        public final int y;
        public final int z;

        public TeleportC2S(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public static void encode(TeleportC2S msg, FriendlyByteBuf buf) {
            buf.m_130130_(msg.x);
            buf.m_130130_(msg.y);
            buf.m_130130_(msg.z);
        }

        public static TeleportC2S decode(FriendlyByteBuf buf) {
            int x = buf.m_130242_();
            int y = buf.m_130242_();
            int z = buf.m_130242_();
            return new TeleportC2S(x, y, z);
        }

        public static void handle(TeleportC2S msg, Supplier<NetworkEvent.Context> ctx) {
            NetworkEvent.Context c = ctx.get();
            c.enqueueWork(() -> {
                boolean allowed;
                ServerPlayer sp = c.getSender();
                if (sp == null) {
                    return;
                }
                boolean bl = allowed = sp.m_7500_() || sp.m_20310_(2);
                if (!allowed) {
                    CHANNEL.sendTo((Object)new TeleportAckS2C(false, 0, 0, 0), sp.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                    return;
                }
                ServerLevel level = sp.m_284548_();
                level.m_6325_(msg.x >> 4, msg.z >> 4);
                int ty = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, msg.x, msg.z);
                ty = ty <= level.m_141937_() ? level.m_5736_() + 1 : ++ty;
                sp.m_8999_(level, (double)msg.x + 0.5, (double)ty, (double)msg.z + 0.5, sp.m_146908_(), sp.m_146909_());
                CHANNEL.sendTo((Object)new TeleportAckS2C(true, msg.x, ty, msg.z), sp.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            });
            c.setPacketHandled(true);
        }
    }

    public static class TeleportAckS2C {
        public final boolean ok;
        public final int x;
        public final int y;
        public final int z;

        public TeleportAckS2C(boolean ok, int x, int y, int z) {
            this.ok = ok;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public static void encode(TeleportAckS2C msg, FriendlyByteBuf buf) {
            buf.writeBoolean(msg.ok);
            buf.m_130130_(msg.x);
            buf.m_130130_(msg.y);
            buf.m_130130_(msg.z);
        }

        public static TeleportAckS2C decode(FriendlyByteBuf buf) {
            boolean ok = buf.readBoolean();
            int x = buf.m_130242_();
            int y = buf.m_130242_();
            int z = buf.m_130242_();
            return new TeleportAckS2C(ok, x, y, z);
        }

        public static void handle(TeleportAckS2C msg, Supplier<NetworkEvent.Context> ctx) {
            NetworkEvent.Context c = ctx.get();
            c.enqueueWork(() -> {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91074_ == null) {
                    return;
                }
                if (msg.ok) {
                    mc.f_91074_.m_5661_((Component)Component.m_237110_((String)"gui.roadweaver.map.teleport.success_pos", (Object[])new Object[]{msg.x, msg.y, msg.z}), true);
                } else {
                    mc.f_91074_.m_5661_((Component)Component.m_237115_((String)"gui.roadweaver.map.teleport.denied"), true);
                }
            });
            c.setPacketHandled(true);
        }
    }

    public static class ManualConnectC2S {
        public final int ax;
        public final int az;
        public final int bx;
        public final int bz;

        public ManualConnectC2S(int ax, int az, int bx, int bz) {
            this.ax = ax;
            this.az = az;
            this.bx = bx;
            this.bz = bz;
        }

        public static void encode(ManualConnectC2S msg, FriendlyByteBuf buf) {
            buf.m_130130_(msg.ax);
            buf.m_130130_(msg.az);
            buf.m_130130_(msg.bx);
            buf.m_130130_(msg.bz);
        }

        public static ManualConnectC2S decode(FriendlyByteBuf buf) {
            int ax = buf.m_130242_();
            int az = buf.m_130242_();
            int bx = buf.m_130242_();
            int bz = buf.m_130242_();
            return new ManualConnectC2S(ax, az, bx, bz);
        }

        public static void handle(ManualConnectC2S msg, Supplier<NetworkEvent.Context> ctx) {
            NetworkEvent.Context c = ctx.get();
            c.enqueueWork(() -> {
                ServerPlayer sp = c.getSender();
                if (sp == null) {
                    return;
                }
                ServerLevel level = sp.m_284548_();
                WorldDataProvider provider = WorldDataProvider.getInstance();
                List<Records.StructureConnection> origin = provider.getStructureConnections(level);
                ArrayList<Records.StructureConnection> list = origin != null ? new ArrayList<Records.StructureConnection>(origin) : new ArrayList();
                BlockPos a = new BlockPos(msg.ax, 0, msg.az);
                BlockPos b = new BlockPos(msg.bx, 0, msg.bz);
                boolean exists = false;
                for (Records.StructureConnection sc : list) {
                    BlockPos f = sc.from();
                    BlockPos t = sc.to();
                    if ((!f.equals((Object)a) || !t.equals((Object)b)) && (!f.equals((Object)b) || !t.equals((Object)a))) continue;
                    exists = true;
                    break;
                }
                if (!exists) {
                    list.add(new Records.StructureConnection(a, b, Records.ConnectionStatus.PLANNED));
                    provider.setStructureConnections(level, list);
                }
            });
            c.setPacketHandled(true);
        }
    }
}

