/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.pipeline;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.shiroha233.roadweaver.structures.api.BlendProfile;
import net.shiroha233.roadweaver.structures.api.StructureBlueprint;
import net.shiroha233.roadweaver.structures.blend.BlendPlan;
import net.shiroha233.roadweaver.structures.blend.TerrainBlender;
import net.shiroha233.roadweaver.structures.model.StructureInstance;

public final class StructurePlacer {
    private StructurePlacer() {
    }

    public static StructureInstance place(ServerLevel level, StructureBlueprint bp, ResourceLocation variantTemplateId, BlockPos anchor, Rotation rotation, Mirror mirror, AABB preBounds, BlendProfile blend) {
        ResourceLocation id = StructurePlacer.normalizeTemplateId(variantTemplateId);
        StructureTemplateManager mgr = level.m_7654_().m_236738_();
        Optional opt = mgr.m_230407_(id);
        if (opt.isEmpty()) {
            opt = mgr.m_230407_(variantTemplateId);
        }
        if (opt.isEmpty()) {
            AABB b = preBounds != null ? preBounds : new AABB(anchor).m_82377_(8.0, 5.0, 8.0);
            return new StructureInstance(UUID.randomUUID(), bp.id(), id, level.m_46472_().m_135782_(), anchor, b, level.m_46467_());
        }
        StructureTemplate tpl = (StructureTemplate)opt.get();
        Vec3i raw = tpl.m_163801_();
        Vec3i size = StructurePlacer.rotatedSize(raw, rotation);
        BlockPos min = anchor;
        BlockPos max = anchor.m_7918_(size.m_123341_() - 1, size.m_123342_() - 1, size.m_123343_() - 1);
        AABB bounds = new AABB(min, max);
        if (blend != null) {
            AABB horiz = new AABB((double)min.m_123341_(), (double)level.m_141937_(), (double)min.m_123343_(), (double)max.m_123341_(), (double)level.m_151558_(), (double)max.m_123343_());
            BlendPlan plan = TerrainBlender.plan((WorldGenLevel)level, horiz, blend);
            TerrainBlender.apply((WorldGenLevel)level, plan);
        }
        StructurePlacer.buildTrayFoundation(level, min, max);
        StructurePlaceSettings settings = new StructurePlaceSettings().m_74379_(rotation).m_74377_(mirror);
        tpl.m_230328_((ServerLevelAccessor)level, anchor, anchor, settings, level.m_213780_(), 2);
        return new StructureInstance(UUID.randomUUID(), bp.id(), id, level.m_46472_().m_135782_(), anchor, bounds, level.m_46467_());
    }

    private static ResourceLocation normalizeTemplateId(ResourceLocation in) {
        String path = in.m_135815_();
        if (path.startsWith("structures/")) {
            return new ResourceLocation(in.m_135827_(), path.substring("structures/".length()));
        }
        return in;
    }

    private static Vec3i rotatedSize(Vec3i s, Rotation r) {
        return switch (r) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE, Rotation.CLOCKWISE_180 -> s;
            case Rotation.CLOCKWISE_90, Rotation.COUNTERCLOCKWISE_90 -> new Vec3i(s.m_123343_(), s.m_123342_(), s.m_123341_());
        };
    }

    private static void buildTrayFoundation(ServerLevel level, BlockPos min, BlockPos max) {
        boolean insideFootprint;
        int z;
        int x;
        int yTop = min.m_123342_();
        int yMid = yTop - 1;
        int yBot = yTop - 2;
        int expand = 3;
        int cx0 = min.m_123341_() - expand;
        int cz0 = min.m_123343_() - expand;
        int cx1 = max.m_123341_() + expand;
        int cz1 = max.m_123343_() + expand;
        int chamfer = 3;
        int fx0 = min.m_123341_();
        int fz0 = min.m_123343_();
        int fx1 = max.m_123341_();
        int fz1 = max.m_123343_();
        for (x = cx0; x <= cx1; ++x) {
            for (z = cz0; z <= cz1; ++z) {
                if (!StructurePlacer.insideChamfered(x, z, cx0, cz0, cx1, cz1, chamfer)) continue;
                boolean bl = insideFootprint = x >= fx0 && x <= fx1 && z >= fz0 && z <= fz1;
                if (insideFootprint) continue;
                level.m_7731_(new BlockPos(x, yTop, z), Blocks.f_50440_.m_49966_(), 3);
                level.m_7731_(new BlockPos(x, yMid, z), Blocks.f_50493_.m_49966_(), 3);
                level.m_7731_(new BlockPos(x, yBot, z), Blocks.f_50493_.m_49966_(), 3);
            }
        }
        for (x = cx0; x <= cx1; ++x) {
            for (z = cz0; z <= cz1; ++z) {
                if (!StructurePlacer.insideChamfered(x, z, cx0, cz0, cx1, cz1, chamfer)) continue;
                boolean bl = insideFootprint = x >= fx0 && x <= fx1 && z >= fz0 && z <= fz1;
                if (insideFootprint) continue;
                boolean edge = false;
                if (!StructurePlacer.insideChamfered(x - 1, z, cx0, cz0, cx1, cz1, chamfer)) {
                    edge = true;
                } else if (!StructurePlacer.insideChamfered(x + 1, z, cx0, cz0, cx1, cz1, chamfer)) {
                    edge = true;
                } else if (!StructurePlacer.insideChamfered(x, z - 1, cx0, cz0, cx1, cz1, chamfer)) {
                    edge = true;
                } else if (!StructurePlacer.insideChamfered(x, z + 1, cx0, cz0, cx1, cz1, chamfer)) {
                    edge = true;
                }
                if (!edge) continue;
                StructurePlacer.fillDownToSurface(level, new BlockPos(x, yBot - 1, z));
            }
        }
    }

    private static boolean insideChamfered(int x, int z, int minX, int minZ, int maxX, int maxZ, int c) {
        if (x < minX || x > maxX || z < minZ || z > maxZ) {
            return false;
        }
        if (x - minX + (z - minZ) < c) {
            return false;
        }
        if (maxX - x + (z - minZ) < c) {
            return false;
        }
        if (x - minX + (maxZ - z) < c) {
            return false;
        }
        return maxX - x + (maxZ - z) >= c;
    }

    private static void fillDownToSurface(ServerLevel level, BlockPos start) {
        int top = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, start.m_123341_(), start.m_123343_());
        for (int y = start.m_123342_(); y >= Math.max(level.m_141937_(), top); --y) {
            level.m_7731_(new BlockPos(start.m_123341_(), y, start.m_123343_()), Blocks.f_50493_.m_49966_(), 3);
        }
    }
}

