/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StructureColorManager {
    private final Map<String, Integer> structureColors = new HashMap<String, Integer>();
    private final List<Integer> colorPalette = new ArrayList<Integer>();
    private int nextColorIndex = 0;

    public StructureColorManager() {
        this.initializeColorPalette();
    }

    private void initializeColorPalette() {
        this.colorPalette.add(-14176672);
        this.colorPalette.add(-13330213);
        this.colorPalette.add(-1618884);
        this.colorPalette.add(-812014);
        this.colorPalette.add(-6596170);
        this.colorPalette.add(-15024996);
        this.colorPalette.add(-1499549);
        this.colorPalette.add(-5317);
        this.colorPalette.add(-16728876);
        this.colorPalette.add(-43230);
        this.colorPalette.add(-7617718);
        this.colorPalette.add(-26624);
        this.colorPalette.add(-10011977);
        this.colorPalette.add(-16738680);
        this.colorPalette.add(-3285959);
        this.colorPalette.add(-49023);
        this.colorPalette.add(-16718218);
        this.colorPalette.add(-14575885);
        this.colorPalette.add(-37120);
        this.colorPalette.add(-8630785);
        this.colorPalette.add(-16728155);
        this.colorPalette.add(-16121);
        this.colorPalette.add(-2817799);
        this.colorPalette.add(-10167017);
        this.colorPalette.add(-16729900);
        this.colorPalette.add(-49920);
        this.colorPalette.add(-10149889);
        this.colorPalette.add(-14816842);
        this.colorPalette.add(-10752);
        this.colorPalette.add(-59580);
    }

    public int getColorForStructure(String structureId) {
        if (structureId == null || structureId.equals("unknown")) {
            return -8355712;
        }
        return this.structureColors.computeIfAbsent(structureId, id -> {
            int color = this.colorPalette.get(this.nextColorIndex % this.colorPalette.size());
            ++this.nextColorIndex;
            return color;
        });
    }

    public Map<String, Integer> getAllStructureColors() {
        return new HashMap<String, Integer>(this.structureColors);
    }

    public String getDisplayName(String structureId) {
        if (structureId == null || structureId.equals("unknown")) {
            return "\u672a\u77e5\u7ed3\u6784";
        }
        Object name = structureId;
        int colonIndex = ((String)name).indexOf(58);
        if (colonIndex >= 0 && colonIndex < ((String)name).length() - 1) {
            name = ((String)name).substring(colonIndex + 1);
        }
        if (((String)(name = ((String)name).replace('_', ' ').replace('/', ' '))).length() > 25) {
            name = ((String)name).substring(0, 22) + "...";
        }
        return name;
    }

    private int generateColorFromHash(String str) {
        int hash = str.hashCode();
        int r = 128 + ((hash & 0xFF0000) >> 16) / 2;
        int g = 128 + ((hash & 0xFF00) >> 8) / 2;
        int b = 128 + (hash & 0xFF) / 2;
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public void clear() {
        this.structureColors.clear();
        this.nextColorIndex = 0;
    }

    public int getStructureTypeCount() {
        return this.structureColors.size();
    }
}

