/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.decoration;

import java.util.Objects;
import net.countered.settlementroads.features.decoration.OrientedDecoration;
import net.countered.settlementroads.features.decoration.util.BiomeWoodAware;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class DistanceSignDecoration
extends OrientedDecoration
implements BiomeWoodAware {
    private final boolean isStart;
    private final String signText;
    private Records.WoodAssets wood;

    public DistanceSignDecoration(BlockPos pos, Vec3i direction, WorldGenLevel world, Boolean isStart, String distanceText) {
        super(pos, direction, world);
        this.isStart = isStart;
        this.signText = distanceText;
    }

    @Override
    public void place() {
        if (!this.placeAllowed()) {
            return;
        }
        int rotation = this.getCardinalRotationFromVector(this.getOrthogonalVector(), this.isStart);
        OrientedDecoration.DirectionProperties props = this.getDirectionProperties(rotation);
        BlockPos basePos = this.getPos();
        WorldGenLevel world = this.getWorld();
        BlockPos signPos = basePos.m_6630_(2).m_121945_(props.offsetDirection.m_122424_());
        world.m_7731_(signPos, (BlockState)((BlockState)this.wood.hangingSign().m_49966_().m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(rotation))).m_61124_((Property)BlockStateProperties.f_61386_, (Comparable)Boolean.valueOf(true)), 3);
        this.updateSigns(world, signPos, this.signText);
        this.placeFenceStructure(basePos, props);
    }

    private void placeFenceStructure(BlockPos pos, OrientedDecoration.DirectionProperties props) {
        WorldGenLevel world = this.getWorld();
        world.m_7731_(pos.m_6630_(3).m_121945_(props.offsetDirection.m_122424_()), (BlockState)this.wood.fence().m_49966_().m_61124_((Property)props.directionProperty, (Comparable)Boolean.valueOf(true)), 3);
        world.m_7731_(pos.m_6630_(0), this.wood.fence().m_49966_(), 3);
        world.m_7731_(pos.m_6630_(1), this.wood.fence().m_49966_(), 3);
        world.m_7731_(pos.m_6630_(2), this.wood.fence().m_49966_(), 3);
        world.m_7731_(pos.m_6630_(3), (BlockState)this.wood.fence().m_49966_().m_61124_((Property)props.reverseDirectionProperty, (Comparable)Boolean.valueOf(true)), 3);
    }

    private void updateSigns(WorldGenLevel worldGenLevel, BlockPos surfacePos, String text) {
        Objects.requireNonNull(worldGenLevel.m_6018_().m_7654_()).execute(() -> {
            BlockEntity signEntity = worldGenLevel.m_7702_(surfacePos);
            if (signEntity instanceof HangingSignBlockEntity) {
                HangingSignBlockEntity signBlockEntity = (HangingSignBlockEntity)signEntity;
                signBlockEntity.m_142339_((Level)worldGenLevel.m_6018_());
                SignText signText = signBlockEntity.m_277142_();
                signText = signText.m_276913_(0, (Component)Component.m_237115_((String)"sign.roadweaver.distance.separator"));
                signText = signText.m_276913_(1, (Component)Component.m_237115_((String)"sign.roadweaver.distance.next_location"));
                signText = signText.m_276913_(2, (Component)Component.m_237113_((String)(text + "m")));
                signText = signText.m_276913_(3, (Component)Component.m_237115_((String)"sign.roadweaver.distance.separator"));
                signBlockEntity.m_276956_(signText, true);
                SignText signTextBack = signBlockEntity.m_277159_();
                signTextBack = signTextBack.m_276913_(0, (Component)Component.m_237115_((String)"sign.roadweaver.distance.separator"));
                signTextBack = signTextBack.m_276913_(1, (Component)Component.m_237115_((String)"sign.roadweaver.distance.welcome"));
                signTextBack = signTextBack.m_276913_(2, (Component)Component.m_237115_((String)"sign.roadweaver.distance.traveller"));
                signTextBack = signTextBack.m_276913_(3, (Component)Component.m_237115_((String)"sign.roadweaver.distance.separator"));
                signBlockEntity.m_276956_(signTextBack, false);
                signBlockEntity.m_6596_();
            }
        });
    }

    @Override
    public void setWoodType(Records.WoodAssets assets) {
        this.wood = assets;
    }
}

