/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.decoration;

import net.countered.settlementroads.features.decoration.OrientedDecoration;
import net.countered.settlementroads.features.decoration.util.BiomeWoodAware;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;

public class LamppostDecoration
extends OrientedDecoration
implements BiomeWoodAware {
    private final boolean leftRoadSide;
    private Records.WoodAssets wood;

    public LamppostDecoration(BlockPos pos, Vec3i direction, WorldGenLevel world, boolean leftRoadSide) {
        super(pos, direction, world);
        this.leftRoadSide = leftRoadSide;
    }

    @Override
    public void place() {
        if (!this.placeAllowed()) {
            return;
        }
        BlockPos basePos = this.getPos();
        WorldGenLevel world = this.getWorld();
        this.buildNewLamppost(basePos, world);
    }

    private void buildNewLamppost(BlockPos basePos, WorldGenLevel world) {
        world.m_7731_(basePos, Blocks.f_152554_.m_49966_(), 3);
        world.m_7731_(basePos.m_6630_(1), Blocks.f_50479_.m_49966_(), 3);
        world.m_7731_(basePos.m_6630_(2), Blocks.f_50479_.m_49966_(), 3);
        world.m_7731_(basePos.m_6630_(3), Blocks.f_152554_.m_49966_(), 3);
        BlockPos lampPos = basePos.m_6630_(4);
        world.m_7731_(lampPos, Blocks.f_50261_.m_49966_(), 3);
        world.m_7731_(basePos.m_6630_(5), (BlockState)Blocks.f_50329_.m_49966_().m_61124_((Property)BlockStateProperties.f_61441_, (Comparable)Boolean.valueOf(true)), 3);
        this.placeTrapdoorsAroundLamp(lampPos, world);
    }

    private void placeTrapdoorsAroundLamp(BlockPos lampPos, WorldGenLevel world) {
        world.m_7731_(lampPos.m_122029_(), (BlockState)((BlockState)((BlockState)Blocks.f_50217_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST)).m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)Half.TOP), 3);
        world.m_7731_(lampPos.m_122024_(), (BlockState)((BlockState)((BlockState)Blocks.f_50217_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST)).m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)Half.TOP), 3);
        world.m_7731_(lampPos.m_122019_(), (BlockState)((BlockState)((BlockState)Blocks.f_50217_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH)).m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)Half.TOP), 3);
        world.m_7731_(lampPos.m_122012_(), (BlockState)((BlockState)((BlockState)Blocks.f_50217_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)Half.TOP), 3);
    }

    @Override
    public void setWoodType(Records.WoodAssets assets) {
        this.wood = assets;
    }
}

