/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.decoration;

import net.countered.settlementroads.features.decoration.OrientedDecoration;
import net.countered.settlementroads.features.decoration.util.BiomeWoodAware;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;

public class RoadFenceDecoration
extends OrientedDecoration
implements BiomeWoodAware {
    private final boolean leftRoadSide;
    private final int fenceLength;
    private Records.WoodAssets wood;

    public RoadFenceDecoration(BlockPos pos, Vec3i direction, WorldGenLevel world, boolean leftRoadSide, int fenceLength) {
        super(pos, direction, world);
        this.leftRoadSide = leftRoadSide;
        this.fenceLength = Math.min(3, Math.max(1, fenceLength));
    }

    @Override
    public void place() {
        if (!this.placeAllowed()) {
            return;
        }
        BlockPos basePos = this.getPos();
        WorldGenLevel world = this.getWorld();
        Vec3i roadDirection = this.getOrthogonalVector();
        Vec3i fenceDirection = new Vec3i(roadDirection.m_123343_(), 0, -roadDirection.m_123341_());
        for (int i = 0; i < this.fenceLength; ++i) {
            BlockPos fencePos = basePos.m_121955_(fenceDirection.m_142393_(i));
            BlockPos surfacePos = fencePos.m_175288_(world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, fencePos.m_123341_(), fencePos.m_123343_()));
            if (Math.abs(surfacePos.m_123342_() - basePos.m_123342_()) > 1) continue;
            world.m_7731_(surfacePos, this.wood.fence().m_49966_(), 3);
        }
    }

    @Override
    public void setWoodType(Records.WoodAssets assets) {
        this.wood = assets;
    }
}

