/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.roadlogic;

import java.util.ArrayList;
import java.util.List;
import net.countered.settlementroads.config.ConfigProvider;
import net.countered.settlementroads.config.IModConfig;
import net.countered.settlementroads.features.config.RoadFeatureConfig;
import net.countered.settlementroads.features.roadlogic.RoadPathCalculator;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.persistence.WorldDataProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;

public class Road {
    private final ServerLevel serverWorld;
    private final Records.StructureConnection structureConnection;
    private final RoadFeatureConfig context;

    public Road(ServerLevel serverWorld, Records.StructureConnection structureConnection, RoadFeatureConfig config) {
        this.serverWorld = serverWorld;
        this.structureConnection = structureConnection;
        this.context = config;
    }

    public void generateRoad(int maxSteps) {
        boolean ignoreWater;
        int maxStability;
        int maxHeightDiff;
        BlockPos end;
        this.updateConnectionStatus(Records.ConnectionStatus.GENERATING);
        RandomSource random = RandomSource.m_216327_();
        int width = Road.getRandomWidth(random, this.context.getWidths());
        IModConfig cfg = ConfigProvider.get();
        int type = Road.allowedRoadTypes(random, cfg);
        if (type == -1) {
            this.updateConnectionStatus(Records.ConnectionStatus.FAILED);
            return;
        }
        List<BlockState> material = type == 1 ? Road.getRandomMaterials(random, this.context.getNaturalMaterials()) : Road.getRandomMaterials(random, this.context.getArtificialMaterials());
        BlockPos start = this.structureConnection.from();
        List<Records.RoadSegmentPlacement> roadSegmentPlacementList = RoadPathCalculator.calculateAStarRoadPath(start, end = this.structureConnection.to(), width, this.serverWorld, maxSteps, maxHeightDiff = this.structureConnection.manual() ? cfg.manualMaxHeightDifference() : cfg.maxHeightDifference(), maxStability = this.structureConnection.manual() ? cfg.manualMaxTerrainStability() : cfg.maxTerrainStability(), ignoreWater = this.structureConnection.manual() && cfg.manualIgnoreWater());
        if (roadSegmentPlacementList.isEmpty()) {
            this.updateConnectionStatus(Records.ConnectionStatus.FAILED);
            return;
        }
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        ArrayList roadDataList = dataProvider.getRoadDataList(this.serverWorld);
        ArrayList<Records.RoadData> mutableList = new ArrayList<Records.RoadData>(roadDataList != null ? roadDataList : new ArrayList());
        mutableList.add(new Records.RoadData(width, type, material, roadSegmentPlacementList));
        dataProvider.setRoadDataList(this.serverWorld, mutableList);
        this.updateConnectionStatus(Records.ConnectionStatus.COMPLETED);
    }

    private void updateConnectionStatus(Records.ConnectionStatus newStatus) {
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        ArrayList connections = dataProvider.getStructureConnections(this.serverWorld);
        ArrayList<Records.StructureConnection> mutableConnections = new ArrayList<Records.StructureConnection>(connections != null ? connections : new ArrayList());
        for (int i = 0; i < mutableConnections.size(); ++i) {
            Records.StructureConnection conn = (Records.StructureConnection)mutableConnections.get(i);
            if ((!conn.from().equals((Object)this.structureConnection.from()) || !conn.to().equals((Object)this.structureConnection.to())) && (!conn.from().equals((Object)this.structureConnection.to()) || !conn.to().equals((Object)this.structureConnection.from()))) continue;
            mutableConnections.set(i, new Records.StructureConnection(conn.from(), conn.to(), newStatus, conn.manual()));
            dataProvider.setStructureConnections(this.serverWorld, mutableConnections);
            break;
        }
    }

    private static int allowedRoadTypes(RandomSource deterministicRandom, IModConfig cfg) {
        if (cfg.allowArtificial() && cfg.allowNatural()) {
            return Road.getRandomRoadType(deterministicRandom);
        }
        if (cfg.allowArtificial()) {
            return 0;
        }
        if (cfg.allowNatural()) {
            return 1;
        }
        return -1;
    }

    private static int getRandomRoadType(RandomSource random) {
        return random.m_188503_(2);
    }

    private static List<BlockState> getRandomMaterials(RandomSource random, List<List<BlockState>> materialsList) {
        return materialsList.get(random.m_188503_(materialsList.size()));
    }

    private static int getRandomWidth(RandomSource random, List<Integer> widthList) {
        return widthList.get(random.m_188503_(widthList.size()));
    }
}

