/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.helpers.async;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import net.countered.settlementroads.config.ConfigProvider;
import net.countered.settlementroads.config.IModConfig;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.persistence.WorldDataProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottledStructureLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    private static final int MAX_SEARCHES_PER_TICK = 1;
    private static final ConcurrentHashMap<String, Queue<LocateRequest>> pendingRequests = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, LocateStats> stats = new ConcurrentHashMap();

    public static void locateAsync(ServerLevel level, int locateCount, boolean locateAtPlayer, Consumer<List<LocateResult>> callback) {
        if (locateCount <= 0) {
            if (callback != null) {
                callback.accept(Collections.emptyList());
            }
            return;
        }
        String worldKey = level.m_46472_().m_135782_().toString();
        LocateRequest request = new LocateRequest(level, locateCount, locateAtPlayer, callback);
        Queue queue = pendingRequests.computeIfAbsent(worldKey, k -> new ConcurrentLinkedQueue());
        queue.add(request);
        LocateStats stat = stats.computeIfAbsent(worldKey, k -> new LocateStats());
        ++stat.queuedRequests;
        LOGGER.debug("\ud83d\udd0d Queued structure search request: world={}, count={}, queueSize={}", new Object[]{worldKey, locateCount, queue.size()});
    }

    public static void tickProcess(ServerLevel level) {
        String worldKey = level.m_46472_().m_135782_().toString();
        Queue<LocateRequest> queue = pendingRequests.get(worldKey);
        if (queue == null || queue.isEmpty()) {
            return;
        }
        int processed = 0;
        while (processed < 1 && !queue.isEmpty()) {
            LocateRequest request = queue.poll();
            if (request == null) continue;
            try {
                ThrottledStructureLocator.processRequest(request);
                ++processed;
            }
            catch (Exception e) {
                LOGGER.error("\u274c Error processing locate request: {}", (Object)e.getMessage(), (Object)e);
                if (request.callback == null) continue;
                request.callback.accept(Collections.emptyList());
            }
        }
        if (processed > 0) {
            LocateStats stat = stats.get(worldKey);
            if (stat != null) {
                stat.processedRequests += processed;
            }
            LOGGER.trace("Processed {} structure search requests, {} remaining in queue", (Object)processed, (Object)queue.size());
        }
    }

    private static void processRequest(LocateRequest request) {
        ServerLevel level = request.level;
        int locateCount = request.locateCount;
        boolean locateAtPlayer = request.locateAtPlayer;
        ArrayList<LocateResult> results = new ArrayList<LocateResult>();
        IModConfig config = ConfigProvider.get();
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        Records.StructureLocationData locationData = dataProvider.getStructureLocations(level);
        if (locationData == null) {
            locationData = new Records.StructureLocationData(new ArrayList<BlockPos>());
        }
        ArrayList<BlockPos> knownLocations = new ArrayList<BlockPos>(locationData.structureLocations());
        ArrayList<Records.StructureInfo> structureInfos = new ArrayList<Records.StructureInfo>(locationData.structureInfos());
        Optional<HolderSet<Structure>> targetStructures = ThrottledStructureLocator.resolveStructureTargets(level, config.structuresToLocate());
        if (targetStructures.isEmpty()) {
            LOGGER.warn("\u65e0\u6cd5\u89e3\u6790\u7ed3\u6784\u76ee\u6807\u5217\u8868\uff0c\u8df3\u8fc7\u641c\u5bfb");
            if (request.callback != null) {
                request.callback.accept(results);
            }
            return;
        }
        List<BlockPos> centers = ThrottledStructureLocator.collectSearchCenters(level, locateAtPlayer);
        int radius = Math.max(config.structureSearchRadius(), 1);
        for (BlockPos center : centers) {
            if (locateCount <= 0) break;
            try {
                Pair result = level.m_7726_().m_8481_().m_223037_(level, targetStructures.get(), center, radius, true);
                if (result == null) continue;
                BlockPos structurePos = (BlockPos)result.getFirst();
                Holder structureHolder = (Holder)result.getSecond();
                if (ThrottledStructureLocator.containsBlockPos(knownLocations, structurePos)) continue;
                knownLocations.add(structurePos);
                String structureId = structureHolder.m_203543_().map(key -> key.m_135782_().toString()).orElse("unknown");
                Records.StructureInfo info = new Records.StructureInfo(structurePos, structureId);
                structureInfos.add(info);
                results.add(new LocateResult(structurePos, structureId, true));
                --locateCount;
                LOGGER.debug("\u2705 Found structure {} at {}", (Object)structureId, (Object)structurePos);
            }
            catch (Exception e) {
                LOGGER.error("Error finding structure at {}: {}", (Object)center, (Object)e.getMessage());
            }
        }
        if (!results.isEmpty()) {
            dataProvider.setStructureLocations(level, new Records.StructureLocationData(knownLocations, structureInfos));
            LOGGER.info("Located {} new structures", (Object)results.size());
        }
        if (request.callback != null) {
            request.callback.accept(results);
        }
    }

    public static int getPendingCount(ServerLevel level) {
        String worldKey = level.m_46472_().m_135782_().toString();
        Queue<LocateRequest> queue = pendingRequests.get(worldKey);
        return queue != null ? queue.size() : 0;
    }

    public static void clearQueue(ServerLevel level) {
        String worldKey = level.m_46472_().m_135782_().toString();
        Queue<LocateRequest> queue = pendingRequests.remove(worldKey);
        if (queue != null) {
            queue.clear();
            LOGGER.debug("Cleared structure search queue for world: {}", (Object)worldKey);
        }
        stats.remove(worldKey);
    }

    public static void shutdown() {
        pendingRequests.clear();
        stats.clear();
        LOGGER.info("ThrottledStructureLocator shut down");
    }

    private static Optional<HolderSet<Structure>> resolveStructureTargets(ServerLevel level, List<String> identifiersList) {
        Registry registry = level.m_9598_().m_175515_(Registries.f_256944_);
        ArrayList holders = new ArrayList();
        if (identifiersList == null || identifiersList.isEmpty()) {
            return Optional.empty();
        }
        for (String line : identifiersList) {
            String[] tokens;
            String norm;
            if (line == null || (norm = line.replace('\r', ' ').replace('\n', ' ').trim()).isEmpty()) continue;
            for (String raw : tokens = norm.split("[;,\\s]+")) {
                String token;
                if (raw == null || (token = raw.trim()).isEmpty()) continue;
                token = token.replace("\r", "").replace("\n", "");
                token = token.replaceAll("^[\\\"'`]+|[\\\"'`]+$", "");
                if (!(token = token.replaceAll("[,;\uff0c\uff1b]+$", "")).isEmpty() && token.charAt(0) == '\ufeff') {
                    token = token.substring(1);
                }
                if ((token = token.replace('\uff03', '#').trim()).isEmpty()) continue;
                int hashIdx = token.indexOf(35);
                if (hashIdx >= 0) {
                    String tagToken = token.substring(hashIdx + 1).trim();
                    try {
                        ResourceLocation tagId = new ResourceLocation(tagToken);
                        TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)tagId);
                        registry.m_203431_(tag).ifPresent(named -> {
                            for (Holder h : named) {
                                holders.add(h);
                            }
                        });
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Invalid structure tag: #{}", (Object)tagToken);
                    }
                    continue;
                }
                try {
                    String cleaned = token.replaceAll("^[^a-z0-9_.:/\\-]+", "");
                    if (cleaned.contains("*")) {
                        String pattern = cleaned.replace("*", "");
                        for (Map.Entry entry : registry.m_6579_()) {
                            String structureId = ((ResourceKey)entry.getKey()).m_135782_().toString();
                            if (!structureId.startsWith(pattern)) continue;
                            registry.m_203636_((ResourceKey)entry.getKey()).ifPresent(holders::add);
                        }
                        continue;
                    }
                    ResourceLocation id = new ResourceLocation(cleaned);
                    ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)id);
                    registry.m_203636_(key).ifPresent(holders::add);
                }
                catch (Exception ex) {
                    LOGGER.warn("Invalid structure id: {}", (Object)token);
                }
            }
        }
        if (holders.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(HolderSet.m_205800_(holders));
    }

    private static List<BlockPos> collectSearchCenters(ServerLevel level, boolean locateAtPlayer) {
        ArrayList<BlockPos> centers = new ArrayList<BlockPos>();
        if (locateAtPlayer) {
            for (ServerPlayer player : level.m_6907_()) {
                centers.add(player.m_20183_());
            }
        }
        BlockPos spawn = level.m_220360_();
        if (centers.isEmpty()) {
            int[] muls;
            centers.add(spawn);
            int r = Math.max(ConfigProvider.get().structureSearchRadius(), 1);
            for (int m : muls = new int[]{3, 6}) {
                int d = r * m;
                centers.add(spawn.m_7918_(d, 0, 0));
                centers.add(spawn.m_7918_(-d, 0, 0));
                centers.add(spawn.m_7918_(0, 0, d));
                centers.add(spawn.m_7918_(0, 0, -d));
                centers.add(spawn.m_7918_(d, 0, d));
                centers.add(spawn.m_7918_(-d, 0, d));
                centers.add(spawn.m_7918_(d, 0, -d));
                centers.add(spawn.m_7918_(-d, 0, -d));
            }
        }
        return centers;
    }

    private static boolean containsBlockPos(List<BlockPos> list, BlockPos pos) {
        for (BlockPos existing : list) {
            if (!existing.equals((Object)pos)) continue;
            return true;
        }
        return false;
    }

    private static class LocateRequest {
        final ServerLevel level;
        final int locateCount;
        final boolean locateAtPlayer;
        final Consumer<List<LocateResult>> callback;

        LocateRequest(ServerLevel level, int locateCount, boolean locateAtPlayer, Consumer<List<LocateResult>> callback) {
            this.level = level;
            this.locateCount = locateCount;
            this.locateAtPlayer = locateAtPlayer;
            this.callback = callback;
        }
    }

    private static class LocateStats {
        int queuedRequests = 0;
        int processedRequests = 0;

        private LocateStats() {
        }
    }

    public static class LocateResult {
        public final BlockPos position;
        public final String structureId;
        public final boolean success;

        public LocateResult(BlockPos position, String structureId, boolean success) {
            this.position = position;
            this.structureId = structureId;
            this.success = success;
        }
    }
}

