/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.helpers.forge;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.countered.settlementroads.config.ConfigProvider;
import net.countered.settlementroads.config.IModConfig;
import net.countered.settlementroads.persistence.WorldDataProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StructureLocatorImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");

    public static void locateConfiguredStructure(ServerLevel serverWorld, int locateCount, boolean locateAtPlayer) {
        net.countered.settlementroads.helpers.StructureLocatorImpl.locateConfiguredStructure(serverWorld, locateCount, locateAtPlayer);
    }

    private static void executeLocateStructure(BlockPos locatePos, ServerLevel serverWorld, String structureId) {
        HolderSet structures;
        IModConfig config = ConfigProvider.get();
        Registry registry = serverWorld.m_9598_().m_175515_(Registries.f_256944_);
        if (structureId.startsWith("#")) {
            String tagId = structureId.substring(1);
            ResourceLocation tagLocation = new ResourceLocation(tagId);
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)tagLocation);
            Optional tagOpt = registry.m_203431_(tagKey);
            if (tagOpt.isEmpty()) {
                LOGGER.warn("Structure tag not found: {}", (Object)structureId);
                return;
            }
            structures = (HolderSet)tagOpt.get();
        } else {
            ResourceLocation structureLocation = new ResourceLocation(structureId);
            ResourceKey structureKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)structureLocation);
            Optional holderOpt = registry.m_203636_(structureKey);
            if (holderOpt.isEmpty()) {
                LOGGER.warn("Structure not found: {}", (Object)structureId);
                return;
            }
            structures = HolderSet.m_205809_((Holder[])new Holder[]{(Holder)holderOpt.get()});
        }
        Pair pair = serverWorld.m_7726_().m_8481_().m_223037_(serverWorld, structures, locatePos, config.structureSearchRadius(), true);
        if (pair == null) {
            LOGGER.debug("\u274c Structure not found for: {} (search radius: {})", (Object)structureId, (Object)config.structureSearchRadius());
            return;
        }
        BlockPos structureLocation = (BlockPos)pair.getFirst();
        LOGGER.info("\u2705 Structure found at {} for {}", (Object)structureLocation, (Object)structureId);
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        int beforeCount = dataProvider.getStructureLocations(serverWorld).structureLocations().size();
        dataProvider.addStructureLocation(serverWorld, structureLocation);
        int afterCount = dataProvider.getStructureLocations(serverWorld).structureLocations().size();
        if (afterCount > beforeCount) {
            LOGGER.info("\ud83d\udccd Added new structure at {}, total: {}", (Object)structureLocation, (Object)afterCount);
        } else {
            LOGGER.debug("Structure already exists at {}", (Object)structureLocation);
        }
    }
}

