/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.network;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.state.BlockState;

public class DebugDataPacket {
    private final List<Records.StructureInfo> structureInfos;
    private final List<Records.StructureConnection> connections;
    private final List<Records.RoadData> roads;

    public DebugDataPacket(List<Records.StructureInfo> structureInfos, List<Records.StructureConnection> connections, List<Records.RoadData> roads) {
        this.structureInfos = structureInfos != null ? structureInfos : new ArrayList();
        this.connections = connections != null ? connections : new ArrayList();
        this.roads = roads != null ? roads : new ArrayList();
    }

    public List<Records.StructureInfo> getStructureInfos() {
        return this.structureInfos;
    }

    public List<Records.StructureConnection> getConnections() {
        return this.connections;
    }

    public List<Records.RoadData> getRoads() {
        return this.roads;
    }

    public FriendlyByteBuf encode() {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(this.structureInfos.size());
        for (Records.StructureInfo info : this.structureInfos) {
            buf.m_130064_(info.pos());
            buf.m_130070_(info.structureId());
        }
        buf.writeInt(this.connections.size());
        for (Records.StructureConnection conn : this.connections) {
            buf.m_130064_(conn.from());
            buf.m_130064_(conn.to());
            buf.m_130070_(conn.status().name());
            buf.writeBoolean(conn.manual());
        }
        buf.writeInt(this.roads.size());
        for (Records.RoadData road : this.roads) {
            buf.writeInt(road.width());
            buf.writeInt(road.roadType());
            List<Records.RoadSegmentPlacement> segments = road.roadSegmentList();
            buf.writeInt(segments.size());
            for (Records.RoadSegmentPlacement segment : segments) {
                buf.m_130064_(segment.middlePos());
            }
        }
        return buf;
    }

    public static DebugDataPacket decode(FriendlyByteBuf buf) {
        int structureCount = buf.readInt();
        ArrayList<Records.StructureInfo> structureInfos = new ArrayList<Records.StructureInfo>();
        for (int i = 0; i < structureCount; ++i) {
            BlockPos pos = buf.m_130135_();
            String structureId = buf.m_130277_();
            structureInfos.add(new Records.StructureInfo(pos, structureId));
        }
        int connectionCount = buf.readInt();
        ArrayList<Records.StructureConnection> connections = new ArrayList<Records.StructureConnection>();
        for (int i = 0; i < connectionCount; ++i) {
            BlockPos from = buf.m_130135_();
            BlockPos to = buf.m_130135_();
            String statusStr = buf.m_130277_();
            boolean manual = buf.readBoolean();
            Records.ConnectionStatus status = Records.ConnectionStatus.valueOf(statusStr);
            connections.add(new Records.StructureConnection(from, to, status, manual));
        }
        int roadCount = buf.readInt();
        ArrayList<Records.RoadData> roads = new ArrayList<Records.RoadData>();
        for (int i = 0; i < roadCount; ++i) {
            int width = buf.readInt();
            int roadType = buf.readInt();
            int segmentCount = buf.readInt();
            ArrayList<Records.RoadSegmentPlacement> segments = new ArrayList<Records.RoadSegmentPlacement>();
            for (int j = 0; j < segmentCount; ++j) {
                BlockPos middlePos = buf.m_130135_();
                segments.add(new Records.RoadSegmentPlacement(middlePos, new ArrayList<BlockPos>()));
            }
            roads.add(new Records.RoadData(width, roadType, new ArrayList<BlockState>(), segments));
        }
        return new DebugDataPacket(structureInfos, connections, roads);
    }
}

