/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import io.netty.buffer.Unpooled;
import net.countered.settlementroads.network.DebugDataPacket;
import net.countered.settlementroads.network.PacketHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class RoadWeaverNetworkManager {
    public static final ResourceLocation REQUEST_DEBUG_DATA = new ResourceLocation("roadweaver", "request_debug_data");
    public static final ResourceLocation SEND_DEBUG_DATA = new ResourceLocation("roadweaver", "send_debug_data");

    public static void registerPackets() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)REQUEST_DEBUG_DATA, (buf, context) -> context.queue(() -> {
            ServerPlayer player;
            Player patt1069$temp = context.getPlayer();
            if (patt1069$temp instanceof ServerPlayer && (player = (ServerPlayer)patt1069$temp).m_20310_(2)) {
                PacketHandler.handleDebugDataRequest(player);
            }
        }));
        if (Platform.getEnvironment() == Env.CLIENT) {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)SEND_DEBUG_DATA, (buf, context) -> {
                DebugDataPacket packet = DebugDataPacket.decode(buf);
                context.queue(() -> PacketHandler.handleDebugDataResponse(packet));
            });
        }
    }

    public static void requestDebugData() {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        NetworkManager.sendToServer((ResourceLocation)REQUEST_DEBUG_DATA, (FriendlyByteBuf)buf);
    }

    public static void sendDebugData(ServerPlayer player, DebugDataPacket packet) {
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)SEND_DEBUG_DATA, (FriendlyByteBuf)packet.encode());
    }
}

