/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.shiroha233.roadweaver.config.ModConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String BASE_DIR = "roadweaver";
    private static final String FILE_NAME = "roadweaver.json";
    private static ModConfig INSTANCE = new ModConfig();

    private ConfigService() {
    }

    public static synchronized void load() {
        Path cfgRoot = Platform.getConfigFolder();
        Path baseDir = cfgRoot.resolve(BASE_DIR);
        Path file = baseDir.resolve(FILE_NAME);
        try {
            Files.createDirectories(baseDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to create config directory: {}", (Object)baseDir, (Object)e);
        }
        if (Files.exists(file, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                ModConfig loaded = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
                if (loaded != null) {
                    INSTANCE = loaded;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to read config, using defaults. File: {}", (Object)file, (Object)e);
            }
        } else {
            ConfigService.save();
        }
        try {
            INSTANCE.sanitize();
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to sanitize config; continuing with raw values.", t);
        }
        LOGGER.info("Configuration loaded (radiusChunks={}, enabled={})", (Object)INSTANCE.predictRadiusChunks(), (Object)INSTANCE.villagePredictionEnabled());
    }

    public static synchronized void save() {
        Path cfgRoot = Platform.getConfigFolder();
        Path baseDir = cfgRoot.resolve(BASE_DIR);
        Path file = baseDir.resolve(FILE_NAME);
        try {
            Files.createDirectories(baseDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to create config directory: {}", (Object)baseDir, (Object)e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to write config file: {}", (Object)file, (Object)e);
        }
    }

    public static synchronized ModConfig get() {
        return INSTANCE;
    }
}

