/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.config.RoadFeatureConfig;
import net.shiroha233.roadweaver.features.decoration.Decoration;
import net.shiroha233.roadweaver.features.decoration.RoadStructures;
import net.shiroha233.roadweaver.features.decoration.system.DecorationPlanner;
import net.shiroha233.roadweaver.features.roadlogic.BridgeRangeCalculator;
import net.shiroha233.roadweaver.features.roadlogic.BridgeSegmentPlanner;
import net.shiroha233.roadweaver.features.roadlogic.BridgeTransitionAdjuster;
import net.shiroha233.roadweaver.features.roadlogic.HeightProfileService;
import net.shiroha233.roadweaver.features.roadlogic.SegmentPaver;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.sharded.RoadShardStorage;

public class RoadFeature
extends Feature<RoadFeatureConfig> {
    public RoadFeature(Codec<RoadFeatureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<RoadFeatureConfig> ctx) {
        WorldGenLevel world = ctx.m_159774_();
        ServerLevel lvl = world.m_6018_();
        if (!(lvl instanceof ServerLevel)) {
            return false;
        }
        ServerLevel server = lvl;
        ChunkPos currentChunk = new ChunkPos(ctx.m_159777_());
        int minX = currentChunk.m_45604_();
        int minZ = currentChunk.m_45605_();
        int maxX = currentChunk.m_45608_();
        int maxZ = currentChunk.m_45609_();
        List<Records.RoadData> roadDataList = RoadShardStorage.queryRect(server, minX, minZ, maxX, maxZ);
        if (roadDataList == null || roadDataList.isEmpty()) {
            return false;
        }
        HashSet<BlockPos> processedMiddle = new HashSet<BlockPos>();
        RandomSource random = ctx.m_225041_();
        ModConfig cfg = ConfigService.get();
        int averagingRadius = Math.max(0, cfg.averagingRadius());
        HashSet<Decoration> decorations = new HashSet<Decoration>();
        for (Records.RoadData data : roadDataList) {
            int roadType = data.roadType();
            int roadWidth = Math.max(1, data.width());
            List<BlockState> materials = data.materials();
            List<Records.RoadSegmentPlacement> segments = data.roadSegmentList();
            if (segments == null || segments.size() < 5) continue;
            List<BlockPos> middlePositions = segments.stream().map(Records.RoadSegmentPlacement::middlePos).toList();
            boolean[] isBridge = new boolean[middlePositions.size()];
            List<Object> bridgeRanges = new ArrayList();
            BridgeRangeCalculator.RangeResult res = BridgeRangeCalculator.compute(middlePositions, data.spans());
            isBridge = res.isBridge();
            bridgeRanges = res.mergedRanges();
            List<Integer> targetY = data.targetY();
            HeightProfileService.HeightProfile hp = HeightProfileService.build(world, middlePositions, currentChunk, averagingRadius, cfg, targetY);
            boolean usePersisted = hp.usePersisted();
            int[] smoothedYArr = hp.smoothedY();
            int[] baseYArr = usePersisted && targetY != null && targetY.size() == middlePositions.size() ? targetY.stream().mapToInt(Integer::intValue).toArray() : smoothedYArr;
            if (baseYArr != null && cfg.bridgeEnabled() && !bridgeRanges.isEmpty()) {
                baseYArr = BridgeTransitionAdjuster.adjust(baseYArr, bridgeRanges, cfg);
            }
            int deckY = server.m_5736_() + cfg.bridgeDeckClearance();
            int segmentIndex = 0;
            BridgeSegmentPlanner.Context bridgeCtx = BridgeSegmentPlanner.newContext();
            for (int i = 2; i < segments.size() - 2; ++i) {
                ChunkPos middleChunk;
                BlockPos middle = middlePositions.get(i);
                if (!processedMiddle.add(middle) || ++segmentIndex < 60 || segmentIndex > segments.size() - 60 || !(middleChunk = new ChunkPos(middle)).equals((Object)currentChunk)) continue;
                BlockPos prev = middlePositions.get(i - 2);
                BlockPos next = middlePositions.get(i + 2);
                int topYCenter = world.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, middle.m_123341_(), middle.m_123343_());
                BlockPos averaged = new BlockPos(middle.m_123341_(), topYCenter, middle.m_123343_());
                int baseYForThis = baseYArr != null ? baseYArr[i] : topYCenter;
                Records.RoadSegmentPlacement seg = segments.get(i);
                if (cfg.bridgeEnabled() && isBridge[i]) {
                    BridgeSegmentPlanner.processSegment(world, seg, middle, prev, next, roadWidth, baseYForThis, deckY, segmentIndex, random, cfg, bridgeRanges, i, bridgeCtx);
                } else {
                    SegmentPaver.paveSegment(world, seg, baseYForThis, roadType, materials, random, cfg);
                }
                if (isBridge[i] && !cfg.bridgeKeepLamps()) continue;
                DecorationPlanner.addDecoration(world, decorations, averaged, segmentIndex, next, prev, middlePositions, roadWidth, random, cfg, roadType == 0 ? DecorationPlanner.Mode.ARTIFICIAL : DecorationPlanner.Mode.NATURAL);
            }
        }
        RoadStructures.tryPlaceDecorations(decorations);
        return true;
    }
}

