/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.decoration.system;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.decoration.system.TreeRemovalUtil;

public final class AboveColumnClearer {
    private AboveColumnClearer() {
    }

    public static void clearAboveColumn(WorldGenLevel world, BlockPos surfacePos, ModConfig cfg) {
        boolean tunnel = cfg != null && cfg.tunnelEnabled();
        int defaultClear = cfg != null ? cfg.roadClearHeight() : 3;
        int maxH = tunnel ? Math.max(2, Math.min(16, cfg.tunnelClearHeight())) : Math.max(1, Math.min(16, defaultClear));
        boolean allowCutLogsInThisColumn = false;
        for (int i = 0; i < maxH; ++i) {
            boolean isTreeCoreCandidate;
            BlockPos up = surfacePos.m_6630_(i);
            BlockState st = world.m_8055_(up);
            if (st.m_60795_()) continue;
            boolean isLog = st.m_204336_(BlockTags.f_13106_);
            boolean isFence = st.m_204336_(BlockTags.f_13039_);
            boolean bl = isTreeCoreCandidate = isLog || st.m_60713_(Blocks.f_50571_) || TreeRemovalUtil.isVineLike(st) || st.m_60713_(Blocks.f_50262_) || TreeRemovalUtil.isMushroomLike(st);
            if (cfg != null && cfg.removeWholeTreeOnPath() && isTreeCoreCandidate) {
                if (TreeRemovalUtil.fellTreeAt(world, up, cfg)) continue;
                if (isLog || TreeRemovalUtil.isMushroomLike(st)) {
                    allowCutLogsInThisColumn = true;
                }
            }
            if (tunnel) {
                if (isLog && !allowCutLogsInThisColumn || isFence) break;
                world.m_7731_(up, Blocks.f_50016_.m_49966_(), 3);
                continue;
            }
            if (isLog && !allowCutLogsInThisColumn || isFence) break;
            world.m_7731_(up, Blocks.f_50016_.m_49966_(), 3);
        }
    }
}

