/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.shiroha233.roadweaver.features.roadlogic.RoadDirection;
import net.shiroha233.roadweaver.features.roadlogic.RoadPathCalculator;
import net.shiroha233.roadweaver.features.roadlogic.TerrainSamplingCache;
import net.shiroha233.roadweaver.helpers.Records;

final class BidirectionalAStarPathfinder {
    private static final double ORTHO_STEP_COST = 1.0;
    private static final double DIAG_STEP_COST = 1.0;
    private static final int ELEVATION_WEIGHT = 80;
    private static final int BIOME_BASE_COST = 40;
    private static final int BIOME_WEIGHT = 2;
    private static final int STABILITY_WEIGHT = 15;
    private static final int WATER_DEPTH_WEIGHT = 40;
    private static final int NEAR_WATER_COST = 40;
    private static final double HEURISTIC_WEIGHT = 15.0;
    private static final double HEURISTIC_EPSILON = 0.2;
    private static final double DEVIATION_WEIGHT = 0.5;

    private BidirectionalAStarPathfinder() {
    }

    static List<Records.RoadSegmentPlacement> calculateLandPath(BlockPos startGround, BlockPos endGround, int width, ServerLevel level, int maxSteps, TerrainSamplingCache cache) {
        if (startGround.equals((Object)endGround)) {
            return Collections.emptyList();
        }
        int d = RoadPathCalculator.getNeighborDistance();
        int[][] neighborOffsets = new int[][]{{d, 0}, {-d, 0}, {0, d}, {0, -d}, {d, d}, {d, -d}, {-d, d}, {-d, -d}};
        PriorityQueue<Node> openF = new PriorityQueue<Node>(Comparator.comparingDouble(n -> n.f));
        PriorityQueue<Node> openB = new PriorityQueue<Node>(Comparator.comparingDouble(n -> n.f));
        HashMap<BlockPos, Node> nodesF = new HashMap<BlockPos, Node>();
        HashMap<BlockPos, Node> nodesB = new HashMap<BlockPos, Node>();
        HashSet<BlockPos> closedF = new HashSet<BlockPos>();
        HashSet<BlockPos> closedB = new HashSet<BlockPos>();
        Node startNode = new Node(startGround, null, 0.0, BidirectionalAStarPathfinder.heuristic(startGround, endGround));
        Node endNode = new Node(endGround, null, 0.0, BidirectionalAStarPathfinder.heuristic(endGround, startGround));
        openF.add(startNode);
        nodesF.put(startGround, startNode);
        openB.add(endNode);
        nodesB.put(endGround, endNode);
        int stepsBudget = Math.max(1, maxSteps);
        while (!openF.isEmpty() && !openB.isEmpty() && stepsBudget-- > 0) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            Node peekF = openF.peek();
            Node peekB = openB.peek();
            boolean expandForward = peekF == null ? false : (peekB == null ? true : peekF.f <= peekB.f);
            Meet meet = expandForward ? BidirectionalAStarPathfinder.expandOneSide(openF, nodesF, closedF, nodesB, startGround, endGround, level, cache, neighborOffsets, d) : BidirectionalAStarPathfinder.expandOneSide(openB, nodesB, closedB, nodesF, endGround, startGround, level, cache, neighborOffsets, d);
            if (meet == null) continue;
            return BidirectionalAStarPathfinder.reconstructPath(meet.forward, meet.backward, width);
        }
        return null;
    }

    private static Meet expandOneSide(PriorityQueue<Node> open, Map<BlockPos, Node> nodesThis, Set<BlockPos> closedThis, Map<BlockPos, Node> nodesOther, BlockPos from, BlockPos to, ServerLevel level, TerrainSamplingCache cache, int[][] neighborOffsets, int d) {
        if (open.isEmpty()) {
            return null;
        }
        Node current = open.poll();
        if (current == null) {
            return null;
        }
        closedThis.add(current.pos);
        nodesThis.remove(current.pos);
        for (int[] off : neighborOffsets) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            BlockPos nxz = current.pos.m_7918_(off[0], 0, off[1]);
            int y = RoadPathCalculator.heightSampler(cache, nxz.m_123341_(), nxz.m_123343_(), level);
            BlockPos np = new BlockPos(nxz.m_123341_(), y, nxz.m_123343_());
            if (closedThis.contains(np)) continue;
            Holder biome = level.m_204166_(np);
            int biomeCost = biome.m_203656_(BiomeTags.f_207605_) || biome.m_203656_(BiomeTags.f_207603_) || biome.m_203656_(BiomeTags.f_207602_) ? 40 : 0;
            int elevation = Math.abs(y - current.pos.m_123342_());
            int offsetSum = Math.abs(Math.abs(off[0])) + Math.abs(off[1]);
            double stepCost = offsetSum == 2 * d ? 1.0 : 1.0;
            int stabilityCost = RoadPathCalculator.calculateTerrainStability(cache, np, y, level);
            int sea = level.m_5736_();
            boolean waterColumn = RoadPathCalculator.isColumnWater(cache, nxz.m_123341_(), nxz.m_123343_(), level);
            boolean nearWater = RoadPathCalculator.isNearWaterLike(cache, nxz.m_123341_(), nxz.m_123343_(), level);
            int oceanFloor = RoadPathCalculator.oceanFloorSampler(cache, nxz.m_123341_(), nxz.m_123343_(), level);
            int waterDepth = Math.max(0, sea - oceanFloor);
            int waterDepthCost = waterColumn ? waterDepth * 40 : 0;
            int nearWaterCost = nearWater ? 40 : 0;
            double deviation = BidirectionalAStarPathfinder.deviation2d(np, from, to);
            double deviationCost = deviation * 0.5 / Math.max(1.0, (double)d);
            double tentativeG = current.g + stepCost + (double)(elevation * 80) + (double)(biomeCost * 2) + (double)(stabilityCost * 15) + (double)waterDepthCost + (double)nearWaterCost + deviationCost;
            Node existing = nodesThis.get(np);
            if (existing != null && tentativeG >= existing.g) continue;
            double h = BidirectionalAStarPathfinder.heuristic(np, to);
            double fWeighted = tentativeG + 1.2 * h;
            Node next = new Node(np, current, tentativeG, fWeighted);
            nodesThis.put(np, next);
            open.add(next);
            Node other = nodesOther.get(np);
            if (other == null) continue;
            if (BidirectionalAStarPathfinder.isFromForward(from, to, next, other)) {
                return new Meet(next, other);
            }
            return new Meet(other, next);
        }
        return null;
    }

    private static boolean isFromForward(BlockPos from, BlockPos to, Node a, Node b) {
        int eb;
        int db;
        int da = BidirectionalAStarPathfinder.manhattan2d(a.pos, from);
        if (da != (db = BidirectionalAStarPathfinder.manhattan2d(b.pos, from))) {
            return da <= db;
        }
        int ea = BidirectionalAStarPathfinder.manhattan2d(a.pos, to);
        return ea <= (eb = BidirectionalAStarPathfinder.manhattan2d(b.pos, to));
    }

    private static List<Records.RoadSegmentPlacement> reconstructPath(Node meetForward, Node meetBackward, int width) {
        ArrayList<Node> forwardNodes = new ArrayList<Node>();
        Node cur = meetForward;
        while (cur != null) {
            forwardNodes.add(cur);
            cur = cur.parent;
        }
        Collections.reverse(forwardNodes);
        ArrayList<Node> backwardNodes = new ArrayList<Node>();
        Node node = cur = meetBackward != null && meetBackward.pos.equals((Object)meetForward.pos) ? meetBackward.parent : meetBackward;
        while (cur != null) {
            backwardNodes.add(cur);
            cur = cur.parent;
        }
        Collections.reverse(backwardNodes);
        ArrayList<Node> allNodes = new ArrayList<Node>(forwardNodes.size() + backwardNodes.size());
        allNodes.addAll(forwardNodes);
        allNodes.addAll(backwardNodes);
        LinkedHashMap<BlockPos, Set<BlockPos>> segments = new LinkedHashMap<BlockPos, Set<BlockPos>>();
        HashSet<BlockPos> widthCache = new HashSet<BlockPos>();
        for (int i = 0; i < allNodes.size(); ++i) {
            Node curNode = (Node)allNodes.get(i);
            BlockPos p = curNode.pos;
            RoadDirection dir = RoadDirection.X_AXIS;
            if (i > 0) {
                Node prevNode = (Node)allNodes.get(i - 1);
                BlockPos prev = prevNode.pos;
                int dx = p.m_123341_() - prev.m_123341_();
                int dz = p.m_123343_() - prev.m_123343_();
                int stepCount = Math.max(Math.abs(dx), Math.abs(dz));
                if (dx < 0 && dz > 0 || dx > 0 && dz < 0) {
                    dir = RoadDirection.DIAGONAL_1;
                } else if (dx < 0 && dz < 0 || dx > 0 && dz > 0) {
                    dir = RoadDirection.DIAGONAL_2;
                } else if (dx == 0 && dz != 0) {
                    dir = RoadDirection.Z_AXIS;
                }
                if (stepCount > 1) {
                    for (int s = 1; s < stepCount; ++s) {
                        int ix = prev.m_123341_() + dx * s / stepCount;
                        int iz = prev.m_123343_() + dz * s / stepCount;
                        BlockPos ip = new BlockPos(ix, prev.m_123342_(), iz);
                        Set<BlockPos> ws = RoadPathCalculator.generateWidth(ip, width / 2, widthCache, dir);
                        segments.put(ip, ws);
                    }
                }
            }
            Set<BlockPos> ws = RoadPathCalculator.generateWidth(p, width / 2, widthCache, dir);
            segments.put(p, ws);
        }
        ArrayList<Records.RoadSegmentPlacement> out = new ArrayList<Records.RoadSegmentPlacement>();
        for (Map.Entry e : segments.entrySet()) {
            out.add(new Records.RoadSegmentPlacement((BlockPos)e.getKey(), new ArrayList<BlockPos>((Collection)e.getValue())));
        }
        return out;
    }

    private static int manhattan2d(BlockPos a, BlockPos b) {
        return Math.abs(a.m_123341_() - b.m_123341_()) + Math.abs(a.m_123343_() - b.m_123343_());
    }

    private static double heuristic(BlockPos a, BlockPos b) {
        int dx = a.m_123341_() - b.m_123341_();
        int dz = a.m_123343_() - b.m_123343_();
        double dxzApprox = (double)(Math.abs(dx) + Math.abs(dz)) - 0.6 * (double)Math.min(Math.abs(dx), Math.abs(dz));
        return dxzApprox * 15.0;
    }

    private static double deviation2d(BlockPos p, BlockPos a, BlockPos b) {
        double ax = a.m_123341_();
        double az = a.m_123343_();
        double bx = b.m_123341_();
        double bz = b.m_123343_();
        double px = p.m_123341_();
        double pz = p.m_123343_();
        double num = Math.abs((bz - az) * px - (bx - ax) * pz + bx * az - bz * ax);
        double den = Math.hypot(bx - ax, bz - az);
        if (den <= 0.0) {
            return 0.0;
        }
        return num / den;
    }

    private static final class Node {
        final BlockPos pos;
        final Node parent;
        final double g;
        final double f;

        Node(BlockPos pos, Node parent, double g, double f) {
            this.pos = pos;
            this.parent = parent;
            this.g = g;
            this.f = f;
        }
    }

    private static final class Meet {
        final Node forward;
        final Node backward;

        Meet(Node forward, Node backward) {
            this.forward = forward;
            this.backward = backward;
        }
    }
}

