/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.helpers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public final class Records {
    private Records() {
    }

    public record RoadData(int width, int roadType, List<BlockState> materials, List<RoadSegmentPlacement> roadSegmentList, List<RoadSpan> spans, List<Integer> targetY) {
        public static final Codec<RoadData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("width").forGetter(RoadData::width), (App)Codec.INT.fieldOf("road_type").forGetter(RoadData::roadType), (App)BlockState.f_61039_.listOf().fieldOf("materials").forGetter(RoadData::materials), (App)RoadSegmentPlacement.CODEC.listOf().fieldOf("placements").forGetter(RoadData::roadSegmentList), (App)RoadSpan.CODEC.listOf().optionalFieldOf("spans", new ArrayList()).forGetter(RoadData::spans), (App)Codec.INT.listOf().optionalFieldOf("target_y", new ArrayList()).forGetter(RoadData::targetY)).apply((Applicative)instance, RoadData::new));
    }

    public record RoadSpan(BlockPos start, BlockPos end, SpanType type) {
        public static final Codec<RoadSpan> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.fieldOf("start").forGetter(RoadSpan::start), (App)BlockPos.f_121852_.fieldOf("end").forGetter(RoadSpan::end), (App)Codec.STRING.fieldOf("type").xmap(SpanType::valueOf, Enum::name).forGetter(RoadSpan::type)).apply((Applicative)instance, RoadSpan::new));
    }

    public static enum SpanType {
        BRIDGE,
        TUNNEL;

    }

    public record RoadSegmentPlacement(BlockPos middlePos, List<BlockPos> positions) {
        public static final Codec<RoadSegmentPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.fieldOf("middle_pos").forGetter(RoadSegmentPlacement::middlePos), (App)BlockPos.f_121852_.listOf().fieldOf("positions").forGetter(RoadSegmentPlacement::positions)).apply((Applicative)instance, RoadSegmentPlacement::new));
    }

    public record StructureConnection(BlockPos from, BlockPos to, ConnectionStatus status) {
        public static final Codec<StructureConnection> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.fieldOf("from").forGetter(StructureConnection::from), (App)BlockPos.f_121852_.fieldOf("to").forGetter(StructureConnection::to), (App)Codec.STRING.optionalFieldOf("status", (Object)"PLANNED").xmap(ConnectionStatus::valueOf, Enum::name).forGetter(StructureConnection::status)).apply((Applicative)instance, StructureConnection::new));

        public StructureConnection(BlockPos from, BlockPos to) {
            this(from, to, ConnectionStatus.PLANNED);
        }
    }

    public static enum ConnectionStatus {
        PLANNED,
        GENERATING,
        COMPLETED,
        FAILED;

    }

    public record StructureLocationData(List<BlockPos> structureLocations, List<StructureInfo> structureInfos) {
        public static final Codec<StructureLocationData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.listOf().optionalFieldOf("structure_locations", new ArrayList()).forGetter(StructureLocationData::structureLocations), (App)StructureInfo.CODEC.listOf().optionalFieldOf("structure_infos", new ArrayList()).forGetter(StructureLocationData::structureInfos)).apply((Applicative)instance, StructureLocationData::new));

        public StructureLocationData(List<BlockPos> structureLocations, List<StructureInfo> structureInfos) {
            this.structureLocations = new ArrayList<BlockPos>(structureLocations != null ? structureLocations : new ArrayList());
            this.structureInfos = new ArrayList<StructureInfo>(structureInfos != null ? structureInfos : new ArrayList());
        }

        public StructureLocationData(List<BlockPos> structureLocations) {
            this(structureLocations, new ArrayList<StructureInfo>());
        }

        public void addStructure(BlockPos pos) {
            this.structureLocations.add(pos);
        }

        public void addStructureInfo(StructureInfo info) {
            this.structureInfos.add(info);
            if (!this.structureLocations.contains(info.pos())) {
                this.structureLocations.add(info.pos());
            }
        }
    }

    public record StructureInfo(BlockPos pos, String structureId) {
        public static final Codec<StructureInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.fieldOf("pos").forGetter(StructureInfo::pos), (App)Codec.STRING.optionalFieldOf("structure_id", (Object)"unknown").forGetter(StructureInfo::structureId)).apply((Applicative)instance, StructureInfo::new));
    }

    public record WoodAssets(Block fence, Block hangingSign, Block planks) {
    }
}

