/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.runtime;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.server.MinecraftServer;
import net.shiroha233.roadweaver.config.ConfigService;

public final class ThreadPoolManager {
    private static volatile ExecutorService COMPUTE_EXEC;
    private static volatile ExecutorService GENERATION_EXEC;
    private static final AtomicLong EPOCH;

    private ThreadPoolManager() {
    }

    private static ThreadFactory namedFactory(String prefix) {
        return r -> {
            Thread t = new Thread(r, prefix + "-" + System.nanoTime());
            t.setDaemon(true);
            return t;
        };
    }

    public static synchronized void onServerStarted(MinecraftServer server) {
        int computeThreads;
        EPOCH.incrementAndGet();
        try {
            int cores = Runtime.getRuntime().availableProcessors();
            computeThreads = Math.max(1, cores - 1);
        }
        catch (Throwable t) {
            computeThreads = 1;
        }
        if (COMPUTE_EXEC != null && !COMPUTE_EXEC.isShutdown() && !COMPUTE_EXEC.isTerminated()) {
            try {
                COMPUTE_EXEC.shutdownNow();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        COMPUTE_EXEC = Executors.newFixedThreadPool(computeThreads, ThreadPoolManager.namedFactory("RW-Compute"));
        int genThreads = Math.max(1, ConfigService.get().generationThreads());
        if (GENERATION_EXEC != null && !GENERATION_EXEC.isShutdown() && !GENERATION_EXEC.isTerminated()) {
            try {
                GENERATION_EXEC.shutdownNow();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        GENERATION_EXEC = Executors.newFixedThreadPool(genThreads, ThreadPoolManager.namedFactory("RW-Gen"));
    }

    public static synchronized void onServerStopping() {
        EPOCH.incrementAndGet();
        if (COMPUTE_EXEC != null) {
            try {
                COMPUTE_EXEC.shutdownNow();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            COMPUTE_EXEC = null;
        }
        if (GENERATION_EXEC != null) {
            try {
                GENERATION_EXEC.shutdownNow();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            GENERATION_EXEC = null;
        }
    }

    public static synchronized void resizeGenerationPool(int threads) {
        int genThreads = Math.max(1, threads);
        if (GENERATION_EXEC != null && !GENERATION_EXEC.isShutdown() && !GENERATION_EXEC.isTerminated()) {
            try {
                GENERATION_EXEC.shutdownNow();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        GENERATION_EXEC = Executors.newFixedThreadPool(genThreads, ThreadPoolManager.namedFactory("RW-Gen"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutorService computeExecutor() {
        ExecutorService e = COMPUTE_EXEC;
        if (e != null && !e.isShutdown()) {
            if (!e.isTerminated()) return e;
        }
        Class<ThreadPoolManager> clazz = ThreadPoolManager.class;
        synchronized (ThreadPoolManager.class) {
            int computeThreads;
            if (COMPUTE_EXEC != null && !COMPUTE_EXEC.isShutdown()) {
                if (!COMPUTE_EXEC.isTerminated()) return COMPUTE_EXEC;
            }
            try {
                int cores = Runtime.getRuntime().availableProcessors();
                computeThreads = Math.max(1, cores - 1);
            }
            catch (Throwable t) {
                computeThreads = 1;
            }
            COMPUTE_EXEC = Executors.newFixedThreadPool(computeThreads, ThreadPoolManager.namedFactory("RW-Compute"));
            return COMPUTE_EXEC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutorService generationExecutor() {
        ExecutorService e = GENERATION_EXEC;
        if (e != null && !e.isShutdown()) {
            if (!e.isTerminated()) return e;
        }
        Class<ThreadPoolManager> clazz = ThreadPoolManager.class;
        synchronized (ThreadPoolManager.class) {
            if (GENERATION_EXEC != null && !GENERATION_EXEC.isShutdown()) {
                if (!GENERATION_EXEC.isTerminated()) return GENERATION_EXEC;
            }
            int genThreads = Math.max(1, ConfigService.get().generationThreads());
            GENERATION_EXEC = Executors.newFixedThreadPool(genThreads, ThreadPoolManager.namedFactory("RW-Gen"));
            return GENERATION_EXEC;
        }
    }

    public static long currentEpoch() {
        return EPOCH.get();
    }

    public static boolean isEpoch(long epoch) {
        return EPOCH.get() == epoch;
    }

    static {
        EPOCH = new AtomicLong(0L);
    }
}

