/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.api;

import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public final class SpawnRule {
    private final Set<ResourceLocation> dimensionAllow;
    private final Set<ResourceLocation> biomeAllowTags;
    private final Set<ResourceLocation> biomeDenyTags;
    private final int spacing;
    private final int separation;
    private final int minY;
    private final int maxY;
    private final int maxSlope;
    private final int avoidRadius;

    public SpawnRule(Set<ResourceLocation> dimensionAllow, Set<ResourceLocation> biomeAllowTags, Set<ResourceLocation> biomeDenyTags, int spacing, int separation, int minY, int maxY, int maxSlope, int avoidRadius) {
        this.dimensionAllow = dimensionAllow;
        this.biomeAllowTags = biomeAllowTags;
        this.biomeDenyTags = biomeDenyTags;
        this.spacing = Math.max(1, spacing);
        this.separation = Math.max(0, separation);
        this.minY = minY;
        this.maxY = maxY;
        this.maxSlope = Math.max(0, maxSlope);
        this.avoidRadius = Math.max(0, avoidRadius);
    }

    public Set<ResourceLocation> dimensionAllow() {
        return this.dimensionAllow;
    }

    public Set<ResourceLocation> biomeAllowTags() {
        return this.biomeAllowTags;
    }

    public Set<ResourceLocation> biomeDenyTags() {
        return this.biomeDenyTags;
    }

    public int spacing() {
        return this.spacing;
    }

    public int separation() {
        return this.separation;
    }

    public int minY() {
        return this.minY;
    }

    public int maxY() {
        return this.maxY;
    }

    public int maxSlope() {
        return this.maxSlope;
    }

    public int avoidRadius() {
        return this.avoidRadius;
    }
}

