/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.forge;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.config.PresetService;

public class ConfigScreenFactoryImpl {
    public static Screen createConfigScreen(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Component.m_237115_((String)"config.roadweaver.title"));
        PresetService.reload();
        ModConfig conf = ConfigService.get();
        builder.setSavingRunnable(ConfigService::save);
        ConfigCategory filters = builder.getOrCreateCategory((Component)Component.m_237115_((String)"config.roadweaver.category.structure_filters"));
        ConfigEntryBuilder eb = builder.entryBuilder();
        filters.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.m_237115_((String)"config.roadweaver.enable_prediction"), conf.villagePredictionEnabled()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.enable_prediction.tooltip")}).setSaveConsumer(conf::setVillagePredictionEnabled).build());
        filters.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237115_((String)"config.roadweaver.radius_chunks"), conf.predictRadiusChunks()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.radius_chunks.tooltip")}).setMin(1).setMax(4096).setSaveConsumer(conf::setPredictRadiusChunks).build());
        filters.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.m_237115_((String)"config.roadweaver.biome_prefilter"), conf.biomePrefilter()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.biome_prefilter.tooltip")}).setSaveConsumer(conf::setBiomePrefilter).build());
        ArrayList whitelist = new ArrayList(conf.structureWhitelist() == null ? List.of() : conf.structureWhitelist());
        ArrayList blacklist = new ArrayList(conf.structureBlacklist() == null ? List.of() : conf.structureBlacklist());
        filters.addEntry((AbstractConfigListEntry)eb.startStrList((Component)Component.m_237115_((String)"config.roadweaver.whitelist"), whitelist).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.whitelist.tooltip")}).setSaveConsumer(list -> conf.setStructureWhitelist(ConfigScreenFactoryImpl.normalize(list))).build());
        filters.addEntry((AbstractConfigListEntry)eb.startStrList((Component)Component.m_237115_((String)"config.roadweaver.blacklist"), blacklist).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.blacklist.tooltip")}).setSaveConsumer(list -> conf.setStructureBlacklist(ConfigScreenFactoryImpl.normalize(list))).build());
        ConfigCategory planning = builder.getOrCreateCategory((Component)Component.m_237115_((String)"config.roadweaver.category.road_planning"));
        planning.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237115_((String)"config.roadweaver.initial_plan_radius_chunks"), conf.initialPlanRadiusChunks()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.initial_plan_radius_chunks.tooltip")}).setMin(1).setMax(4096).setSaveConsumer(conf::setInitialPlanRadiusChunks).build());
        planning.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.m_237115_((String)"config.roadweaver.dynamic_plan_enabled"), conf.dynamicPlanEnabled()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.dynamic_plan_enabled.tooltip")}).setSaveConsumer(conf::setDynamicPlanEnabled).build());
        planning.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237115_((String)"config.roadweaver.dynamic_plan_radius_chunks"), conf.dynamicPlanRadiusChunks()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.dynamic_plan_radius_chunks.tooltip")}).setMin(1).setMax(4096).setSaveConsumer(conf::setDynamicPlanRadiusChunks).build());
        planning.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237115_((String)"config.roadweaver.dynamic_plan_stride_chunks"), conf.dynamicPlanStrideChunks()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.dynamic_plan_stride_chunks.tooltip")}).setMin(1).setMax(256).setSaveConsumer(conf::setDynamicPlanStrideChunks).build());
        planning.addEntry((AbstractConfigListEntry)eb.startEnumSelector((Component)Component.m_237115_((String)"config.roadweaver.planning_algorithm"), ModConfig.PlanningAlgorithm.class, (Enum)conf.planningAlgorithm()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.planning_algorithm.tooltip")}).setEnumNameProvider(v -> Component.m_237115_((String)("config.roadweaver.planning_algorithm.option." + v.name().toLowerCase(Locale.ROOT)))).setSaveConsumer(conf::setPlanningAlgorithm).build());
        ConfigCategory genSurface = builder.getOrCreateCategory((Component)Component.m_237115_((String)"config.roadweaver.category.gen_surface"));
        genSurface.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.m_237115_((String)"config.roadweaver.allow_artificial"), conf.allowArtificial()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.allow_artificial.tooltip")}).setSaveConsumer(conf::setAllowArtificial).build());
        genSurface.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.m_237115_((String)"config.roadweaver.allow_natural"), conf.allowNatural()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.allow_natural.tooltip")}).setSaveConsumer(conf::setAllowNatural).build());
        genSurface.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237115_((String)"config.roadweaver.averaging_radius"), conf.averagingRadius()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.averaging_radius.tooltip")}).setMin(0).setMax(64).setSaveConsumer(conf::setAveragingRadius).build());
        genSurface.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237115_((String)"config.roadweaver.max_slope_step_per_two_segments"), conf.maxSlopeStepPerTwoSegments()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.max_slope_step_per_two_segments.tooltip")}).setMin(0).setMax(8).setSaveConsumer(conf::setMaxSlopeStepPerTwoSegments).build());
        genSurface.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237115_((String)"config.roadweaver.road_width"), conf.roadWidth()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.road_width.tooltip")}).setMin(0).setMax(15).setSaveConsumer(conf::setRoadWidth).build());
        genSurface.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237115_((String)"config.roadweaver.lamp_interval"), conf.lampInterval()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.lamp_interval.tooltip")}).setMin(1).setMax(2048).setSaveConsumer(conf::setLampInterval).build());
        genSurface.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237115_((String)"config.roadweaver.causeway_max_depth"), conf.causewayMaxDepth()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.causeway_max_depth.tooltip")}).setMin(0).setMax(12).setSaveConsumer(conf::setCausewayMaxDepth).build());
        ArrayList selected = new ArrayList(conf.selectedArtificialPresetIds() == null ? List.of() : conf.selectedArtificialPresetIds());
        genSurface.addEntry((AbstractConfigListEntry)eb.startStrList((Component)Component.m_237115_((String)"config.roadweaver.selected_artificial_preset_ids"), selected).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.selected_artificial_preset_ids.tooltip")}).setSaveConsumer(conf::setSelectedArtificialPresetIds).build());
        genSurface.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.m_237115_((String)"config.roadweaver.use_weighted_preset"), conf.useWeightedPreset()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.use_weighted_preset.tooltip")}).setSaveConsumer(conf::setUseWeightedPreset).build());
        genSurface.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.m_237115_((String)"config.roadweaver.remove_whole_tree_on_path"), conf.removeWholeTreeOnPath()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.remove_whole_tree_on_path.tooltip")}).setSaveConsumer(conf::setRemoveWholeTreeOnPath).build());
        genSurface.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237115_((String)"config.roadweaver.tree_removal_max_radius"), conf.treeRemovalMaxRadius()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.tree_removal_max_radius.tooltip")}).setMin(2).setMax(12).setSaveConsumer(conf::setTreeRemovalMaxRadius).build());
        genSurface.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237115_((String)"config.roadweaver.tree_removal_max_height"), conf.treeRemovalMaxHeight()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.tree_removal_max_height.tooltip")}).setMin(8).setMax(64).setSaveConsumer(conf::setTreeRemovalMaxHeight).build());
        genSurface.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237115_((String)"config.roadweaver.tree_removal_max_blocks"), conf.treeRemovalMaxBlocks()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.tree_removal_max_blocks.tooltip")}).setMin(64).setMax(8192).setSaveConsumer(conf::setTreeRemovalMaxBlocks).build());
        genSurface.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237115_((String)"config.roadweaver.tree_leaves_confirm"), conf.treeLeavesConfirm()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.tree_leaves_confirm.tooltip")}).setMin(0).setMax(128).setSaveConsumer(conf::setTreeLeavesConfirm).build());
        ConfigCategory bridge = builder.getOrCreateCategory((Component)Component.m_237115_((String)"config.roadweaver.category.bridge"));
        bridge.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.m_237115_((String)"config.roadweaver.bridge_enabled"), conf.bridgeEnabled()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.bridge_enabled.tooltip")}).setSaveConsumer(conf::setBridgeEnabled).build());
        bridge.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237115_((String)"config.roadweaver.bridge_deck_clearance"), conf.bridgeDeckClearance()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.bridge_deck_clearance.tooltip")}).setMin(1).setMax(8).setSaveConsumer(conf::setBridgeDeckClearance).build());
        bridge.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.m_237115_((String)"config.roadweaver.bridge_railing_enabled"), conf.bridgeRailingEnabled()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.bridge_railing_enabled.tooltip")}).setSaveConsumer(conf::setBridgeRailingEnabled).build());
        bridge.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237115_((String)"config.roadweaver.bridge_pier_interval"), conf.bridgePierInterval()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.bridge_pier_interval.tooltip")}).setMin(3).setMax(32).setSaveConsumer(conf::setBridgePierInterval).build());
        bridge.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237115_((String)"config.roadweaver.bridge_pier_width"), conf.bridgePierWidth()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.bridge_pier_width.tooltip")}).setMin(1).setMax(3).setSaveConsumer(conf::setBridgePierWidth).build());
        bridge.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237115_((String)"config.roadweaver.bridge_pier_max_height"), conf.bridgePierMaxHeight()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.bridge_pier_max_height.tooltip")}).setMin(6).setMax(64).setSaveConsumer(conf::setBridgePierMaxHeight).build());
        bridge.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.m_237115_((String)"config.roadweaver.bridge_keep_lamps"), conf.bridgeKeepLamps()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.bridge_keep_lamps.tooltip")}).setSaveConsumer(conf::setBridgeKeepLamps).build());
        bridge.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237115_((String)"config.roadweaver.bridge_ramp_segments"), conf.bridgeRampSegments()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.bridge_ramp_segments.tooltip")}).setMin(0).setMax(12).setSaveConsumer(conf::setBridgeRampSegments).build());
        ConfigCategory genPerformance = builder.getOrCreateCategory((Component)Component.m_237115_((String)"config.roadweaver.category.gen_performance"));
        genPerformance.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237115_((String)"config.roadweaver.generation_threads"), conf.generationThreads()).setMin(1).setMax(64).setSaveConsumer(conf::setGenerationThreads).build());
        genPerformance.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237115_((String)"config.roadweaver.a_star_step"), conf.aStarStep()).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.a_star_step.tooltip")}).setMin(4).setMax(128).setSaveConsumer(conf::setAStarStep).build());
        genPerformance.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.m_237115_((String)"config.roadweaver.max_concurrent_generations"), conf.maxConcurrentGenerations()).setMin(1).setMax(128).setSaveConsumer(conf::setMaxConcurrentGenerations).build());
        return builder.build();
    }

    private static List<String> normalize(List<String> src) {
        if (src == null) {
            return List.of();
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String s : src) {
            String v;
            if (s == null || (v = s.trim().toLowerCase(Locale.ROOT)).isEmpty()) continue;
            set.add(v);
        }
        return new ArrayList<String>(set);
    }
}

