/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map;

import net.minecraft.client.Minecraft;
import net.shiroha233.roadweaver.client.map.MapSnapshot;

final class MapView {
    private double minX;
    private double maxX;
    private double minZ;
    private double maxZ;
    private boolean initialized;

    MapView() {
    }

    boolean isInitialized() {
        return this.initialized;
    }

    void resetFromSnapshot(MapSnapshot snapshot) {
        this.minX = snapshot.minX();
        this.maxX = snapshot.maxX();
        this.minZ = snapshot.minZ();
        this.maxZ = snapshot.maxZ();
        if (this.maxX - this.minX < 1.0) {
            this.maxX = this.minX + 1.0;
        }
        if (this.maxZ - this.minZ < 1.0) {
            this.maxZ = this.minZ + 1.0;
        }
        this.initialized = false;
    }

    void calibrateInitialToPlayer(Minecraft mc, int contentW, int contentH, int gridTargetPx) {
        if (mc == null || mc.f_91074_ == null) {
            return;
        }
        double px = mc.f_91074_.m_20185_();
        double pz = mc.f_91074_.m_20189_();
        double desiredBlocksPerCell = 256.0;
        double desiredPxPerBlock = (double)gridTargetPx / desiredBlocksPerCell;
        if (desiredPxPerBlock <= 0.0) {
            return;
        }
        double rangeX = (double)contentW / desiredPxPerBlock;
        double rangeZ = (double)contentH / desiredPxPerBlock;
        this.minX = px - rangeX * 0.5;
        this.maxX = px + rangeX * 0.5;
        this.minZ = pz - rangeZ * 0.5;
        this.maxZ = pz + rangeZ * 0.5;
        this.lockAspect(contentW, contentH);
        this.clampZoom(contentW, contentH, gridTargetPx);
        this.initialized = true;
    }

    int toScreenX(int blockX, int mapX, int innerPad, int contentW) {
        double rangeX = Math.max(1.0, this.maxX - this.minX);
        double nx = ((double)blockX - this.minX) / rangeX;
        return mapX + innerPad + (int)Math.round(nx * (double)contentW);
    }

    int toScreenY(int blockZ, int mapY, int innerPad, int contentH) {
        double rangeZ = Math.max(1.0, this.maxZ - this.minZ);
        double nz = ((double)blockZ - this.minZ) / rangeZ;
        return mapY + innerPad + (int)Math.round(nz * (double)contentH);
    }

    double screenToWorldX(double sx, int mapX, int innerPad, int contentW) {
        double nx = (sx - (double)(mapX + innerPad)) / Math.max(1.0, (double)contentW);
        return this.minX + nx * Math.max(1.0, this.maxX - this.minX);
    }

    double screenToWorldZ(double sy, int mapY, int innerPad, int contentH) {
        double ny = (sy - (double)(mapY + innerPad)) / Math.max(1.0, (double)contentH);
        return this.minZ + ny * Math.max(1.0, this.maxZ - this.minZ);
    }

    boolean isInViewWorld(int x, int z) {
        return (double)x >= this.minX && (double)x <= this.maxX && (double)z >= this.minZ && (double)z <= this.maxZ;
    }

    boolean segmentInViewWorld(int x1, int z1, int x2, int z2) {
        int minX = Math.min(x1, x2);
        int maxX = Math.max(x1, x2);
        int minZ = Math.min(z1, z2);
        int maxZ = Math.max(z1, z2);
        if ((double)maxX < this.minX) {
            return false;
        }
        if ((double)minX > this.maxX) {
            return false;
        }
        if ((double)maxZ < this.minZ) {
            return false;
        }
        return !((double)minZ > this.maxZ);
    }

    double pxPerBlockX(int contentW) {
        return (double)contentW / Math.max(1.0, this.maxX - this.minX);
    }

    double pxPerBlockZ(int contentH) {
        return (double)contentH / Math.max(1.0, this.maxZ - this.minZ);
    }

    void lockAspect(int contentW, int contentH) {
        double rz;
        if (contentW <= 0 || contentH <= 0) {
            return;
        }
        double aspect = (double)contentW / (double)contentH;
        double rx = Math.max(1.0, this.maxX - this.minX);
        double r = rx / (rz = Math.max(1.0, this.maxZ - this.minZ));
        if (Math.abs(r - aspect) < 1.0E-6) {
            return;
        }
        double cx = (this.minX + this.maxX) * 0.5;
        double cz = (this.minZ + this.maxZ) * 0.5;
        if (r > aspect) {
            double nrz = rx / aspect;
            this.minZ = cz - nrz * 0.5;
            this.maxZ = cz + nrz * 0.5;
        } else {
            double nrx = rz * aspect;
            this.minX = cx - nrx * 0.5;
            this.maxX = cx + nrx * 0.5;
        }
    }

    void clampZoom(int contentW, int contentH, int gridTargetPx) {
        if (contentW <= 0 || contentH <= 0) {
            return;
        }
        double minPpb = (double)gridTargetPx / 8192.0;
        double maxPpb = (double)gridTargetPx / 16.0;
        double rx = Math.max(1.0, this.maxX - this.minX);
        double rz = Math.max(1.0, this.maxZ - this.minZ);
        double ppbX = (double)contentW / rx;
        double ppbZ = (double)contentH / rz;
        double cx = (this.minX + this.maxX) * 0.5;
        double cz = (this.minZ + this.maxZ) * 0.5;
        boolean changed = false;
        if (ppbX > maxPpb) {
            rx = (double)contentW / maxPpb;
            changed = true;
        } else if (ppbX < minPpb) {
            rx = (double)contentW / minPpb;
            changed = true;
        }
        if (ppbZ > maxPpb) {
            rz = (double)contentH / maxPpb;
            changed = true;
        } else if (ppbZ < minPpb) {
            rz = (double)contentH / minPpb;
            changed = true;
        }
        if (changed) {
            this.minX = cx - rx * 0.5;
            this.maxX = cx + rx * 0.5;
            this.minZ = cz - rz * 0.5;
            this.maxZ = cz + rz * 0.5;
            this.lockAspect(contentW, contentH);
        }
    }

    void applyZoomAround(double cx, double cz, double factor, int contentW, int contentH, int gridTargetPx) {
        double rx = this.maxX - this.minX;
        double rz = this.maxZ - this.minZ;
        double nrx = Math.max(1.0, rx * factor);
        double nrz = Math.max(1.0, rz * factor);
        double ax = (cx - this.minX) / rx;
        double az = (cz - this.minZ) / rz;
        this.minX = cx - ax * nrx;
        this.maxX = this.minX + nrx;
        this.minZ = cz - az * nrz;
        this.maxZ = this.minZ + nrz;
        this.lockAspect(contentW, contentH);
        this.clampZoom(contentW, contentH, gridTargetPx);
    }

    void panByScreenDelta(double dx, double dy, int contentW, int contentH) {
        double rx = this.maxX - this.minX;
        double rz = this.maxZ - this.minZ;
        double wx = -dx / Math.max(1.0, (double)contentW) * rx;
        double wz = -dy / Math.max(1.0, (double)contentH) * rz;
        this.minX += wx;
        this.maxX += wx;
        this.minZ += wz;
        this.maxZ += wz;
    }

    double getMinX() {
        return this.minX;
    }

    double getMaxX() {
        return this.maxX;
    }

    double getMinZ() {
        return this.minZ;
    }

    double getMaxZ() {
        return this.maxZ;
    }
}

