/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map;

import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.shiroha233.roadweaver.client.map.GridRenderer;
import net.shiroha233.roadweaver.client.map.MapContextMenu;
import net.shiroha233.roadweaver.client.map.MapDataCollector;
import net.shiroha233.roadweaver.client.map.MapInteraction;
import net.shiroha233.roadweaver.client.map.MapRenderers;
import net.shiroha233.roadweaver.client.map.MapSnapshot;
import net.shiroha233.roadweaver.client.map.MapSnapshotCache;
import net.shiroha233.roadweaver.client.map.MapView;
import net.shiroha233.roadweaver.client.map.RenderUtils;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.network.ClientNetBridge;
import net.shiroha233.roadweaver.util.ComputeService;

public class RoadMapScreen
extends Screen {
    private static final ResourceLocation MAP_TEXTURE = new ResourceLocation("roadweaver", "textures/gui/map.png");
    private static final int TEX_W = 1536;
    private static final int TEX_H = 1024;
    private static final int COLOR_TEXT = -10601186;
    private static final int COLOR_STRUCT = -10601186;
    private static final int COLOR_PLANNED = -11751600;
    private static final int COLOR_GENERATING = -16777216;
    private static final int COLOR_COMPLETED = -16777216;
    private static final int COLOR_FAILED = -522167472;
    private static final int COLOR_GRID = 0x30999999;
    private static final int GRID_TARGET_PX = 32;
    private static final Component MENU_TELEPORT = Component.m_237115_((String)"gui.roadweaver.map.menu.teleport");
    private static final Component BTN_CONFIG = Component.m_237115_((String)"gui.roadweaver.config_button");
    private static final Component BTN_MANUAL = Component.m_237115_((String)"gui.roadweaver.map.manual_connect");
    private static final int MENU_BG = -267382768;
    private static final int MENU_BORDER = -1;
    private static final int MENU_HOVER = 0x40FFFFFF;
    private static final int MENU_TEXT = -1;
    private static final int MENU_MIN_W = 0;
    private static final int MENU_ITEM_H = 14;
    private static final int MENU_PAD_X = 6;
    private static final int MENU_PAD_Y = 4;
    private MapSnapshot snapshot = MapSnapshot.empty();
    private int mapX;
    private int mapY;
    private int mapW;
    private int mapH;
    private static final int OUTER_PAD = 36;
    private static final int INNER_PAD = 25;
    private final MapView view = new MapView();
    private boolean dragging;
    private int dragButton;
    private double lastMouseX;
    private double lastMouseY;
    private boolean debounceZoomPending;
    private long debounceZoomDeadlineMs;
    private boolean showContextMenu;
    private int menuX;
    private int menuY;
    private BlockPos menuTarget;
    private boolean manualMode;
    private BlockPos selectedA;
    private final AtomicInteger requestSeq = new AtomicInteger(0);

    public RoadMapScreen() {
        super((Component)Component.m_237115_((String)"gui.roadweaver.map.title"));
    }

    protected void m_7856_() {
        super.m_7856_();
        MapSnapshotCache.cancelClear();
        MapSnapshot cached = MapSnapshotCache.peek();
        if (cached != null) {
            this.snapshot = cached;
        }
        this.computeMapRect();
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        this.view.resetFromSnapshot(this.snapshot);
        Minecraft mc = this.f_96541_;
        if (mc != null && mc.f_91074_ != null) {
            this.view.calibrateInitialToPlayer(mc, contentW, contentH, 32);
        }
        this.requestCurrentView();
    }

    private void computeMapRect() {
        int availW = this.f_96543_ - 72;
        int availH = this.f_96544_ - 72;
        int w = availW;
        float ratio = 1.5f;
        int h = Math.round((float)w / ratio);
        if (h > availH) {
            h = availH;
            w = Math.round((float)h * ratio);
        }
        this.mapW = w;
        this.mapH = h;
        this.mapX = (this.f_96543_ - w) / 2;
        this.mapY = (this.f_96544_ - h) / 2;
    }

    private boolean insideMap(double x, double y) {
        return x >= (double)(this.mapX + 25) && x <= (double)(this.mapX + this.mapW - 25) && y >= (double)(this.mapY + 25) && y <= (double)(this.mapY + this.mapH - 25);
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        g.m_280411_(MAP_TEXTURE, this.mapX, this.mapY, this.mapW, this.mapH, 0.0f, 0.0f, 1536, 1024, 1536, 1024);
        int titleY = this.mapY - 8;
        g.m_280653_(this.f_96547_, this.m_96636_(), this.f_96543_ / 2, Math.max(6, titleY), -10601186);
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        this.view.lockAspect(contentW, contentH);
        int left = this.mapX + 25;
        int top = this.mapY + 25;
        int right = this.mapX + this.mapW - 25;
        int bottom = this.mapY + this.mapH - 25;
        g.m_280588_(left, top, right, bottom);
        MapRenderers.renderGrid(g, this.f_96547_, this.mapX, this.mapY, this.mapW, this.mapH, 25, this.view.getMinX(), this.view.getMaxX(), this.view.getMinZ(), this.view.getMaxZ(), 0x30999999, 32, -10601186);
        int thickness = this.computeThickness();
        ArrayList<Records.StructureConnection> connForLines = new ArrayList<Records.StructureConnection>(this.snapshot.connections());
        connForLines.removeIf(c -> c.status() == Records.ConnectionStatus.COMPLETED);
        MapRenderers.renderConnections(g, connForLines, (x1, z1, x2, z2) -> this.view.segmentInViewWorld(x1, z1, x2, z2), v -> this.view.toScreenX(v, this.mapX, 25, contentW), v -> this.view.toScreenY(v, this.mapY, 25, contentH), thickness, -11751600, -16777216, -16777216, -522167472, left, top, right, bottom);
        int lodStep = GridRenderer.computeGridStep(this.mapX, this.mapY, this.mapW, this.mapH, 25, this.view.getMinX(), this.view.getMaxX(), this.view.getMinZ(), this.view.getMaxZ(), 32);
        MapRenderers.renderRoadPolylines(g, this.snapshot.roadPolylines(), (x1, z1, x2, z2) -> this.view.segmentInViewWorld(x1, z1, x2, z2), v -> this.view.toScreenX(v, this.mapX, 25, contentW), v -> this.view.toScreenY(v, this.mapY, 25, contentH), thickness, -16777216, left, top, right, bottom, lodStep);
        MapRenderers.renderStructures(g, this.snapshot.structures(), v -> this.view.toScreenX(v, this.mapX, 25, contentW), v -> this.view.toScreenY(v, this.mapY, 25, contentH), (x, z) -> this.view.isInViewWorld((int)x, (int)z), this.computePointSize(), -10601186, left, top, right, bottom);
        if (this.manualMode && this.selectedA != null && this.view.isInViewWorld(this.selectedA.m_123341_(), this.selectedA.m_123343_())) {
            int sx = this.view.toScreenX(this.selectedA.m_123341_(), this.mapX, 25, contentW);
            int sy = this.view.toScreenY(this.selectedA.m_123343_(), this.mapY, 25, contentH);
            int selSize = this.computePointSize() * 2 + 4;
            RenderUtils.drawPoint(g, sx, sy, selSize, -50384, left, top, right, bottom);
        }
        if (!this.showContextMenu) {
            MapInteraction.renderHoverHighlight(g, this.snapshot, this.view, this.mapX, this.mapY, this.mapW, this.mapH, 25, mouseX, mouseY);
        }
        this.renderPlayer(g);
        g.m_280618_();
        int legendRight = this.mapX + this.mapW - 25;
        int legendStartY = this.mapY + 25 + 8;
        int gap = 8;
        MapRenderers.renderLegend(g, this.f_96547_, legendRight, legendStartY, gap, -10601186, -10601186, -11751600, -16777216, -16777216, -522167472, this.snapshot.structuresCount(), this.snapshot.plannedCount(), this.snapshot.generatingCount(), this.snapshot.completedCount(), this.snapshot.failedCount());
        this.renderConfigButton(g, mouseX, mouseY);
        this.renderManualButton(g, mouseX, mouseY);
        if (!this.showContextMenu) {
            MapInteraction.renderHoverTooltip(g, this.f_96547_, this.snapshot, this.view, this.mapX, this.mapY, this.mapW, this.mapH, 25, mouseX, mouseY);
        }
        if (this.debounceZoomPending && System.currentTimeMillis() >= this.debounceZoomDeadlineMs) {
            this.debounceZoomPending = false;
            this.requestCurrentView();
        }
        if (this.showContextMenu && this.menuTarget != null) {
            int[] bounds = MapContextMenu.computeMenuBounds(this.f_96547_, MENU_TELEPORT, this.menuX, this.menuY, this.f_96543_, this.f_96544_, 6, 4, 14, 0);
            int hover = MapContextMenu.getMenuHoverIndex(mouseX, mouseY, bounds, 4, 14, 1);
            MapContextMenu.renderContextMenu(g, this.f_96547_, MENU_TELEPORT, mouseX, mouseY, bounds, hover, -267382768, -1, 0x40FFFFFF, -1, this.f_96543_, this.f_96544_);
        }
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    private int computeThickness() {
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        double ppb = Math.min(this.view.pxPerBlockX(contentW), this.view.pxPerBlockZ(contentH));
        int t = (int)Math.round(ppb);
        if (t < 1) {
            t = 1;
        }
        if (t > 4) {
            t = 4;
        }
        return t;
    }

    private int computePointSize() {
        return 2 + this.computeThickness();
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7861_() {
        super.m_7861_();
        MapSnapshotCache.scheduleClear(1000L);
    }

    public void setSnapshot(MapSnapshot snapshot) {
        if (snapshot != null) {
            this.snapshot = snapshot;
            MapSnapshotCache.put(snapshot);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (!this.insideMap(mouseX, mouseY)) {
            return super.m_6050_(mouseX, mouseY, delta);
        }
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        double factor = delta > 0.0 ? 0.9 : 1.1;
        double cx = this.view.screenToWorldX(mouseX, this.mapX, 25, contentW);
        double cz = this.view.screenToWorldZ(mouseY, this.mapY, 25, contentH);
        this.view.applyZoomAround(cx, cz, factor, contentW, contentH, 32);
        this.debounceZoomPending = true;
        this.debounceZoomDeadlineMs = System.currentTimeMillis() + 500L;
        this.showContextMenu = false;
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        BlockPos best;
        if (button == 0 && this.insideConfigButton((int)mouseX, (int)mouseY)) {
            this.openConfig();
            return true;
        }
        if (button == 0 && this.insideManualButton((int)mouseX, (int)mouseY)) {
            boolean bl = this.manualMode = !this.manualMode;
            if (!this.manualMode) {
                this.selectedA = null;
            }
            this.showContextMenu = false;
            return true;
        }
        if (this.showContextMenu) {
            boolean inside;
            int[] bounds = MapContextMenu.computeMenuBounds(this.f_96547_, MENU_TELEPORT, this.menuX, this.menuY, this.f_96543_, this.f_96544_, 6, 4, 14, 0);
            int bx = bounds[0];
            int by = bounds[1];
            int bw = bounds[2];
            int bh = bounds[3];
            boolean bl = inside = mouseX >= (double)bx && mouseX <= (double)(bx + bw) && mouseY >= (double)by && mouseY <= (double)(by + bh);
            if (inside && button == 0) {
                int idx = MapContextMenu.getMenuHoverIndex((int)mouseX, (int)mouseY, bounds, 4, 14, 1);
                if (idx == 0) {
                    this.onTeleportSelected();
                    this.showContextMenu = false;
                    return true;
                }
            } else {
                this.showContextMenu = false;
            }
        }
        if (this.manualMode && this.insideMap(mouseX, mouseY) && button == 0 && (best = this.findNearestStructure(mouseX, mouseY)) != null) {
            if (this.selectedA == null || this.selectedA.equals((Object)best)) {
                this.selectedA = best;
            } else {
                ClientNetBridge.requestManualConnect(this.selectedA.m_123341_(), this.selectedA.m_123343_(), best.m_123341_(), best.m_123343_());
                this.selectedA = null;
                this.requestCurrentView();
            }
            this.showContextMenu = false;
            return true;
        }
        if (this.insideMap(mouseX, mouseY) && button == 0) {
            this.dragging = true;
            this.dragButton = button;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.debounceZoomPending = false;
            this.showContextMenu = false;
            return true;
        }
        if (this.insideMap(mouseX, mouseY) && button == 1 && (best = this.findNearestStructure(mouseX, mouseY)) != null) {
            this.menuTarget = best;
            this.menuX = (int)mouseX;
            this.menuY = (int)mouseY;
            this.showContextMenu = true;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging && button == this.dragButton) {
            int contentW = this.mapW - 50;
            int contentH = this.mapH - 50;
            double dx = mouseX - this.lastMouseX;
            double dy = mouseY - this.lastMouseY;
            this.view.panByScreenDelta(dx, dy, contentW, contentH);
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.view.lockAspect(contentW, contentH);
            this.showContextMenu = false;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.dragging && button == this.dragButton) {
            this.dragging = false;
            this.view.clampZoom(this.mapW - 50, this.mapH - 50, 32);
            this.debounceZoomPending = false;
            this.requestCurrentView();
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void renderPlayer(GuiGraphics g) {
        int sy;
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        double wx = this.f_96541_.f_91074_.m_20185_();
        double wz = this.f_96541_.f_91074_.m_20189_();
        int sx = this.view.toScreenX((int)Math.round(wx), this.mapX, 25, this.mapW - 50);
        if (!this.insideMap(sx, sy = this.view.toScreenY((int)Math.round(wz), this.mapY, 25, this.mapH - 50))) {
            return;
        }
        float yaw = this.f_96541_.f_91074_.m_146908_();
        int left = this.mapX + 25;
        int right = this.mapX + this.mapW - 25;
        int top = this.mapY + 25;
        int bottom = this.mapY + this.mapH - 25;
        MapRenderers.drawPlayerArrow(g, sx, sy, yaw, 10, 6, 4, -16777216, left, top, right, bottom, this.view.pxPerBlockX(this.mapW - 50), this.view.pxPerBlockZ(this.mapH - 50));
    }

    private void requestCurrentView() {
        int minX = (int)Math.floor(Math.min(this.view.getMinX(), this.view.getMaxX()));
        int maxX = (int)Math.ceil(Math.max(this.view.getMinX(), this.view.getMaxX()));
        int minZ = (int)Math.floor(Math.min(this.view.getMinZ(), this.view.getMaxZ()));
        int maxZ = (int)Math.ceil(Math.max(this.view.getMinZ(), this.view.getMaxZ()));
        int pad = 32;
        int fMinX = minX -= pad;
        int fMaxX = maxX += pad;
        int fMinZ = minZ -= pad;
        int fMaxZ = maxZ += pad;
        Minecraft mc = this.f_96541_;
        if (mc == null) {
            return;
        }
        IntegratedServer server = mc.m_91092_();
        if (server != null) {
            ServerLevel level = server.m_129880_(Level.f_46428_);
            if (level != null) {
                int radiusChunks;
                int cx = 0;
                int cz = 0;
                if (mc.f_91074_ != null) {
                    cx = (int)Math.round(mc.f_91074_.m_20185_());
                    cz = (int)Math.round(mc.f_91074_.m_20189_());
                }
                try {
                    ModConfig cfg = ConfigService.get();
                    radiusChunks = cfg.dynamicPlanEnabled() ? cfg.dynamicPlanRadiusChunks() : cfg.initialPlanRadiusChunks();
                }
                catch (Throwable t) {
                    radiusChunks = 256;
                }
                int radiusBlocks = Math.max(1, radiusChunks) * 16;
                int fcx = cx;
                int fcz = cz;
                int currentSeq = this.requestSeq.incrementAndGet();
                CompletableFuture.supplyAsync(() -> MapDataCollector.build(level, fMinX, fMinZ, fMaxX, fMaxZ, fcx, fcz, radiusBlocks), ComputeService.executor()).thenAccept(snap -> mc.execute(() -> {
                    if (this.requestSeq.get() == currentSeq) {
                        this.setSnapshot((MapSnapshot)snap);
                    }
                }));
            }
        } else {
            this.requestSeq.incrementAndGet();
            ClientNetBridge.requestSnapshot(minX, minZ, maxX, maxZ);
        }
    }

    private BlockPos findNearestStructure(double mouseX, double mouseY) {
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        int bestDist = Integer.MAX_VALUE;
        BlockPos best = null;
        for (BlockPos p : this.snapshot.structures()) {
            int dy;
            if (!this.view.isInViewWorld(p.m_123341_(), p.m_123343_())) continue;
            int x = this.view.toScreenX(p.m_123341_(), this.mapX, 25, contentW);
            int y = this.view.toScreenY(p.m_123343_(), this.mapY, 25, contentH);
            int dx = (int)Math.abs((double)x - mouseX);
            int d2 = dx * dx + (dy = (int)Math.abs((double)y - mouseY)) * dy;
            if (d2 >= bestDist) continue;
            bestDist = d2;
            best = p;
        }
        if (best != null && bestDist <= 64) {
            return best;
        }
        return null;
    }

    private void onTeleportSelected() {
        if (this.menuTarget == null) {
            return;
        }
        ClientNetBridge.requestTeleport(this.menuTarget.m_123341_(), this.menuTarget.m_123342_(), this.menuTarget.m_123343_());
    }

    private int[] computeConfigBtnBounds() {
        int x = this.mapX + 25 + 4;
        int y = this.mapY + 25 + 4;
        int w = this.f_96547_.m_92852_((FormattedText)BTN_CONFIG) + 6;
        Objects.requireNonNull(this.f_96547_);
        int h = 9 + 4;
        return new int[]{x, y, w, h};
    }

    private boolean insideConfigButton(int mx, int my) {
        int[] b = this.computeConfigBtnBounds();
        int x = b[0];
        int y = b[1];
        int w = b[2];
        int h = b[3];
        return mx >= x && mx <= x + w && my >= y && my <= y + h;
    }

    private void renderConfigButton(GuiGraphics g, int mouseX, int mouseY) {
        int[] b = this.computeConfigBtnBounds();
        int x = b[0];
        int y = b[1];
        int h = b[3];
        Objects.requireNonNull(this.f_96547_);
        int ty = y + (h - 9) / 2;
        g.m_280614_(this.f_96547_, BTN_CONFIG, x + 3, ty, -10601186, false);
        if (this.insideConfigButton(mouseX, mouseY)) {
            int textW = this.f_96547_.m_92852_((FormattedText)BTN_CONFIG);
            Objects.requireNonNull(this.f_96547_);
            int uy = ty + 9 + 1;
            int underline = 1616788766;
            g.m_280509_(x + 2, uy, x + 2 + textW + 2, uy + 1, underline);
        }
    }

    private Component manualLabel() {
        MutableComponent onoff = this.manualMode ? Component.m_237115_((String)"gui.roadweaver.common.on") : Component.m_237115_((String)"gui.roadweaver.common.off");
        return Component.m_237119_().m_7220_(BTN_MANUAL).m_130946_(": ").m_7220_((Component)onoff);
    }

    private int[] computeManualBtnBounds() {
        Component lbl = this.manualLabel();
        int w = this.f_96547_.m_92852_((FormattedText)lbl) + 6;
        Objects.requireNonNull(this.f_96547_);
        int h = 9 + 4;
        int x = this.mapX + 25 + 4;
        int y = this.mapY + this.mapH - 25 - 4 - h;
        return new int[]{x, y, w, h};
    }

    private boolean insideManualButton(int mx, int my) {
        int[] b = this.computeManualBtnBounds();
        int x = b[0];
        int y = b[1];
        int w = b[2];
        int h = b[3];
        return mx >= x && mx <= x + w && my >= y && my <= y + h;
    }

    private void renderManualButton(GuiGraphics g, int mouseX, int mouseY) {
        int[] b = this.computeManualBtnBounds();
        int x = b[0];
        int y = b[1];
        int h = b[3];
        Objects.requireNonNull(this.f_96547_);
        int ty = y + (h - 9) / 2;
        Component lbl = this.manualLabel();
        g.m_280614_(this.f_96547_, lbl, x + 3, ty, -10601186, false);
        if (this.insideManualButton(mouseX, mouseY)) {
            int textW = this.f_96547_.m_92852_((FormattedText)lbl);
            Objects.requireNonNull(this.f_96547_);
            int uy = ty + 9 + 1;
            int underline = 1616788766;
            g.m_280509_(x + 2, uy, x + 2 + textW + 2, uy + 1, underline);
        }
    }

    private void openConfig() {
        Class<?> c2;
        if (this.f_96541_ == null) {
            return;
        }
        Screen next = null;
        try {
            c2 = Class.forName("net.shiroha233.roadweaver.client.fabric.ConfigScreenFactoryImpl");
            next = (Screen)c2.getMethod("createConfigScreen", Screen.class).invoke(null, new Object[]{this});
        }
        catch (Throwable c2) {
            // empty catch block
        }
        if (next == null) {
            try {
                c2 = Class.forName("net.shiroha233.roadweaver.client.forge.ConfigScreenFactoryImpl");
                next = (Screen)c2.getMethod("createConfigScreen", Screen.class).invoke(null, new Object[]{this});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (next != null) {
            this.f_96541_.m_91152_(next);
        }
    }
}

