/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.config;

import java.util.ArrayList;
import java.util.List;

public final class ModConfig {
    private boolean villagePredictionEnabled = true;
    private int predictRadiusChunks = 1024;
    private boolean biomePrefilter = true;
    private List<String> structureWhitelist = new ArrayList<String>();
    private List<String> structureBlacklist = new ArrayList<String>();
    private int initialPlanRadiusChunks;
    private boolean dynamicPlanEnabled;
    private int dynamicPlanRadiusChunks;
    private int dynamicPlanStrideChunks;
    private PlanningAlgorithm planningAlgorithm;
    private boolean allowArtificial;
    private boolean allowNatural;
    private boolean placeWaypoints;
    private int averagingRadius;
    private int generationThreads;
    private int maxConcurrentGenerations;
    private int aStarStep;
    private int causewayMaxDepth;
    private int maxSlopeStepPerTwoSegments;
    private int roadWidth;
    private int lampInterval;
    private boolean tunnelEnabled;
    private int tunnelClearHeight;
    private List<String> selectedArtificialPresetIds;
    private boolean useWeightedPreset;
    private boolean removeWholeTreeOnPath;
    private int treeRemovalMaxRadius;
    private int treeRemovalMaxHeight;
    private int treeRemovalMaxBlocks;
    private int treeLeavesConfirm;
    private boolean bridgeEnabled;
    private int bridgeDeckClearance;
    private boolean bridgeRailingEnabled;
    private int bridgePierInterval;
    private int bridgePierWidth;
    private int bridgePierMaxHeight;
    private boolean bridgeKeepLamps;
    private int bridgeRampSegments;

    public ModConfig() {
        this.structureWhitelist.add("#minecraft:village");
        this.initialPlanRadiusChunks = 64;
        this.dynamicPlanEnabled = true;
        this.dynamicPlanRadiusChunks = 256;
        this.dynamicPlanStrideChunks = Math.max(8, Math.min(64, this.dynamicPlanRadiusChunks / 2));
        this.planningAlgorithm = PlanningAlgorithm.RNG;
        this.allowArtificial = true;
        this.allowNatural = true;
        this.placeWaypoints = false;
        this.averagingRadius = 8;
        this.generationThreads = Math.max(2, Math.min(3, Runtime.getRuntime().availableProcessors()));
        this.maxConcurrentGenerations = Math.max(1, Math.min(3, this.generationThreads));
        this.aStarStep = 16;
        this.causewayMaxDepth = 1;
        this.maxSlopeStepPerTwoSegments = 1;
        this.roadWidth = 3;
        this.lampInterval = 32;
        this.tunnelEnabled = false;
        this.tunnelClearHeight = 5;
        this.selectedArtificialPresetIds = new ArrayList<String>();
        this.useWeightedPreset = true;
        this.removeWholeTreeOnPath = true;
        this.treeRemovalMaxRadius = 6;
        this.treeRemovalMaxHeight = 24;
        this.treeRemovalMaxBlocks = 2048;
        this.treeLeavesConfirm = 6;
        this.bridgeEnabled = true;
        this.bridgeDeckClearance = 2;
        this.bridgeRailingEnabled = true;
        this.bridgePierInterval = 6;
        this.bridgePierWidth = 1;
        this.bridgePierMaxHeight = 20;
        this.bridgeKeepLamps = true;
        this.bridgeRampSegments = 4;
    }

    public boolean villagePredictionEnabled() {
        return this.villagePredictionEnabled;
    }

    public void setVillagePredictionEnabled(boolean villagePredictionEnabled) {
        this.villagePredictionEnabled = villagePredictionEnabled;
    }

    public int predictRadiusChunks() {
        return this.predictRadiusChunks;
    }

    public void setPredictRadiusChunks(int predictRadiusChunks) {
        this.predictRadiusChunks = predictRadiusChunks;
    }

    public boolean biomePrefilter() {
        return this.biomePrefilter;
    }

    public void setBiomePrefilter(boolean biomePrefilter) {
        this.biomePrefilter = biomePrefilter;
    }

    public List<String> structureWhitelist() {
        return this.structureWhitelist;
    }

    public void setStructureWhitelist(List<String> structureWhitelist) {
        this.structureWhitelist = structureWhitelist == null ? new ArrayList<String>() : new ArrayList<String>(structureWhitelist);
    }

    public List<String> structureBlacklist() {
        return this.structureBlacklist;
    }

    public void setStructureBlacklist(List<String> structureBlacklist) {
        this.structureBlacklist = structureBlacklist == null ? new ArrayList<String>() : new ArrayList<String>(structureBlacklist);
    }

    public void sanitize() {
        int maxCap;
        if (this.structureWhitelist == null) {
            this.structureWhitelist = new ArrayList<String>();
        }
        if (this.structureBlacklist == null) {
            this.structureBlacklist = new ArrayList<String>();
        }
        if (this.predictRadiusChunks <= 0) {
            this.predictRadiusChunks = 1024;
        }
        if (this.initialPlanRadiusChunks <= 0) {
            this.initialPlanRadiusChunks = 64;
        }
        if (this.dynamicPlanRadiusChunks <= 0) {
            this.dynamicPlanRadiusChunks = 256;
        }
        if (this.dynamicPlanStrideChunks <= 0) {
            this.dynamicPlanStrideChunks = Math.max(8, Math.min(64, Math.max(1, this.dynamicPlanRadiusChunks) / 2));
        }
        if (this.dynamicPlanStrideChunks > this.dynamicPlanRadiusChunks) {
            this.dynamicPlanStrideChunks = this.dynamicPlanRadiusChunks;
        }
        if (this.dynamicPlanStrideChunks > 256) {
            this.dynamicPlanStrideChunks = 256;
        }
        if (this.planningAlgorithm == null) {
            this.planningAlgorithm = PlanningAlgorithm.RNG;
        }
        if (this.averagingRadius < 0) {
            this.averagingRadius = 0;
        }
        if (this.generationThreads < 1) {
            this.generationThreads = Math.max(2, Math.min(8, Runtime.getRuntime().availableProcessors()));
        }
        if (this.generationThreads > 64) {
            this.generationThreads = 64;
        }
        if (this.maxConcurrentGenerations < 1) {
            this.maxConcurrentGenerations = this.generationThreads;
        }
        if (this.maxConcurrentGenerations > (maxCap = Math.max(1, this.generationThreads * 2))) {
            this.maxConcurrentGenerations = maxCap;
        }
        if (this.aStarStep < 4) {
            this.aStarStep = 16;
        }
        if (this.aStarStep > 128) {
            this.aStarStep = 128;
        }
        if (this.causewayMaxDepth < 0) {
            this.causewayMaxDepth = 0;
        }
        if (this.causewayMaxDepth > 12) {
            this.causewayMaxDepth = 12;
        }
        if (this.maxSlopeStepPerTwoSegments < 0) {
            this.maxSlopeStepPerTwoSegments = 0;
        }
        if (this.maxSlopeStepPerTwoSegments > 8) {
            this.maxSlopeStepPerTwoSegments = 8;
        }
        if (this.roadWidth < 0) {
            this.roadWidth = 0;
        }
        if (this.roadWidth > 15) {
            this.roadWidth = 15;
        }
        if (this.lampInterval < 1) {
            this.lampInterval = 59;
        }
        if (this.lampInterval > 2048) {
            this.lampInterval = 2048;
        }
        if (this.tunnelClearHeight < 2) {
            this.tunnelClearHeight = 2;
        }
        if (this.tunnelClearHeight > 16) {
            this.tunnelClearHeight = 16;
        }
        if (this.selectedArtificialPresetIds == null) {
            this.selectedArtificialPresetIds = new ArrayList<String>();
        }
        if (this.treeRemovalMaxRadius < 2) {
            this.treeRemovalMaxRadius = 2;
        }
        if (this.treeRemovalMaxRadius > 12) {
            this.treeRemovalMaxRadius = 12;
        }
        if (this.treeRemovalMaxHeight < 8) {
            this.treeRemovalMaxHeight = 8;
        }
        if (this.treeRemovalMaxHeight > 64) {
            this.treeRemovalMaxHeight = 64;
        }
        if (this.treeRemovalMaxBlocks < 64) {
            this.treeRemovalMaxBlocks = 64;
        }
        if (this.treeRemovalMaxBlocks > 8192) {
            this.treeRemovalMaxBlocks = 8192;
        }
        if (this.treeLeavesConfirm < 0) {
            this.treeLeavesConfirm = 0;
        }
        if (this.treeLeavesConfirm > 128) {
            this.treeLeavesConfirm = 128;
        }
        if (this.bridgeDeckClearance < 1) {
            this.bridgeDeckClearance = 1;
        }
        if (this.bridgeDeckClearance > 8) {
            this.bridgeDeckClearance = 8;
        }
        if (this.bridgePierInterval < 3) {
            this.bridgePierInterval = 3;
        }
        if (this.bridgePierInterval > 32) {
            this.bridgePierInterval = 32;
        }
        if (this.bridgePierWidth < 1) {
            this.bridgePierWidth = 1;
        }
        if (this.bridgePierWidth > 3) {
            this.bridgePierWidth = 3;
        }
        if (this.bridgePierMaxHeight < 6) {
            this.bridgePierMaxHeight = 6;
        }
        if (this.bridgePierMaxHeight > 64) {
            this.bridgePierMaxHeight = 64;
        }
        if (this.bridgeRampSegments < 0) {
            this.bridgeRampSegments = 0;
        }
        if (this.bridgeRampSegments > 12) {
            this.bridgeRampSegments = 12;
        }
    }

    public int initialPlanRadiusChunks() {
        return this.initialPlanRadiusChunks;
    }

    public void setInitialPlanRadiusChunks(int v) {
        this.initialPlanRadiusChunks = v;
    }

    public boolean dynamicPlanEnabled() {
        return this.dynamicPlanEnabled;
    }

    public void setDynamicPlanEnabled(boolean v) {
        this.dynamicPlanEnabled = v;
    }

    public int dynamicPlanRadiusChunks() {
        return this.dynamicPlanRadiusChunks;
    }

    public void setDynamicPlanRadiusChunks(int v) {
        this.dynamicPlanRadiusChunks = v;
    }

    public int dynamicPlanStrideChunks() {
        return this.dynamicPlanStrideChunks;
    }

    public void setDynamicPlanStrideChunks(int v) {
        this.dynamicPlanStrideChunks = v;
    }

    public boolean allowArtificial() {
        return this.allowArtificial;
    }

    public void setAllowArtificial(boolean v) {
        this.allowArtificial = v;
    }

    public boolean allowNatural() {
        return this.allowNatural;
    }

    public void setAllowNatural(boolean v) {
        this.allowNatural = v;
    }

    public boolean placeWaypoints() {
        return this.placeWaypoints;
    }

    public void setPlaceWaypoints(boolean v) {
        this.placeWaypoints = v;
    }

    public int averagingRadius() {
        return this.averagingRadius;
    }

    public void setAveragingRadius(int v) {
        this.averagingRadius = v;
    }

    public int generationThreads() {
        return this.generationThreads;
    }

    public void setGenerationThreads(int v) {
        this.generationThreads = v;
    }

    public int maxConcurrentGenerations() {
        return this.maxConcurrentGenerations;
    }

    public void setMaxConcurrentGenerations(int v) {
        this.maxConcurrentGenerations = v;
    }

    public int aStarStep() {
        return this.aStarStep;
    }

    public void setAStarStep(int v) {
        this.aStarStep = v;
    }

    public int causewayMaxDepth() {
        return this.causewayMaxDepth;
    }

    public void setCausewayMaxDepth(int v) {
        this.causewayMaxDepth = v;
    }

    public int maxSlopeStepPerTwoSegments() {
        return this.maxSlopeStepPerTwoSegments;
    }

    public void setMaxSlopeStepPerTwoSegments(int v) {
        this.maxSlopeStepPerTwoSegments = v;
    }

    public int roadWidth() {
        return this.roadWidth;
    }

    public void setRoadWidth(int v) {
        this.roadWidth = v;
    }

    public int lampInterval() {
        return this.lampInterval;
    }

    public void setLampInterval(int v) {
        this.lampInterval = v;
    }

    public PlanningAlgorithm planningAlgorithm() {
        return this.planningAlgorithm;
    }

    public void setPlanningAlgorithm(PlanningAlgorithm v) {
        this.planningAlgorithm = v;
    }

    public boolean tunnelEnabled() {
        return this.tunnelEnabled;
    }

    public void setTunnelEnabled(boolean v) {
        this.tunnelEnabled = v;
    }

    public int tunnelClearHeight() {
        return this.tunnelClearHeight;
    }

    public void setTunnelClearHeight(int v) {
        this.tunnelClearHeight = v;
    }

    public List<String> selectedArtificialPresetIds() {
        return this.selectedArtificialPresetIds;
    }

    public void setSelectedArtificialPresetIds(List<String> v) {
        this.selectedArtificialPresetIds = v == null ? new ArrayList<String>() : new ArrayList<String>(v);
    }

    public boolean useWeightedPreset() {
        return this.useWeightedPreset;
    }

    public void setUseWeightedPreset(boolean v) {
        this.useWeightedPreset = v;
    }

    public boolean removeWholeTreeOnPath() {
        return this.removeWholeTreeOnPath;
    }

    public void setRemoveWholeTreeOnPath(boolean v) {
        this.removeWholeTreeOnPath = v;
    }

    public int treeRemovalMaxRadius() {
        return this.treeRemovalMaxRadius;
    }

    public void setTreeRemovalMaxRadius(int v) {
        this.treeRemovalMaxRadius = v;
    }

    public int treeRemovalMaxHeight() {
        return this.treeRemovalMaxHeight;
    }

    public void setTreeRemovalMaxHeight(int v) {
        this.treeRemovalMaxHeight = v;
    }

    public int treeRemovalMaxBlocks() {
        return this.treeRemovalMaxBlocks;
    }

    public void setTreeRemovalMaxBlocks(int v) {
        this.treeRemovalMaxBlocks = v;
    }

    public int treeLeavesConfirm() {
        return this.treeLeavesConfirm;
    }

    public void setTreeLeavesConfirm(int v) {
        this.treeLeavesConfirm = v;
    }

    public boolean bridgeEnabled() {
        return this.bridgeEnabled;
    }

    public void setBridgeEnabled(boolean v) {
        this.bridgeEnabled = v;
    }

    public int bridgeDeckClearance() {
        return this.bridgeDeckClearance;
    }

    public void setBridgeDeckClearance(int v) {
        this.bridgeDeckClearance = v;
    }

    public boolean bridgeRailingEnabled() {
        return this.bridgeRailingEnabled;
    }

    public void setBridgeRailingEnabled(boolean v) {
        this.bridgeRailingEnabled = v;
    }

    public int bridgePierInterval() {
        return this.bridgePierInterval;
    }

    public void setBridgePierInterval(int v) {
        this.bridgePierInterval = v;
    }

    public int bridgePierWidth() {
        return this.bridgePierWidth;
    }

    public void setBridgePierWidth(int v) {
        this.bridgePierWidth = v;
    }

    public int bridgePierMaxHeight() {
        return this.bridgePierMaxHeight;
    }

    public void setBridgePierMaxHeight(int v) {
        this.bridgePierMaxHeight = v;
    }

    public boolean bridgeKeepLamps() {
        return this.bridgeKeepLamps;
    }

    public void setBridgeKeepLamps(boolean v) {
        this.bridgeKeepLamps = v;
    }

    public int bridgeRampSegments() {
        return this.bridgeRampSegments;
    }

    public void setBridgeRampSegments(int v) {
        this.bridgeRampSegments = v;
    }

    public static enum PlanningAlgorithm {
        KNN,
        DELAUNAY,
        RNG;

    }
}

