/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.bridge.BridgeBuilder;
import net.shiroha233.roadweaver.features.config.RoadFeatureConfig;
import net.shiroha233.roadweaver.features.decoration.Decoration;
import net.shiroha233.roadweaver.features.decoration.RoadStructures;
import net.shiroha233.roadweaver.features.decoration.system.ArtificialDecorationSystem;
import net.shiroha233.roadweaver.features.decoration.system.NaturalDecorationSystem;
import net.shiroha233.roadweaver.features.decoration.system.SurfacePlacementUtil;
import net.shiroha233.roadweaver.features.decoration.util.BiomeRoadMaterialSelector;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.sharded.RoadShardStorage;

public class RoadFeature
extends Feature<RoadFeatureConfig> {
    public RoadFeature(Codec<RoadFeatureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<RoadFeatureConfig> ctx) {
        WorldGenLevel world = ctx.m_159774_();
        ServerLevel lvl = world.m_6018_();
        if (!(lvl instanceof ServerLevel)) {
            return false;
        }
        ServerLevel server = lvl;
        ChunkPos currentChunk = new ChunkPos(ctx.m_159777_());
        int minX = currentChunk.m_45604_();
        int minZ = currentChunk.m_45605_();
        int maxX = currentChunk.m_45608_();
        int maxZ = currentChunk.m_45609_();
        List<Records.RoadData> roadDataList = RoadShardStorage.queryRect(server, minX, minZ, maxX, maxZ);
        if (roadDataList == null || roadDataList.isEmpty()) {
            return false;
        }
        HashSet<BlockPos> processedMiddle = new HashSet<BlockPos>();
        RandomSource random = ctx.m_225041_();
        ModConfig cfg = ConfigService.get();
        int averagingRadius = Math.max(0, cfg.averagingRadius());
        HashSet<Decoration> decorations = new HashSet<Decoration>();
        for (Records.RoadData data : roadDataList) {
            int roadType = data.roadType();
            int roadWidth = Math.max(1, data.width());
            List<BlockState> materials = data.materials();
            List<Records.RoadSegmentPlacement> segments = data.roadSegmentList();
            if (segments == null || segments.size() < 5) continue;
            List<BlockPos> middlePositions = segments.stream().map(Records.RoadSegmentPlacement::middlePos).toList();
            boolean[] isBridge = new boolean[middlePositions.size()];
            ArrayList<int[]> bridgeRanges = new ArrayList<int[]>();
            HashMap<Long, Integer> indexMap = new HashMap<Long, Integer>();
            for (int i = 0; i < middlePositions.size(); ++i) {
                indexMap.put(middlePositions.get(i).m_121878_(), i);
            }
            List<Records.RoadSpan> spans = data.spans();
            if (spans != null) {
                for (Records.RoadSpan sp : spans) {
                    if (sp.type() != Records.SpanType.BRIDGE) continue;
                    Integer si = (Integer)indexMap.get(sp.start().m_121878_());
                    Integer ei = (Integer)indexMap.get(sp.end().m_121878_());
                    if (si == null || ei == null) continue;
                    int a = Math.max(0, Math.min(si, ei));
                    int b = Math.min(middlePositions.size() - 1, Math.max(si, ei));
                    for (int k = a; k <= b; ++k) {
                        isBridge[k] = true;
                    }
                    bridgeRanges.add(new int[]{a, b});
                }
            }
            if (!bridgeRanges.isEmpty()) {
                bridgeRanges.sort(Comparator.comparingInt(o -> o[0]));
                ArrayList<int[]> merged = new ArrayList<int[]>();
                int[] cur = (int[])bridgeRanges.get(0);
                for (int idx = 1; idx < bridgeRanges.size(); ++idx) {
                    int[] nxt = (int[])bridgeRanges.get(idx);
                    if (nxt[0] <= cur[1] + 1) {
                        cur[1] = Math.max(cur[1], nxt[1]);
                        continue;
                    }
                    merged.add(cur);
                    cur = nxt;
                }
                merged.add(cur);
                bridgeRanges = merged;
            }
            int n = middlePositions.size();
            List<Integer> targetY = data.targetY();
            boolean usePersisted = targetY != null && targetY.size() == n;
            int[] smoothedYArr = null;
            if (!usePersisted) {
                int y;
                int ii;
                int ii2;
                int[] baseYArr = new int[n];
                for (ii2 = 0; ii2 < n; ++ii2) {
                    ArrayList<Integer> hs = new ArrayList<Integer>();
                    for (int jj = ii2 - averagingRadius; jj <= ii2 + averagingRadius; ++jj) {
                        BlockPos sp;
                        if (jj < 0 || jj >= n || !new ChunkPos(sp = middlePositions.get(jj)).equals((Object)currentChunk)) continue;
                        int yTop = world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, sp.m_123341_(), sp.m_123343_());
                        hs.add(yTop);
                    }
                    if (hs.isEmpty()) {
                        BlockPos mid = middlePositions.get(ii2);
                        if (new ChunkPos(mid).equals((Object)currentChunk)) {
                            baseYArr[ii2] = world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, mid.m_123341_(), mid.m_123343_());
                            continue;
                        }
                        baseYArr[ii2] = middlePositions.get(ii2).m_123342_();
                        continue;
                    }
                    baseYArr[ii2] = (int)Math.round(hs.stream().mapToInt(Integer::intValue).average().orElse(middlePositions.get(ii2).m_123342_()));
                }
                smoothedYArr = new int[n];
                for (ii2 = 0; ii2 < n; ++ii2) {
                    smoothedYArr[ii2] = baseYArr[ii2];
                }
                int step = Math.max(0, Math.min(8, cfg.maxSlopeStepPerTwoSegments()));
                for (ii = 2; ii < n; ++ii) {
                    y = smoothedYArr[ii];
                    int py = smoothedYArr[ii - 2];
                    if (y > py + step) {
                        y = py + step;
                    }
                    if (y < py - step) {
                        y = py - step;
                    }
                    smoothedYArr[ii] = y;
                }
                for (ii = n - 3; ii >= 0; --ii) {
                    y = smoothedYArr[ii];
                    int ny = smoothedYArr[ii + 2];
                    if (y > ny + step) {
                        y = ny + step;
                    }
                    if (y < ny - step) {
                        y = ny - step;
                    }
                    smoothedYArr[ii] = y;
                }
            }
            int deckY = server.m_5736_() + cfg.bridgeDeckClearance();
            int segmentIndex = 0;
            boolean insideBridgeRange = false;
            int currentRangeEnd = -1;
            Integer lastBridgeDeckY = null;
            for (int i = 2; i < segments.size() - 2; ++i) {
                ChunkPos middleChunk;
                BlockPos middle = middlePositions.get(i);
                if (!processedMiddle.add(middle) || ++segmentIndex < 60 || segmentIndex > segments.size() - 60 || !(middleChunk = new ChunkPos(middle)).equals((Object)currentChunk)) continue;
                BlockPos prev = middlePositions.get(i - 2);
                BlockPos next = middlePositions.get(i + 2);
                int topYCenter = world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, middle.m_123341_(), middle.m_123343_());
                BlockPos averaged = new BlockPos(middle.m_123341_(), topYCenter, middle.m_123343_());
                int baseYForThis = usePersisted ? targetY.get(i) : (smoothedYArr != null ? smoothedYArr[i] : topYCenter);
                Records.RoadSegmentPlacement seg = segments.get(i);
                if (cfg.bridgeEnabled() && isBridge[i]) {
                    int segDeckY = deckY;
                    boolean placePier = true;
                    boolean placeRail = true;
                    int rampN = Math.max(0, cfg.bridgeRampSegments());
                    if (!insideBridgeRange) {
                        for (int[] r : bridgeRanges) {
                            if (i < r[0] || i > r[1]) continue;
                            insideBridgeRange = true;
                            currentRangeEnd = r[1];
                            break;
                        }
                        lastBridgeDeckY = null;
                    }
                    if (rampN > 0 && !bridgeRanges.isEmpty()) {
                        for (int[] r : bridgeRanges) {
                            if (i < r[0] || i > r[1]) continue;
                            int dStart = i - r[0];
                            int dEnd = r[1] - i;
                            if (dStart >= rampN && dEnd >= rampN) break;
                            double f = dStart < rampN ? (double)dStart / (double)rampN : (double)dEnd / (double)rampN;
                            int rampBaseY = baseYForThis;
                            segDeckY = (int)Math.round((double)rampBaseY + (double)(deckY - rampBaseY) * Math.max(0.0, Math.min(1.0, f)));
                            placePier = false;
                            placeRail = false;
                            break;
                        }
                    }
                    if (placeRail && !bridgeRanges.isEmpty()) {
                        for (int[] r : bridgeRanges) {
                            if (i != r[0] && i != r[1]) continue;
                            placeRail = false;
                            break;
                        }
                    }
                    if (lastBridgeDeckY != null) {
                        int stepDeck = Math.max(0, Math.min(8, cfg.maxSlopeStepPerTwoSegments()));
                        if (segDeckY > lastBridgeDeckY + stepDeck) {
                            segDeckY = lastBridgeDeckY + stepDeck;
                        }
                        if (segDeckY < lastBridgeDeckY - stepDeck) {
                            segDeckY = lastBridgeDeckY - stepDeck;
                        }
                    }
                    lastBridgeDeckY = segDeckY;
                    if (insideBridgeRange && i >= currentRangeEnd) {
                        insideBridgeRange = false;
                        currentRangeEnd = -1;
                        lastBridgeDeckY = null;
                    }
                    BridgeBuilder.placeSegment(world, seg, middle, prev, next, roadWidth, segDeckY, segmentIndex, random, cfg, placePier, placeRail);
                } else {
                    int averageY = baseYForThis;
                    for (BlockPos widthBlock : seg.positions()) {
                        BlockPos pos = new BlockPos(widthBlock.m_123341_(), averageY, widthBlock.m_123343_());
                        if (roadType == 1) {
                            List<BlockState> biomeMats = BiomeRoadMaterialSelector.forBiome(world, pos);
                            SurfacePlacementUtil.placeOnSurface(world, pos, biomeMats, 0, random, cfg);
                            continue;
                        }
                        SurfacePlacementUtil.placeOnSurface(world, pos, materials, 0, random, cfg);
                    }
                }
                if (roadType == 0) {
                    if (isBridge[i] && !cfg.bridgeKeepLamps()) continue;
                    ArtificialDecorationSystem.addDecoration(world, decorations, averaged, segmentIndex, next, prev, middlePositions, roadWidth, random, cfg);
                    continue;
                }
                if (isBridge[i] && !cfg.bridgeKeepLamps()) continue;
                NaturalDecorationSystem.addDecoration(world, decorations, averaged, segmentIndex, next, prev, middlePositions, roadWidth, random, cfg);
            }
        }
        RoadStructures.tryPlaceDecorations(decorations);
        return true;
    }
}

