/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.bridge;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.helpers.Records;

public final class BridgeBuilder {
    private static final BlockState DECK = Blocks.f_50222_.m_49966_();
    private static final BlockState RAIL = Blocks.f_50609_.m_49966_();
    private static final BlockState PIER = Blocks.f_50222_.m_49966_();

    private BridgeBuilder() {
    }

    public static void placeSegment(WorldGenLevel world, Records.RoadSegmentPlacement seg, BlockPos middle, BlockPos prev, BlockPos next, int roadWidth, int deckY, int segmentIndex, RandomSource random, ModConfig cfg, boolean placePier, boolean placeRail) {
        int interval;
        int radius = Math.max(1, roadWidth / 2);
        int sx = Integer.compare(next.m_123341_() - prev.m_123341_(), 0);
        int sz = Integer.compare(next.m_123343_() - prev.m_123343_(), 0);
        int ox = -sz;
        int oz = sx;
        BridgeBuilder.plotLine(prev.m_123341_(), prev.m_123343_(), middle.m_123341_(), middle.m_123343_(), (x, z) -> {
            for (int off = -radius; off <= radius; ++off) {
                int px = x + off * ox;
                int pz = z + off * oz;
                world.m_7731_(new BlockPos(px, deckY, pz), DECK, 3);
                if (sx == 0 || sz == 0) continue;
                world.m_7731_(new BlockPos(px + sx, deckY, pz), DECK, 3);
                world.m_7731_(new BlockPos(px, deckY, pz + sz), DECK, 3);
            }
        });
        for (BlockPos w : seg.positions()) {
            world.m_7731_(new BlockPos(w.m_123341_(), deckY, w.m_123343_()), DECK, 3);
        }
        if (placeRail && cfg.bridgeRailingEnabled()) {
            int leftOutX = -ox;
            int leftOutZ = -oz;
            BridgeBuilder.plotLine(prev.m_123341_() + -radius * ox, prev.m_123343_() + -radius * oz, middle.m_123341_() + -radius * ox, middle.m_123343_() + -radius * oz, (x, z) -> {
                if (!BridgeBuilder.hasDeck(world, x, deckY, z)) {
                    return;
                }
                if (BridgeBuilder.hasDeck(world, x + leftOutX, deckY, z + leftOutZ)) {
                    return;
                }
                if (!BridgeBuilder.hasDeck(world, x + sx, deckY, z + sz) && !BridgeBuilder.hasDeck(world, x - sx, deckY, z - sz)) {
                    return;
                }
                if (BridgeBuilder.deckNeighborCount(world, x, deckY, z) <= 1) {
                    return;
                }
                world.m_7731_(new BlockPos(x, deckY + 1, z), RAIL, 3);
            });
            int rightOutX = ox;
            int rightOutZ = oz;
            BridgeBuilder.plotLine(prev.m_123341_() + radius * ox, prev.m_123343_() + radius * oz, middle.m_123341_() + radius * ox, middle.m_123343_() + radius * oz, (x, z) -> {
                if (!BridgeBuilder.hasDeck(world, x, deckY, z)) {
                    return;
                }
                if (BridgeBuilder.hasDeck(world, x + rightOutX, deckY, z + rightOutZ)) {
                    return;
                }
                if (!BridgeBuilder.hasDeck(world, x + sx, deckY, z + sz) && !BridgeBuilder.hasDeck(world, x - sx, deckY, z - sz)) {
                    return;
                }
                if (BridgeBuilder.deckNeighborCount(world, x, deckY, z) <= 1) {
                    return;
                }
                world.m_7731_(new BlockPos(x, deckY + 1, z), RAIL, 3);
            });
        }
        if (placePier && segmentIndex % (interval = Math.max(3, cfg.bridgePierInterval())) == 0) {
            BridgeBuilder.placePierUnder(world, middle.m_123341_(), middle.m_123343_(), deckY - 1, cfg.bridgePierMaxHeight(), cfg.bridgePierWidth());
        }
    }

    private static boolean hasDeck(WorldGenLevel world, int x, int y, int z) {
        return world.m_8055_(new BlockPos(x, y, z)).m_60734_() == DECK.m_60734_();
    }

    private static int deckNeighborCount(WorldGenLevel world, int x, int y, int z) {
        int c = 0;
        if (BridgeBuilder.hasDeck(world, x + 1, y, z)) {
            ++c;
        }
        if (BridgeBuilder.hasDeck(world, x - 1, y, z)) {
            ++c;
        }
        if (BridgeBuilder.hasDeck(world, x, y, z + 1)) {
            ++c;
        }
        if (BridgeBuilder.hasDeck(world, x, y, z - 1)) {
            ++c;
        }
        return c;
    }

    private static void plotLine(int x0, int z0, int x1, int z1, LineConsumer consumer) {
        int dx = Math.abs(x1 - x0);
        int dz = Math.abs(z1 - z0);
        int sx = x0 < x1 ? 1 : -1;
        int sz = z0 < z1 ? 1 : -1;
        int err = dx - dz;
        int x = x0;
        int z = z0;
        while (true) {
            consumer.accept(x, z);
            if (x == x1 && z == z1) break;
            int e2 = 2 * err;
            if (e2 > -dz) {
                err -= dz;
                x += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            z += sz;
        }
    }

    private static void placePierUnder(WorldGenLevel world, int x, int z, int fromY, int maxHeight, int pierWidth) {
        int minY = world.m_141937_();
        int half = Math.max(0, pierWidth - 1);
        for (int dx = -half; dx <= half; ++dx) {
            for (int dz = -half; dz <= half; ++dz) {
                BlockPos cur;
                int y = fromY;
                for (int h = 0; y >= minY && h < maxHeight && !world.m_8055_(cur = new BlockPos(x + dx, y, z + dz)).m_60783_((BlockGetter)world, cur, Direction.UP); --y, ++h) {
                    world.m_7731_(cur, PIER, 3);
                }
            }
        }
    }

    @FunctionalInterface
    private static interface LineConsumer {
        public void accept(int var1, int var2);
    }
}

