/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.decoration.system;

import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.decoration.Decoration;
import net.shiroha233.roadweaver.features.decoration.DistanceSignDecoration;
import net.shiroha233.roadweaver.features.decoration.LamppostDecoration;
import net.shiroha233.roadweaver.features.decoration.system.SurfacePlacementUtil;

public final class ArtificialDecorationSystem {
    private static final int SIGN_INDEX_OFFSET = 65;
    private static final int SIDE_OFFSET = 2;

    private ArtificialDecorationSystem() {
    }

    public static void placeOnSurface(WorldGenLevel world, BlockPos placePos, List<BlockState> material, RandomSource random, ModConfig cfg) {
        SurfacePlacementUtil.placeOnSurface(world, placePos, material, 0, random, cfg);
    }

    public static void addDecoration(WorldGenLevel world, Set<Decoration> out, BlockPos placePos, int segmentIndex, BlockPos nextPos, BlockPos prevPos, List<BlockPos> middlePositions, int roadWidth, RandomSource random, ModConfig cfg) {
        boolean isStart;
        int dz;
        int dx = nextPos.m_123341_() - prevPos.m_123341_();
        double len = Math.sqrt((double)dx * (double)dx + (double)(dz = nextPos.m_123343_() - prevPos.m_123343_()) * (double)dz);
        int nx = len != 0.0 ? (int)Math.round((double)dx / len) : 0;
        int nz = len != 0.0 ? (int)Math.round((double)dz / len) : 0;
        Vec3i dir = new Vec3i(nx, 0, nz);
        Vec3i ortho = new Vec3i(-dir.m_123343_(), 0, dir.m_123341_());
        int halfWidth = Math.max(1, roadWidth / 2);
        int sideOffset = Math.max(2, halfWidth + 1);
        boolean bl = isStart = segmentIndex == 65;
        if (segmentIndex == 65 || segmentIndex == middlePositions.size() - 65) {
            BlockPos shifted = isStart ? placePos.m_7918_(ortho.m_123341_() * sideOffset, 0, ortho.m_123343_() * sideOffset) : placePos.m_7918_(-ortho.m_123341_() * sideOffset, 0, -ortho.m_123343_() * sideOffset);
            int dist = ArtificialDecorationSystem.computeApproxDistanceMeters(world, shifted, isStart, middlePositions);
            out.add(new DistanceSignDecoration(shifted, ortho, world, isStart, String.valueOf(dist)));
        } else {
            int interval = Math.max(1, cfg.lampInterval());
            if (segmentIndex % interval == 0) {
                boolean left = random.m_188499_();
                BlockPos shifted = left ? placePos.m_7918_(ortho.m_123341_() * sideOffset, 0, ortho.m_123343_() * sideOffset) : placePos.m_7918_(-ortho.m_123341_() * sideOffset, 0, -ortho.m_123343_() * sideOffset);
                if (Math.abs((shifted = new BlockPos(shifted.m_123341_(), world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, shifted.m_123341_(), shifted.m_123343_()), shifted.m_123343_())).m_123342_() - placePos.m_123342_()) > 1) {
                    return;
                }
                out.add(new LamppostDecoration(shifted, ortho, world, left));
            }
        }
    }

    private static int computeApproxDistanceMeters(WorldGenLevel world, BlockPos fromPos, boolean isStart, List<BlockPos> middlePositions) {
        BlockPos target = isStart ? middlePositions.get(middlePositions.size() - 1) : middlePositions.get(0);
        long dx = (long)target.m_123341_() - (long)fromPos.m_123341_();
        long dz = (long)target.m_123343_() - (long)fromPos.m_123343_();
        double d = Math.sqrt((double)dx * (double)dx + (double)dz * (double)dz);
        return (int)Math.round(d);
    }
}

