/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.decoration.system;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.decoration.RoadFeatureCompat;

public final class SurfacePlacementUtil {
    private SurfacePlacementUtil() {
    }

    public static void placeOnSurface(WorldGenLevel world, BlockPos placePos, List<BlockState> material, int roadType, RandomSource random, ModConfig cfg) {
        boolean doPlace;
        double naturalBlockChance = 1.0;
        BlockPos surfacePos = placePos;
        BlockPos belowTop = surfacePos.m_7495_();
        BlockState blockStateAtPos = world.m_8055_(belowTop);
        boolean bl = doPlace = roadType == 0 || random.m_188500_() < naturalBlockChance;
        if (doPlace) {
            SurfacePlacementUtil.placeRoadBlock(world, blockStateAtPos, surfacePos, material, random, cfg);
        } else {
            SurfacePlacementUtil.clearAboveColumn(world, surfacePos, cfg);
        }
    }

    public static void placeRoadBlock(WorldGenLevel world, BlockState blockBelow, BlockPos surfacePos, List<BlockState> materials, RandomSource random, ModConfig cfg) {
        if (!SurfacePlacementUtil.placeAllowedCheck(blockBelow.m_60734_())) {
            return;
        }
        BlockState chosen = materials.get(random.m_188503_(materials.size()));
        int MAX_CAUSEWAY_DEPTH = Math.max(0, Math.min(12, cfg == null ? 1 : cfg.causewayMaxDepth()));
        BlockPos below1 = surfacePos.m_7495_();
        BlockPos below2 = surfacePos.m_6625_(2);
        boolean sturdy1 = world.m_8055_(below1).m_60783_((BlockGetter)world, below1, Direction.UP);
        boolean sturdy2 = world.m_8055_(below2).m_60783_((BlockGetter)world, below2, Direction.UP);
        if (!sturdy1 && !sturdy2) {
            BlockPos fillStart;
            BlockPos cursor = below2;
            BlockPos base = null;
            for (int depth = 0; cursor.m_123342_() > world.m_141937_() && depth < MAX_CAUSEWAY_DEPTH; ++depth) {
                if (world.m_8055_(cursor).m_60783_((BlockGetter)world, cursor, Direction.UP)) {
                    base = cursor;
                    break;
                }
                cursor = cursor.m_7495_();
            }
            BlockPos blockPos = fillStart = base != null ? base.m_7494_() : below1.m_6625_(Math.min(MAX_CAUSEWAY_DEPTH - 1, Math.max(0, below1.m_123342_() - world.m_141937_())));
            if (fillStart.m_123342_() < world.m_141937_()) {
                fillStart = new BlockPos(fillStart.m_123341_(), world.m_141937_(), fillStart.m_123343_());
            }
            BlockPos pos = fillStart;
            while (pos.m_123342_() <= below1.m_123342_()) {
                world.m_7731_(pos, chosen, 3);
                pos = pos.m_7494_();
            }
        } else {
            world.m_7731_(below1, chosen, 3);
        }
        SurfacePlacementUtil.clearAboveColumn(world, surfacePos, cfg);
        BlockPos belowPos1 = surfacePos.m_6625_(2);
        BlockState belowState1 = world.m_8055_(belowPos1);
        if (belowState1.m_60713_(Blocks.f_50440_)) {
            world.m_7731_(belowPos1, Blocks.f_50493_.m_49966_(), 3);
        }
    }

    public static void clearAboveColumn(WorldGenLevel world, BlockPos surfacePos, ModConfig cfg) {
        boolean tunnel = cfg != null && cfg.tunnelEnabled();
        int maxH = tunnel ? Math.max(2, Math.min(16, cfg.tunnelClearHeight())) : 3;
        for (int i = 0; i < maxH; ++i) {
            BlockPos up = surfacePos.m_6630_(i);
            BlockState st = world.m_8055_(up);
            if (st.m_60795_() || cfg != null && cfg.removeWholeTreeOnPath() && (st.m_204336_(BlockTags.f_13106_) || st.m_60713_(Blocks.f_50571_) || SurfacePlacementUtil.isVineLike(st) || st.m_60713_(Blocks.f_50262_)) && SurfacePlacementUtil.fellTreeAt(world, up, cfg)) continue;
            if (tunnel) {
                if (!st.m_204336_(BlockTags.f_13035_) && !st.m_204336_(BlockTags.f_13106_) && st.m_60815_()) continue;
                world.m_7731_(up, Blocks.f_50016_.m_49966_(), 3);
                continue;
            }
            if (st.m_204336_(BlockTags.f_13106_) || st.m_204336_(BlockTags.f_13039_)) break;
            world.m_7731_(up, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    private static boolean fellTreeAt(WorldGenLevel world, BlockPos logStart, ModConfig cfg) {
        BlockPos down;
        BlockState downSt;
        if (cfg == null) {
            return false;
        }
        int radius = Math.max(2, Math.min(12, cfg.treeRemovalMaxRadius()));
        int maxH = Math.max(8, Math.min(64, cfg.treeRemovalMaxHeight()));
        int maxBlocks = Math.max(64, Math.min(8192, cfg.treeRemovalMaxBlocks()));
        int leavesConfirm = Math.max(0, Math.min(128, cfg.treeLeavesConfirm()));
        BlockState startState = world.m_8055_(logStart);
        if (!(startState.m_204336_(BlockTags.f_13106_) || startState.m_60713_(Blocks.f_50571_) || SurfacePlacementUtil.isVineLike(startState) || startState.m_60713_(Blocks.f_50262_) || startState.m_60713_(Blocks.f_152548_))) {
            return false;
        }
        BlockPos base = logStart;
        for (int steps = 0; steps < maxH && ((downSt = world.m_8055_(down = base.m_7495_())).m_204336_(BlockTags.f_13106_) || downSt.m_60713_(Blocks.f_50571_)); ++steps) {
            base = down;
        }
        int minX = base.m_123341_() - radius;
        int maxX = base.m_123341_() + radius;
        int minZ = base.m_123343_() - radius;
        int maxZ = base.m_123343_() + radius;
        int minY = Math.max(world.m_141937_(), base.m_123342_() - 1);
        int maxY = Math.min(world.m_151558_() - 1, base.m_123342_() + maxH);
        ArrayDeque<BlockPos> q = new ArrayDeque<BlockPos>();
        HashSet<Long> seen = new HashSet<Long>();
        ArrayList<BlockPos> toRemove = new ArrayList<BlockPos>();
        int leavesCount = 0;
        boolean hasBamboo = false;
        boolean hasVineLike = false;
        boolean hasCocoa = false;
        q.add(base);
        seen.add(base.m_121878_());
        while (!q.isEmpty() && toRemove.size() < maxBlocks) {
            BlockPos[] neigh;
            BlockPos p = (BlockPos)q.pollFirst();
            if (p.m_123341_() < minX || p.m_123341_() > maxX || p.m_123343_() < minZ || p.m_123343_() > maxZ || p.m_123342_() < minY || p.m_123342_() > maxY) continue;
            BlockState st = world.m_8055_(p);
            boolean isLog = st.m_204336_(BlockTags.f_13106_);
            boolean isLeaves = st.m_204336_(BlockTags.f_13035_);
            boolean isBamboo = st.m_60713_(Blocks.f_50571_);
            boolean isVine = SurfacePlacementUtil.isVineLike(st);
            boolean isCocoa = st.m_60713_(Blocks.f_50262_);
            boolean isHangingRoots = st.m_60713_(Blocks.f_152548_);
            if (!isLog && !isLeaves && !isBamboo && !isVine && !isCocoa && !isHangingRoots) continue;
            toRemove.add(p);
            if (isLeaves) {
                ++leavesCount;
            }
            if (isBamboo) {
                hasBamboo = true;
            }
            if (isVine) {
                hasVineLike = true;
            }
            if (isCocoa) {
                hasCocoa = true;
            }
            for (BlockPos n : neigh = new BlockPos[]{p.m_7494_(), p.m_7495_(), p.m_122012_(), p.m_122019_(), p.m_122029_(), p.m_122024_()}) {
                long key = n.m_121878_();
                if (!seen.add(key)) continue;
                q.addLast(n);
            }
        }
        if (toRemove.isEmpty()) {
            return false;
        }
        if (!(hasBamboo || hasVineLike || hasCocoa || leavesCount >= leavesConfirm)) {
            return false;
        }
        for (BlockPos p : toRemove) {
            world.m_7731_(p, Blocks.f_50016_.m_49966_(), 3);
        }
        return true;
    }

    private static boolean isVineLike(BlockState st) {
        return st.m_60713_(Blocks.f_50191_) || st.m_60713_(Blocks.f_152538_) || st.m_60713_(Blocks.f_152539_) || st.m_60713_(Blocks.f_50702_) || st.m_60713_(Blocks.f_50703_) || st.m_60713_(Blocks.f_50704_) || st.m_60713_(Blocks.f_50653_);
    }

    private static boolean placeAllowedCheck(Block block) {
        return !RoadFeatureCompat.dontPlaceHere(block) && !block.m_49966_().m_204336_(BlockTags.f_13035_) && !block.m_49966_().m_204336_(BlockTags.f_13106_) && !block.m_49966_().m_204336_(BlockTags.f_13050_) && !block.m_49966_().m_204336_(BlockTags.f_13098_) && !block.m_49966_().m_204336_(BlockTags.f_13090_);
    }
}

